/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.layouttpl.ui.policies;

import com.liferay.ide.eclipse.layouttpl.ui.cmd.PortletColumnChangeConstraintCommand;
import com.liferay.ide.eclipse.layouttpl.ui.cmd.PortletColumnCreateCommand;
import com.liferay.ide.eclipse.layouttpl.ui.cmd.PortletLayoutCreateCommand;
import com.liferay.ide.eclipse.layouttpl.ui.draw2d.FeedbackRoundedRectangle;
import com.liferay.ide.eclipse.layouttpl.ui.model.LayoutConstraint;
import com.liferay.ide.eclipse.layouttpl.ui.model.LayoutTplDiagram;
import com.liferay.ide.eclipse.layouttpl.ui.model.PortletColumn;
import com.liferay.ide.eclipse.layouttpl.ui.model.PortletLayout;
import com.liferay.ide.eclipse.layouttpl.ui.parts.PortletColumnEditPart;
import com.liferay.ide.eclipse.layouttpl.ui.parts.PortletLayoutEditPart;
import com.liferay.ide.eclipse.layouttpl.ui.util.LayoutTplUtil;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.ConstrainedLayoutEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;

public class PortletLayoutLayoutEditPolicy
extends ConstrainedLayoutEditPolicy {
    protected IFigure feedbackFigure;

    protected Command createChangeConstraintCommand(EditPart child, Object constraint) {
        if (constraint instanceof LayoutConstraint && child instanceof PortletColumnEditPart) {
            PortletColumnEditPart portletColumnPart = (PortletColumnEditPart)child;
            PortletLayoutEditPart parentPart = (PortletLayoutEditPart)portletColumnPart.getParent();
            return new PortletColumnChangeConstraintCommand(portletColumnPart.getCastedModel(), (PortletLayout)parentPart.getModel(), (PortletLayout)parentPart.getModel(), (LayoutConstraint)constraint);
        }
        return null;
    }

    protected IFigure createLayoutFeedbackFigure(Request request) {
        FeedbackRoundedRectangle feedback = null;
        if (request instanceof CreateRequest) {
            boolean isRowRequest = LayoutTplUtil.isCreateRequest(PortletLayout.class, request);
            boolean isColumnRequest = LayoutTplUtil.isCreateRequest(PortletColumn.class, request);
            LayoutConstraint constraint = (LayoutConstraint)this.getConstraintFor((CreateRequest)request);
            feedback = new FeedbackRoundedRectangle();
            Rectangle partBounds = this.getPart().getFigure().getBounds().getCopy();
            if (isRowRequest) {
                feedback.setSize(this.getContainerWidth(), 20);
                PortletLayoutEditPart layoutEditPart = (PortletLayoutEditPart)this.getHost();
                int currentRowIndex = LayoutTplUtil.getRowIndex(layoutEditPart);
                if (constraint.newRowIndex == currentRowIndex) {
                    partBounds.y -= feedback.getSize().height / 2;
                } else if (constraint.newRowIndex > currentRowIndex || constraint.newRowIndex == -1) {
                    partBounds.y = partBounds.y + partBounds.height - feedback.getSize().height / 2;
                }
                feedback.setLocation(new Point(partBounds.x, partBounds.y));
            } else if (isColumnRequest) {
                feedback.setSize(12, partBounds.height - 20);
                Point rectLocation = null;
                List children = this.getPart().getChildren();
                if (constraint.newColumnIndex >= children.size()) {
                    PortletColumnEditPart insertColumnPart = (PortletColumnEditPart)this.getPart().getChildren().get(constraint.newColumnIndex - 1);
                    Rectangle insertColumnRect = insertColumnPart.getFigure().getBounds();
                    rectLocation = new Point(insertColumnRect.x + insertColumnRect.width, insertColumnRect.y);
                } else {
                    int index = 0;
                    index = constraint.newColumnIndex > -1 ? constraint.newColumnIndex : this.getPart().getChildren().size() - 1;
                    PortletColumnEditPart insertColumnPart = (PortletColumnEditPart)this.getPart().getChildren().get(index);
                    Rectangle insertColumnRect = insertColumnPart.getFigure().getBounds();
                    rectLocation = new Point(insertColumnRect.x - feedback.getSize().width, insertColumnRect.y);
                }
                feedback.setLocation(rectLocation);
            }
        } else {
            boolean cfr_ignored_0 = request instanceof ChangeBoundsRequest;
        }
        return feedback;
    }

    protected int getContainerWidth() {
        return this.getPart().getFigure().getSize().width;
    }

    protected void eraseLayoutTargetFeedback(Request request) {
        super.eraseLayoutTargetFeedback(request);
        if (this.feedbackFigure != null) {
            this.removeFeedback(this.feedbackFigure);
            this.getFeedbackLayer().repaint();
            this.feedbackFigure = null;
        }
    }

    protected void showLayoutTargetFeedback(Request request) {
        super.showLayoutTargetFeedback(request);
        IFigure feedback = this.createLayoutFeedbackFigure(request);
        if (feedback != null && !feedback.equals(this.feedbackFigure)) {
            if (this.feedbackFigure != null) {
                this.removeFeedback(this.feedbackFigure);
            }
            this.feedbackFigure = feedback;
            this.addFeedback(this.feedbackFigure);
        }
    }

    protected PortletLayoutEditPart getPart() {
        return (PortletLayoutEditPart)this.getHost();
    }

    protected Object getConstraintFor(Point orgPoint) {
        int currentRowIndex;
        LayoutConstraint constraint = new LayoutConstraint();
        PortletLayoutEditPart layoutEditPart = (PortletLayoutEditPart)this.getHost();
        constraint.rowIndex = currentRowIndex = LayoutTplUtil.getRowIndex(layoutEditPart);
        List columns = layoutEditPart.getChildren();
        int numColumns = columns.size();
        Rectangle columnBounds = ((PortletColumnEditPart)columns.get(0)).getFigure().getBounds().getCopy();
        Point copyPoint = orgPoint.getCopy();
        copyPoint.translate(layoutEditPart.getFigure().getBounds().getLocation());
        int topColumnY = columnBounds.y;
        int bottomColumnY = topColumnY + ((PortletColumnEditPart)columns.get((int)0)).getFigure().getBounds().height;
        if (copyPoint.y > bottomColumnY) {
            constraint.newRowIndex = currentRowIndex + 1;
        } else if (copyPoint.y < topColumnY) {
            constraint.newRowIndex = currentRowIndex;
        } else {
            if (orgPoint.x < 0) {
                constraint.newColumnIndex = 0;
            } else {
                int i = 0;
                while (i < columns.size()) {
                    int xCoord = ((PortletColumnEditPart)columns.get((int)i)).getFigure().getBounds().x;
                    if (orgPoint.x < xCoord) {
                        constraint.newColumnIndex = i;
                        break;
                    }
                    ++i;
                }
                if (constraint.newColumnIndex == -1) {
                    constraint.newColumnIndex = numColumns;
                }
            }
            PortletColumnEditPart refColumnPart = null;
            refColumnPart = constraint.newColumnIndex < numColumns ? (PortletColumnEditPart)columns.get(constraint.newColumnIndex) : (PortletColumnEditPart)columns.get(constraint.newColumnIndex - 1);
            int refWeight = refColumnPart.getCastedModel().getWeight();
            int newWeight = -1;
            newWeight = refWeight != -1 ? refWeight / 2 : 50;
            constraint.weight = LayoutTplUtil.adjustWeight(newWeight);
            constraint.refColumn = refColumnPart.getCastedModel();
        }
        return constraint;
    }

    protected Object getConstraintFor(Rectangle rect) {
        PortletLayoutEditPart layoutEditPart = (PortletLayoutEditPart)this.getHost();
        List columns = layoutEditPart.getChildren();
        int numColumns = columns.size();
        LayoutConstraint constraint = new LayoutConstraint();
        constraint.rowIndex = LayoutTplUtil.getRowIndex(layoutEditPart);
        if (rect.x < 0) {
            constraint.newColumnIndex = 0;
        } else {
            int i = 0;
            while (i < columns.size()) {
                int xCoord = ((PortletColumnEditPart)columns.get((int)i)).getFigure().getBounds().x;
                if (rect.x < xCoord) {
                    constraint.newColumnIndex = i;
                    break;
                }
                ++i;
            }
            if (constraint.newColumnIndex == -1) {
                constraint.newColumnIndex = numColumns;
            }
        }
        PortletColumnEditPart refColumnPart = null;
        if (constraint.newColumnIndex > 0) {
            refColumnPart = (PortletColumnEditPart)columns.get(constraint.newColumnIndex - 1);
        } else if (constraint.newColumnIndex == 0) {
            refColumnPart = (PortletColumnEditPart)columns.get(1);
        }
        constraint.refColumn = refColumnPart.getCastedModel();
        int rowWidth = this.getHostFigure().getSize().width - 20;
        constraint.weight = LayoutTplUtil.adjustWeight((int)((double)rect.width / (double)rowWidth * 100.0));
        return constraint;
    }

    protected LayoutTplDiagram getDiagram() {
        return (LayoutTplDiagram)this.getHost().getParent().getModel();
    }

    protected Command getCreateCommand(CreateRequest request) {
        Object childClass = request.getNewObjectType();
        if (childClass == PortletColumn.class) {
            return new PortletColumnCreateCommand((PortletColumn)request.getNewObject(), this.getDiagram(), (LayoutConstraint)this.getConstraintFor(request));
        }
        if (childClass == PortletLayout.class) {
            return new PortletLayoutCreateCommand((PortletLayout)request.getNewObject(), (LayoutTplDiagram)this.getHost().getParent().getModel(), (LayoutConstraint)this.getConstraintFor(request));
        }
        return null;
    }

    protected Command getMoveChildrenCommand(Request request) {
        return null;
    }

    protected EditPolicy createChildEditPolicy(EditPart child) {
        return super.createChildEditPolicy(child);
    }
}

