/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.layouttpl.ui.util;

import com.liferay.ide.eclipse.core.util.CoreUtil;
import com.liferay.ide.eclipse.layouttpl.ui.model.ModelElement;
import com.liferay.ide.eclipse.layouttpl.ui.model.PortletColumn;
import com.liferay.ide.eclipse.layouttpl.ui.model.PortletLayout;
import com.liferay.ide.eclipse.layouttpl.ui.parts.LayoutTplDiagramEditPart;
import com.liferay.ide.eclipse.layouttpl.ui.parts.PortletLayoutEditPart;
import com.liferay.ide.eclipse.project.core.facet.IPluginFacetConstants;
import com.liferay.ide.eclipse.project.core.util.ProjectUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutTplUtil {
    public static IDOMElement[] findChildElementsByClassName(IDOMElement parentElement, String childElementTag, String className) {
        if (parentElement == null || !parentElement.hasChildNodes()) {
            return null;
        }
        ArrayList<IDOMElement> childElements = new ArrayList<IDOMElement>();
        NodeList divChildren = parentElement.getElementsByTagName(childElementTag);
        int i = 0;
        while (i < divChildren.getLength()) {
            IDOMElement childDivElement = (IDOMElement)divChildren.item(i);
            if (LayoutTplUtil.hasClassName(childDivElement, className)) {
                childElements.add(childDivElement);
            }
            ++i;
        }
        return childElements.toArray(new IDOMElement[0]);
    }

    public static IDOMElement findMainContentElement(IDOMDocument rootDocument) {
        if (rootDocument == null || !rootDocument.hasChildNodes()) {
            return null;
        }
        IDOMElement mainContentElement = null;
        mainContentElement = (IDOMElement)rootDocument.getElementById("main-content");
        return mainContentElement;
    }

    public static int getColumnIndex(PortletLayout currentParent, PortletColumn column) {
        if (currentParent == null || column == null) {
            return -1;
        }
        List<ModelElement> cols = currentParent.getColumns();
        int i = 0;
        while (i < cols.size()) {
            if (column.equals(cols.get(i))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static String getRoleValue(IDOMElement mainContentElement, String defaultValue) {
        String retval = defaultValue;
        String currentRoleValue = mainContentElement.getAttribute("role");
        if (!CoreUtil.isNullOrEmpty((String)currentRoleValue)) {
            retval = currentRoleValue;
        }
        return retval;
    }

    public static int getRowIndex(PortletLayoutEditPart layoutEditPart) {
        if (layoutEditPart == null) {
            return -1;
        }
        LayoutTplDiagramEditPart diagramPart = (LayoutTplDiagramEditPart)layoutEditPart.getParent();
        Object[] rows = diagramPart.getChildren().toArray();
        int i = 0;
        while (i < rows.length) {
            if (layoutEditPart.equals(rows[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int getWeightValue(IDOMElement portletColumnElement, int defaultValue) {
        int weightValue = defaultValue;
        if (portletColumnElement == null) {
            return weightValue;
        }
        String classAttr = portletColumnElement.getAttribute("class");
        if (CoreUtil.isNullOrEmpty((String)classAttr)) {
            return weightValue;
        }
        Pattern pattern = Pattern.compile(".*aui-w([-\\d]+).*");
        Matcher matcher = pattern.matcher(classAttr);
        if (matcher.matches()) {
            int remainder;
            block9: {
                String weightString = matcher.group(1);
                if (!CoreUtil.isNullOrEmpty((String)weightString)) {
                    try {
                        weightValue = Integer.parseInt(weightString);
                    }
                    catch (NumberFormatException numberFormatException) {
                        int index = weightString.indexOf(45);
                        if (index <= 0) break block9;
                        try {
                            int numerator = Integer.parseInt(weightString.substring(0, index));
                            int denominator = Integer.parseInt(weightString.substring(index + 1, weightString.length()));
                            weightValue = (int)((float)numerator / (float)denominator * 100.0f);
                        }
                        catch (NumberFormatException numberFormatException2) {}
                    }
                }
            }
            if ((remainder = weightValue % 5) != 0 && weightValue != 33 && weightValue != 66) {
                weightValue = remainder < 3 ? (weightValue -= remainder) : (weightValue += remainder);
            }
        }
        return weightValue;
    }

    public static boolean hasClassName(IDOMElement domElement, String className) {
        String classAttr;
        boolean retval = false;
        if (domElement != null && !CoreUtil.isNullOrEmpty((String)(classAttr = domElement.getAttribute("class")))) {
            retval = classAttr.contains(className);
        }
        return retval;
    }

    public static boolean isCreateRequest(Class<?> class1, Request request) {
        if (!(request instanceof CreateRequest)) {
            return false;
        }
        return ((CreateRequest)request).getNewObject().getClass() == class1;
    }

    public static boolean isLayoutTplProject(IProject project) {
        return ProjectUtil.hasFacet((IProject)project, (IProjectFacet)IPluginFacetConstants.LIFERAY_LAYOUTTPL_PROJECT_FACET);
    }

    public static int adjustWeight(int newWeight) {
        int retval = -1;
        retval = newWeight > 31 && newWeight < 34 ? 33 : (newWeight > 65 && newWeight < 69 ? 66 : (int)Math.round((double)newWeight / 5.0) * 5);
        return retval;
    }
}

