/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.layouttpl.ui.wizard;

import com.liferay.ide.eclipse.core.util.CoreUtil;
import com.liferay.ide.eclipse.layouttpl.core.operation.INewLayoutTplDataModelProperties;
import com.liferay.ide.eclipse.layouttpl.ui.LayoutTplUI;
import com.liferay.ide.eclipse.layouttpl.ui.util.LayoutTplUtil;
import com.liferay.ide.eclipse.ui.util.SWTUtil;
import com.liferay.ide.eclipse.ui.wizard.LiferayDataModelWizardPage;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.common.frameworks.datamodel.DataModelEvent;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelListener;

public class NewLayoutTplWizardPage
extends LiferayDataModelWizardPage
implements INewLayoutTplDataModelProperties {
    protected Text id;
    protected Text name;
    protected String projectName;
    protected Combo projectNameCombo;
    protected Label projectNameLabel;
    protected Text templateFile;
    protected Text thumbnailFile;
    protected Text wapTemplateFile;

    public NewLayoutTplWizardPage(IDataModel dataModel, String pageName) {
        super(dataModel, pageName, "Create Layout Template", LayoutTplUI.imageDescriptorFromPlugin((String)"com.liferay.ide.eclipse.layouttpl.ui", (String)"/icons/wizban/layout_template_wiz.png"));
        this.setDescription("Create a Liferay layout template.");
    }

    protected void createProjectNameGroup(Composite parent) {
        this.projectNameLabel = new Label(parent, 0);
        this.projectNameLabel.setText("Layout plugin project:");
        this.projectNameLabel.setLayoutData((Object)new GridData());
        this.projectNameCombo = new Combo(parent, 2056);
        GridData data = new GridData(768);
        data.widthHint = 300;
        data.horizontalSpan = 1;
        data.grabExcessHorizontalSpace = true;
        this.projectNameCombo.setLayoutData((Object)data);
        this.synchHelper.synchCombo(this.projectNameCombo, "IArtifactEditOperationDataModelProperties.PROJECT_NAME", null);
        String initialProjectName = this.initializeProjectList(this.projectNameCombo, this.model);
        if (this.projectName == null && initialProjectName != null) {
            this.projectName = initialProjectName;
        }
    }

    protected void createTemplateInfoGroup(Composite parent) {
        SWTUtil.createLabel((Composite)parent, (int)131072, (String)"Name:", (int)1);
        this.name = SWTUtil.createText((Composite)parent, (int)1);
        this.synchHelper.synchText(this.name, "INewLayoutTplModelProperties.LAYOUT_TEMPLATE_NAME", null);
        SWTUtil.createLabel((Composite)parent, (String)"", (int)1);
        SWTUtil.createLabel((Composite)parent, (int)131072, (String)"Id:", (int)1);
        this.id = SWTUtil.createText((Composite)parent, (int)1);
        this.synchHelper.synchText(this.id, "INewLayoutTplModelProperties.LAYOUT_TEMPLATE_ID", null);
        SWTUtil.createLabel((Composite)parent, (String)"", (int)1);
        SWTUtil.createLabel((Composite)parent, (int)131072, (String)"Template file:", (int)1);
        this.templateFile = SWTUtil.createText((Composite)parent, (int)1);
        this.synchHelper.synchText(this.templateFile, "INewLayoutTplModelProperties.LAYOUT_TEMPLATE_FILE", null);
        Button templateFileBrowse = SWTUtil.createPushButton((Composite)parent, (String)"Browse...", null);
        templateFileBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewLayoutTplWizardPage.this.handleFileBrowseButton(NewLayoutTplWizardPage.this.templateFile, "Template file selection", "Choose a template file: ");
            }
        });
        SWTUtil.createLabel((Composite)parent, (int)131072, (String)"WAP template file:", (int)1);
        this.wapTemplateFile = SWTUtil.createText((Composite)parent, (int)1);
        this.synchHelper.synchText(this.wapTemplateFile, "INewLayoutTplModelProperties.LAYOUT_WAP_TEMPLATE_FILE", null);
        Button wapTemplateFileBrowse = SWTUtil.createPushButton((Composite)parent, (String)"Browse...", null);
        wapTemplateFileBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewLayoutTplWizardPage.this.handleFileBrowseButton(NewLayoutTplWizardPage.this.wapTemplateFile, "WAP template file selection", "Choose a WAP template file: ");
            }
        });
        SWTUtil.createLabel((Composite)parent, (int)131072, (String)"Thumbnail file:", (int)1);
        this.thumbnailFile = SWTUtil.createText((Composite)parent, (int)1);
        this.synchHelper.synchText(this.thumbnailFile, "INewLayoutTplModelProperties.LAYOUT_THUMBNAIL_FILE", null);
        Button thumbnailFileBrowse = SWTUtil.createPushButton((Composite)parent, (String)"Browse...", null);
        thumbnailFileBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewLayoutTplWizardPage.this.handleFileBrowseButton(NewLayoutTplWizardPage.this.thumbnailFile, "WAP template file selection", "Choose a thumbnail file: ");
            }
        });
        this.synchHelper.getDataModel().addListener(new IDataModelListener(){

            public void propertyChanged(DataModelEvent event) {
                if ("INewLayoutTplModelProperties.LAYOUT_TEMPLATE_NAME".equals(event.getPropertyName()) || "INewLayoutTplModelProperties.LAYOUT_TEMPLATE_ID".equals(event.getPropertyName())) {
                    NewLayoutTplWizardPage.this.synchHelper.synchAllUIWithModel();
                }
            }
        });
    }

    protected Composite createTopLevelComposite(Composite parent) {
        Composite topComposite = SWTUtil.createTopComposite((Composite)parent, (int)3);
        this.createProjectNameGroup(topComposite);
        SWTUtil.createSeparator((Composite)topComposite, (int)3);
        this.createTemplateInfoGroup(topComposite);
        return topComposite;
    }

    protected void enter() {
        super.enter();
        this.validatePage(true);
    }

    protected IFolder getDocroot() {
        return CoreUtil.getDocroot((String)this.getDataModel().getStringProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME"));
    }

    protected String[] getValidationPropertyNames() {
        return new String[]{"IArtifactEditOperationDataModelProperties.PROJECT_NAME", "INewLayoutTplModelProperties.LAYOUT_TEMPLATE_NAME", "INewLayoutTplModelProperties.LAYOUT_TEMPLATE_ID", "INewLayoutTplModelProperties.LAYOUT_TEMPLATE_FILE", "INewLayoutTplModelProperties.LAYOUT_WAP_TEMPLATE_FILE", "INewLayoutTplModelProperties.LAYOUT_THUMBNAIL_FILE"};
    }

    protected boolean isProjectValid(IProject project) {
        return LayoutTplUtil.isLayoutTplProject(project);
    }

    protected boolean showValidationErrorsOnEnter() {
        return true;
    }
}

