/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.ui.editor;

import com.liferay.ide.eclipse.core.model.IBaseModel;
import com.liferay.ide.eclipse.core.model.IModelChangeProvider;
import com.liferay.ide.eclipse.ui.LiferayUIPlugin;
import com.liferay.ide.eclipse.ui.editor.IInputContextListener;
import com.liferay.ide.eclipse.ui.editor.IModelUndoManager;
import com.liferay.ide.eclipse.ui.editor.InputContext;
import com.liferay.ide.eclipse.ui.form.IDEFormEditor;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;

public abstract class InputContextManager
implements IResourceChangeListener {
    protected IDEFormEditor editor;
    private Hashtable inputContexts;
    private ArrayList monitoredFiles;
    private ArrayList listeners;
    private IModelUndoManager undoManager;

    public InputContextManager(IDEFormEditor editor) {
        this.editor = editor;
        this.inputContexts = new Hashtable();
        this.listeners = new ArrayList();
        LiferayUIPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
    }

    public void addInputContextListener(IInputContextListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeInputContextListener(IInputContextListener listener) {
        this.listeners.remove(listener);
    }

    public void dispose() {
        LiferayUIPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        Enumeration contexts = this.inputContexts.elements();
        while (contexts.hasMoreElements()) {
            InputContext context = (InputContext)contexts.nextElement();
            this.unhookUndo(context);
            context.dispose();
        }
        this.inputContexts.clear();
        this.undoManager = null;
    }

    public void save(IProgressMonitor monitor) {
        Enumeration contexts = this.inputContexts.elements();
        while (contexts.hasMoreElements()) {
            InputContext context = (InputContext)contexts.nextElement();
            if (!context.mustSave()) continue;
            context.doSave(monitor);
        }
    }

    public IProject getCommonProject() {
        Enumeration contexts = this.inputContexts.elements();
        while (contexts.hasMoreElements()) {
            InputContext context = (InputContext)contexts.nextElement();
            IEditorInput input = context.getInput();
            if (!(input instanceof IFileEditorInput)) continue;
            return ((IFileEditorInput)input).getFile().getProject();
        }
        return null;
    }

    public boolean hasContext(String id) {
        return this.findContext(id) != null;
    }

    public InputContext findContext(String id) {
        Enumeration contexts = this.inputContexts.elements();
        while (contexts.hasMoreElements()) {
            InputContext context = (InputContext)contexts.nextElement();
            if (!context.getId().equals(id)) continue;
            return context;
        }
        return null;
    }

    public InputContext findContext(IResource resource) {
        Enumeration contexts = this.inputContexts.elements();
        while (contexts.hasMoreElements()) {
            InputContext context = (InputContext)contexts.nextElement();
            if (!context.matches(resource)) continue;
            return context;
        }
        return null;
    }

    public abstract IBaseModel getModel();

    public InputContext getContext(IEditorInput input) {
        return (InputContext)this.inputContexts.get(input);
    }

    public void putContext(IEditorInput input, InputContext context) {
        this.inputContexts.put(input, context);
        this.fireContextChange(context, true);
    }

    private void updateInputContext(IEditorInput newInput, IEditorInput oldInput) throws Exception {
        Object value = null;
        if (!this.inputContexts.containsKey(oldInput)) {
            throw new Exception("Input context not found.");
        }
        value = this.inputContexts.remove(oldInput);
        this.inputContexts.put(newInput, value);
    }

    public void saveAs(IProgressMonitor monitor, String contextID) throws Exception {
        InputContext inputContext = this.findContext(contextID);
        if (inputContext == null) {
            throw new Exception("Input context not found.");
        }
        IEditorInput oldInput = this.editor.getEditorInput();
        inputContext.doSaveAs(monitor);
        IEditorInput newInput = inputContext.getInput();
        this.updateInputContext(newInput, oldInput);
    }

    public InputContext getPrimaryContext() {
        Enumeration contexts = this.inputContexts.elements();
        while (contexts.hasMoreElements()) {
            InputContext context = (InputContext)contexts.nextElement();
            if (!context.isPrimary()) continue;
            return context;
        }
        return null;
    }

    public InputContext[] getInvalidContexts() {
        ArrayList<InputContext> result = new ArrayList<InputContext>();
        Enumeration contexts = this.inputContexts.elements();
        while (contexts.hasMoreElements()) {
            InputContext context = (InputContext)contexts.nextElement();
            if (context.isModelCorrect()) continue;
            result.add(context);
        }
        return result.toArray(new InputContext[result.size()]);
    }

    public boolean isDirty() {
        Enumeration contexts = this.inputContexts.elements();
        while (contexts.hasMoreElements()) {
            InputContext context = (InputContext)contexts.nextElement();
            if (!context.mustSave()) continue;
            return true;
        }
        return false;
    }

    public void monitorFile(IFile file) {
        if (this.monitoredFiles == null) {
            this.monitoredFiles = new ArrayList();
        }
        this.monitoredFiles.add(file);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        try {
            delta.accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) {
                    int kind = delta.getKind();
                    IResource resource = delta.getResource();
                    if (resource instanceof IFile) {
                        if (kind == 1) {
                            InputContextManager.this.asyncStructureChanged((IFile)resource, true);
                        } else if (kind == 2) {
                            InputContextManager.this.asyncStructureChanged((IFile)resource, false);
                        }
                        return false;
                    }
                    return true;
                }
            });
        }
        catch (CoreException e) {
            LiferayUIPlugin.logError((Exception)((Object)e));
        }
    }

    private void asyncStructureChanged(final IFile file, final boolean added) {
        if (this.editor == null || this.editor.getEditorSite() == null) {
            return;
        }
        Shell shell = this.editor.getEditorSite().getShell();
        Display display = shell != null ? shell.getDisplay() : Display.getDefault();
        display.asyncExec(new Runnable(){

            public void run() {
                InputContextManager.this.structureChanged(file, added);
            }
        });
    }

    private void structureChanged(IFile file, boolean added) {
        if (this.monitoredFiles == null) {
            return;
        }
        int i = 0;
        while (i < this.monitoredFiles.size()) {
            IFile ifile = (IFile)this.monitoredFiles.get(i);
            if (ifile.equals((Object)file)) {
                if (added) {
                    this.fireStructureChange(file, true);
                } else {
                    this.fireStructureChange(file, false);
                    this.removeContext(file);
                }
            }
            ++i;
        }
    }

    private void removeContext(IFile file) {
        Enumeration contexts = this.inputContexts.elements();
        while (contexts.hasMoreElements()) {
            IFileEditorInput fileInput;
            InputContext context = (InputContext)contexts.nextElement();
            IEditorInput input = context.getInput();
            if (!(input instanceof IFileEditorInput) || !file.equals((Object)(fileInput = (IFileEditorInput)input).getFile())) continue;
            this.inputContexts.remove(input);
            this.fireContextChange(context, false);
            return;
        }
    }

    protected void fireStructureChange(IFile file, boolean added) {
        int i = 0;
        while (i < this.listeners.size()) {
            IInputContextListener listener = (IInputContextListener)this.listeners.get(i);
            if (added) {
                listener.monitoredFileAdded(file);
            } else {
                listener.monitoredFileRemoved(file);
            }
            ++i;
        }
    }

    protected void fireContextChange(InputContext context, boolean added) {
        int i = 0;
        while (i < this.listeners.size()) {
            IInputContextListener listener = (IInputContextListener)this.listeners.get(i);
            if (added) {
                listener.contextAdded(context);
            } else {
                listener.contextRemoved(context);
            }
            ++i;
        }
        if (added) {
            this.hookUndo(context);
        } else {
            this.unhookUndo(context);
        }
    }

    public void undo() {
        if (this.undoManager != null && this.undoManager.isUndoable()) {
            this.undoManager.undo();
        }
    }

    public void redo() {
        if (this.undoManager != null && this.undoManager.isRedoable()) {
            this.undoManager.redo();
        }
    }

    private void hookUndo(InputContext context) {
        if (this.undoManager == null) {
            return;
        }
        IBaseModel model = context.getModel();
        if (model instanceof IModelChangeProvider) {
            this.undoManager.connect((IModelChangeProvider)model);
        }
    }

    private void unhookUndo(InputContext context) {
        if (this.undoManager == null) {
            return;
        }
        IBaseModel model = context.getModel();
        if (model instanceof IModelChangeProvider) {
            this.undoManager.disconnect((IModelChangeProvider)model);
        }
    }

    public IModelUndoManager getUndoManager() {
        return this.undoManager;
    }

    public void setUndoManager(IModelUndoManager undoManager) {
        this.undoManager = undoManager;
    }
}

