/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.ui.wizard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class StringArrayTableWizardSection
extends Composite {
    protected TableViewer viewer;
    protected Button addButton;
    protected Button editButton;
    protected Button removeButton;
    protected String dialogTitle;
    protected String[] fieldLabels;
    protected IDataModel model;
    protected String propertyName;
    protected Image labelProviderImage;
    protected StringArrayDialogCallback callback;

    public StringArrayTableWizardSection(Composite parent, String title, String addButtonLabel, String removeButtonLabel, String[] labelsForText, Image labelProviderImage, IDataModel model, String propertyName) {
        this(parent, title, addButtonLabel, null, removeButtonLabel, labelsForText, labelProviderImage, model, propertyName);
    }

    public StringArrayTableWizardSection(Composite parent, String title, String addButtonLabel, String editButtonLabel, String removeButtonLabel, String[] labelsForText, Image labelProviderImage, IDataModel model, String propertyName) {
        this(parent, title, title, addButtonLabel, editButtonLabel, removeButtonLabel, labelsForText, labelsForText, labelProviderImage, model, propertyName);
    }

    public StringArrayTableWizardSection(Composite parent, String componentLabel, String dialogTitle, String addButtonLabel, String editButtonLabel, String removeButtonLabel, String[] columnTitles, String[] fieldLabels, Image labelProviderImage, IDataModel model, String propertyName) {
        super(parent, 0);
        this.dialogTitle = dialogTitle;
        this.fieldLabels = fieldLabels;
        this.labelProviderImage = labelProviderImage;
        this.model = model;
        this.propertyName = propertyName;
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 4;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(1808));
        Label titleLabel = new Label((Composite)this, 16384);
        titleLabel.setText(componentLabel);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        titleLabel.setLayoutData((Object)data);
        Table table = new Table((Composite)this, 67584);
        this.viewer = new TableViewer(table);
        table.setLayoutData((Object)new GridData(1808));
        this.viewer.setContentProvider((IContentProvider)new StringArrayListContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new StringArrayListLabelProvider());
        final Composite buttonCompo = new Composite((Composite)this, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        buttonCompo.setLayout((Layout)layout);
        buttonCompo.setLayoutData((Object)new GridData(1042));
        this.addButtonsToButtonComposite(buttonCompo, addButtonLabel, editButtonLabel, removeButtonLabel);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (StringArrayTableWizardSection.this.editButton != null) {
                    boolean enabled = ((IStructuredSelection)selection).size() == 1;
                    StringArrayTableWizardSection.this.editButton.setEnabled(enabled);
                }
                StringArrayTableWizardSection.this.removeButton.setEnabled(!selection.isEmpty());
            }
        });
        if (this.editButton != null) {
            this.viewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    StringArrayTableWizardSection.this.handleEditButtonSelected();
                }
            });
        }
        if (columnTitles.length > 1) {
            int i = 0;
            while (i < columnTitles.length) {
                TableColumn tableColumn = new TableColumn(table, 0);
                tableColumn.setText(columnTitles[i]);
                ++i;
            }
            table.setHeaderVisible(true);
            this.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    Table table = StringArrayTableWizardSection.this.viewer.getTable();
                    TableColumn[] columns = table.getColumns();
                    Point buttonArea = buttonCompo.computeSize(-1, -1);
                    Rectangle area = table.getParent().getClientArea();
                    Point preferredSize = StringArrayTableWizardSection.this.viewer.getTable().computeSize(-1, -1);
                    int width = area.width - 2 * table.getBorderWidth() - buttonArea.x - columns.length * 2;
                    if (preferredSize.y > area.height + table.getHeaderHeight()) {
                        Point vBarSize = table.getVerticalBar().getSize();
                        width -= vBarSize.x;
                    }
                    Point oldSize = table.getSize();
                    int consumeWidth = 0;
                    int i = 0;
                    while (i < columns.length) {
                        if (oldSize.x > area.width) {
                            consumeWidth = this.setColumntWidth(width, columns, consumeWidth, i);
                            table.setSize(area.width - buttonArea.x - columns.length * 2, area.height);
                        } else {
                            table.setSize(area.width - buttonArea.x - columns.length * 2, area.height);
                            consumeWidth = this.setColumntWidth(width, columns, consumeWidth, i);
                        }
                        ++i;
                    }
                }

                private int setColumntWidth(int width, TableColumn[] columns, int consumeWidth, int i) {
                    if (i < columns.length - 1) {
                        columns[i].setWidth(width / columns.length);
                        consumeWidth += columns[i].getWidth();
                    } else {
                        columns[i].setWidth(width - consumeWidth);
                    }
                    return consumeWidth;
                }
            });
        }
        this.callback = new StringArrayDialogCallbackAdapter();
    }

    protected void addButtonsToButtonComposite(Composite buttonCompo, String addButtonLabel, String editButtonLabel, String removeButtonLabel) {
        this.addButton = new Button(buttonCompo, 8);
        this.addButton.setText(addButtonLabel);
        this.addButton.setLayoutData((Object)new GridData(258));
        this.addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                StringArrayTableWizardSection.this.handleAddButtonSelected();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        if (editButtonLabel != null) {
            this.editButton = new Button(buttonCompo, 8);
            this.editButton.setText(editButtonLabel);
            this.editButton.setLayoutData((Object)new GridData(258));
            this.editButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent event) {
                    StringArrayTableWizardSection.this.handleEditButtonSelected();
                }

                public void widgetDefaultSelected(SelectionEvent event) {
                }
            });
            this.editButton.setEnabled(false);
        }
        this.removeButton = new Button(buttonCompo, 8);
        this.removeButton.setText(removeButtonLabel);
        this.removeButton.setLayoutData((Object)new GridData(258));
        this.removeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                StringArrayTableWizardSection.this.handleRemoveButtonSelected();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.removeButton.setEnabled(false);
    }

    protected void handleAddButtonSelected() {
        AddStringArrayDialog dialog = new AddStringArrayDialog(this.getShell(), this.dialogTitle, this.fieldLabels);
        dialog.open();
        String[] stringArray = dialog.getStringArray();
        this.addStringArray(stringArray);
    }

    protected void handleEditButtonSelected() {
        ISelection s = this.viewer.getSelection();
        if (!(s instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)s;
        if (selection.size() != 1) {
            return;
        }
        Object selectedObj = selection.getFirstElement();
        String[] valuesForText = (String[])selectedObj;
        EditStringArrayDialog dialog = new EditStringArrayDialog(this.getShell(), this.dialogTitle, this.fieldLabels, valuesForText);
        dialog.open();
        String[] stringArray = dialog.getStringArray();
        this.editStringArray(valuesForText, stringArray);
    }

    protected void handleRemoveButtonSelected() {
        ISelection selection = this.viewer.getSelection();
        if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            return;
        }
        List selectedObj = ((IStructuredSelection)selection).toList();
        this.removeStringArrays(selectedObj);
    }

    public void addStringArray(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        ArrayList<String[]> valueList = (ArrayList<String[]>)this.viewer.getInput();
        if (valueList == null) {
            valueList = new ArrayList<String[]>();
        }
        valueList.add(stringArray);
        this.setInput(valueList);
    }

    public void editStringArray(String[] oldStringArray, String[] newStringArray) {
        int index;
        if (newStringArray == null) {
            return;
        }
        ArrayList<String[]> valueList = (ArrayList<String[]>)this.viewer.getInput();
        if (valueList == null) {
            valueList = new ArrayList<String[]>();
        }
        if ((index = valueList.indexOf(oldStringArray)) == -1) {
            valueList.add(newStringArray);
        } else {
            valueList.set(index, newStringArray);
        }
        this.setInput(valueList);
    }

    public void removeStringArray(Object selectedStringArray) {
        List valueList = (List)this.viewer.getInput();
        valueList.remove(selectedStringArray);
        this.setInput(valueList);
    }

    public void removeStringArrays(Collection selectedStringArrays) {
        List valueList = (List)this.viewer.getInput();
        valueList.removeAll(selectedStringArrays);
        this.setInput(valueList);
    }

    public void setInput(List input) {
        this.viewer.setInput((Object)input);
        ArrayList newInput = new ArrayList();
        newInput.addAll(input);
        this.model.setProperty(this.propertyName, newInput);
    }

    public TableViewer getTableViewer() {
        return this.viewer;
    }

    public Button getAddButton() {
        return this.addButton;
    }

    public Button getEditButton() {
        return this.editButton;
    }

    public Button getRemoveButton() {
        return this.removeButton;
    }

    public void setCallback(StringArrayDialogCallback callback) {
        this.callback = callback;
    }

    public class AddStringArrayDialog
    extends Dialog
    implements ModifyListener {
        protected String windowTitle;
        protected String[] labelsForTextField;
        protected Text[] texts;
        protected String[] stringArray;
        protected int widthHint;

        public AddStringArrayDialog(Shell shell, String windowTitle, String[] labelsForTextField) {
            super(shell);
            this.widthHint = 300;
            this.windowTitle = windowTitle;
            this.labelsForTextField = labelsForTextField;
        }

        public Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            this.getShell().setText(this.windowTitle);
            GridLayout layout = new GridLayout();
            layout.numColumns = 3;
            composite.setLayout((Layout)layout);
            GridData data = new GridData();
            data.verticalAlignment = 4;
            data.horizontalAlignment = 4;
            data.widthHint = this.widthHint;
            composite.setLayoutData((Object)data);
            int n = this.labelsForTextField.length;
            this.texts = new Text[n];
            int i = 0;
            while (i < n) {
                this.texts[i] = this.createField(composite, i);
                ++i;
            }
            this.texts[0].setFocus();
            Dialog.applyDialogFont((Control)parent);
            return composite;
        }

        protected void setWidthHint(int hint) {
            this.widthHint = hint;
        }

        protected Text createField(Composite composite, int index) {
            Label label = new Label(composite, 16384);
            label.setText(this.labelsForTextField[index]);
            label.setLayoutData((Object)new GridData(32));
            Text text = new Text(composite, 2052);
            GridData data = new GridData(768);
            data.widthHint = 100;
            text.setLayoutData((Object)data);
            new Label(composite, 0);
            return text;
        }

        protected Control createContents(Composite parent) {
            Composite composite = (Composite)super.createContents(parent);
            int i = 0;
            while (i < this.texts.length) {
                this.texts[i].addModifyListener((ModifyListener)this);
                ++i;
            }
            this.updateOKButton();
            return composite;
        }

        protected void okPressed() {
            this.stringArray = StringArrayTableWizardSection.this.callback.retrieveResultStrings(this.texts);
            super.okPressed();
        }

        public String[] getStringArray() {
            return this.stringArray;
        }

        public void modifyText(ModifyEvent e) {
            this.updateOKButton();
        }

        private void updateOKButton() {
            this.getButton(0).setEnabled(StringArrayTableWizardSection.this.callback.validate(this.texts));
        }
    }

    protected class EditStringArrayDialog
    extends AddStringArrayDialog {
        protected String[] valuesForTextField;

        public EditStringArrayDialog(Shell shell, String windowTitle, String[] labelsForTextField, String[] valuesForTextField) {
            super(shell, windowTitle, labelsForTextField);
            this.valuesForTextField = valuesForTextField;
        }

        public Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            int n = this.valuesForTextField.length;
            int i = 0;
            while (i < n) {
                this.texts[i].setText(this.valuesForTextField[i]);
                ++i;
            }
            return composite;
        }
    }

    public static interface StringArrayDialogCallback {
        public boolean validate(Text[] var1);

        public String[] retrieveResultStrings(Text[] var1);
    }

    protected class StringArrayDialogCallbackAdapter
    implements StringArrayDialogCallback {
        protected StringArrayDialogCallbackAdapter() {
        }

        public boolean validate(Text[] texts) {
            return true;
        }

        public String[] retrieveResultStrings(Text[] texts) {
            int n = texts.length;
            String[] result = new String[n];
            int i = 0;
            while (i < n) {
                result[i] = texts[i].getText();
                ++i;
            }
            return result;
        }
    }

    protected class StringArrayListContentProvider
    implements IStructuredContentProvider {
        protected StringArrayListContentProvider() {
        }

        public boolean isDeleted(Object element) {
            return false;
        }

        public Object[] getElements(Object element) {
            if (element instanceof List) {
                return ((List)element).toArray();
            }
            return new Object[0];
        }

        public void inputChanged(Viewer aViewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    protected class StringArrayListLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        protected StringArrayListLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return StringArrayTableWizardSection.this.labelProviderImage;
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String[] array = (String[])element;
            return array[columnIndex];
        }

        public Image getImage(Object element) {
            return StringArrayTableWizardSection.this.labelProviderImage;
        }

        public String getText(Object element) {
            String[] array = (String[])element;
            if (array.length > 0) {
                return array[0];
            }
            return super.getText(element);
        }
    }
}

