/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.server.tomcat.core;

import com.liferay.ide.eclipse.core.util.CoreUtil;
import com.liferay.ide.eclipse.project.core.util.ProjectUtil;
import com.liferay.ide.eclipse.server.core.IPluginPublisher;
import com.liferay.ide.eclipse.server.core.LiferayServerCorePlugin;
import com.liferay.ide.eclipse.server.tomcat.core.ILiferayTomcatConstants;
import com.liferay.ide.eclipse.server.tomcat.core.ILiferayTomcatServer;
import com.liferay.ide.eclipse.server.tomcat.core.LiferayTomcatPlugin;
import com.liferay.ide.eclipse.server.tomcat.core.util.ExternalPropertiesConfiguration;
import com.liferay.ide.eclipse.server.util.ServerUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.jst.server.tomcat.core.internal.Tomcat60Handler;
import org.eclipse.jst.server.tomcat.core.internal.TomcatVersionHelper;
import org.eclipse.jst.server.tomcat.core.internal.xml.server40.ServerInstance;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LiferayTomcat60Handler
extends Tomcat60Handler {
    protected IServer currentServer;
    protected ILiferayTomcatServer portalServer;

    public IStatus canAddModule(IModule module) {
        IProjectFacet liferayFacet;
        IFacetedProject facetedProject;
        IProject project = module.getProject();
        if (project != null && (facetedProject = ProjectUtil.getFacetedProject((IProject)project)) != null && (liferayFacet = ProjectUtil.getLiferayFacet((IFacetedProject)facetedProject)) != null) {
            IStatus status;
            IPluginPublisher pluginPublisher;
            String facetId = liferayFacet.getId();
            IRuntime runtime = null;
            try {
                runtime = ServerUtil.getRuntime((IProject)project);
            }
            catch (CoreException coreException) {}
            if (runtime != null && (pluginPublisher = LiferayServerCorePlugin.getPluginPublisher((String)facetId, (String)runtime.getRuntimeType().getId())) != null && !(status = pluginPublisher.canPublishModule(this.currentServer, module)).isOK()) {
                return status;
            }
        }
        return super.canAddModule(module);
    }

    public String[] getRuntimeVMArguments(IPath installPath, IPath configPath, IPath deployPath, boolean isTestEnv) {
        ArrayList<String> runtimeVMArgs = new ArrayList<String>();
        this.addUserVMArgs(runtimeVMArgs);
        runtimeVMArgs.add("-Dfile.encoding=UTF8");
        runtimeVMArgs.add("-Dorg.apache.catalina.loader.WebappClassLoader.ENABLE_CLEAR_REFERENCES=false");
        runtimeVMArgs.add("-Djava.util.logging.manager=org.apache.juli.ClassLoaderLogManager");
        runtimeVMArgs.add("-Djava.security.auth.login.config=\"" + configPath.toOSString() + "/conf/jaas.config\"");
        runtimeVMArgs.add("-Djava.util.logging.config.file=\"" + installPath.toOSString() + "/conf/logging.properties\"");
        runtimeVMArgs.add("-Djava.io.tmpdir=\"" + installPath.toOSString() + "/temp\"");
        File externalPropertiesFile = this.getExternalPropertiesFile(installPath, configPath);
        runtimeVMArgs.add("-Dexternal-properties=\"" + externalPropertiesFile.getAbsolutePath() + "\"");
        Collections.addAll(runtimeVMArgs, super.getRuntimeVMArguments(installPath, configPath, deployPath, isTestEnv));
        return runtimeVMArgs.toArray(new String[runtimeVMArgs.size()]);
    }

    public void setCurrentServer(IServer server) {
        this.currentServer = server;
    }

    private void addUserVMArgs(List<String> runtimeVMArgs) {
        String[] memoryArgs = ILiferayTomcatConstants.DEFAULT_MEMORY_ARGS.split(" ");
        String userTimezone = ILiferayTomcatConstants.DEFAULT_USER_TIMEZONE;
        if (this.currentServer != null) {
            ILiferayTomcatServer portalTomcatServer = this.getPortalServer();
            memoryArgs = DebugPlugin.parseArguments((String)portalTomcatServer.getMemoryArgs());
            userTimezone = portalTomcatServer.getUserTimezone();
        }
        if (memoryArgs != null) {
            String[] stringArray = memoryArgs;
            int n = memoryArgs.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                runtimeVMArgs.add(arg);
                ++n2;
            }
        }
        runtimeVMArgs.add("-Duser.timezone=" + userTimezone);
    }

    private File getExternalPropertiesFile(IPath installPath, IPath configPath) {
        File retval = null;
        ILiferayTomcatServer portalServer = this.getPortalServer();
        if (portalServer != null) {
            File externalPropertiesFile;
            File portalIdePropFile;
            retval = portalIdePropFile = this.ensurePortalIDEPropertiesExists(installPath, configPath);
            String externalProperties = portalServer.getExternalProperties();
            if (!CoreUtil.isNullOrEmpty((String)externalProperties) && (externalPropertiesFile = this.setupExternalPropertiesFile(portalIdePropFile, externalProperties)) != null) {
                retval = externalPropertiesFile;
            }
        }
        return retval;
    }

    protected File ensurePortalIDEPropertiesExists(IPath installPath, IPath configPath) {
        ILiferayTomcatServer portalServer;
        IPath idePropertiesPath = installPath.append("../portal-ide.properties");
        String hostName = "localhost";
        try {
            ServerInstance server = TomcatVersionHelper.getCatalinaServerInstance((IPath)configPath.append("conf/server.xml"), null, null);
            hostName = server.getHost().getName();
        }
        catch (Exception e) {
            LiferayTomcatPlugin.logError((Throwable)e);
        }
        Properties props = new Properties();
        props.put("include-and-override", "portal-developer.properties");
        props.put("auto.deploy.tomcat.conf.dir", configPath.append("conf/Catalina/" + hostName).toOSString());
        if (this.currentServer != null && (portalServer = this.getPortalServer()) != null) {
            IPath runtimLocation = this.getServer().getRuntime().getLocation();
            String autoDeployDir = portalServer.getAutoDeployDirectory();
            if (!"../deploy".equals(autoDeployDir)) {
                Path autoDeployDirPath = new Path(autoDeployDir);
                if (autoDeployDirPath.isAbsolute() && autoDeployDirPath.toFile().exists()) {
                    props.put("auto.deploy.deploy.dir", portalServer.getAutoDeployDirectory());
                } else {
                    File autoDeployDirFile = new File(runtimLocation.toFile(), autoDeployDir);
                    if (autoDeployDirFile.exists()) {
                        props.put("auto.deploy.deploy.dir", autoDeployDirFile.getPath());
                    }
                }
            }
            props.put("auto.deploy.interval", portalServer.getAutoDeployInterval());
        }
        File file = idePropertiesPath.toFile();
        try {
            props.store(new FileOutputStream(file), null);
        }
        catch (Exception e) {
            LiferayTomcatPlugin.logError((Throwable)e);
        }
        return file;
    }

    protected ILiferayTomcatServer getPortalServer() {
        if (this.portalServer == null) {
            this.portalServer = (ILiferayTomcatServer)this.getServer().loadAdapter(ILiferayTomcatServer.class, null);
        }
        return this.portalServer;
    }

    protected IServer getServer() {
        return this.currentServer;
    }

    protected File setupExternalPropertiesFile(File portalIdePropFile, String externalPropertiesPath) {
        File retval = null;
        File externalPropertiesFile = new File(externalPropertiesPath);
        if (externalPropertiesFile.exists()) {
            ExternalPropertiesConfiguration props = new ExternalPropertiesConfiguration();
            try {
                props.load(new FileInputStream(externalPropertiesFile));
                props.setProperty("include-and-override", portalIdePropFile.getAbsolutePath());
                props.setHeader("# Last modified by Liferay IDE " + new Date());
                props.save(new FileOutputStream(externalPropertiesFile));
                retval = externalPropertiesFile;
            }
            catch (Exception exception) {
                retval = null;
            }
        } else {
            retval = null;
        }
        return retval;
    }
}

