/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.server.tomcat.core.util;

import com.liferay.ide.eclipse.core.util.CoreUtil;
import com.liferay.ide.eclipse.core.util.FileListing;
import com.liferay.ide.eclipse.core.util.FileUtil;
import com.liferay.ide.eclipse.project.core.util.ProjectUtil;
import com.liferay.ide.eclipse.server.core.LiferayServerCorePlugin;
import com.liferay.ide.eclipse.server.tomcat.core.ILiferayTomcatRuntime;
import com.liferay.ide.eclipse.server.tomcat.core.LiferayTomcatPlugin;
import com.liferay.ide.eclipse.server.tomcat.core.LiferayTomcatServerBehavior;
import com.liferay.ide.eclipse.server.util.PortalSupportHelper;
import com.liferay.ide.eclipse.ui.util.UIUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.jar.JarFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jst.server.tomcat.core.internal.xml.Factory;
import org.eclipse.jst.server.tomcat.core.internal.xml.server40.Context;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerListener;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerEvent;
import org.osgi.framework.Version;

public class LiferayTomcatUtil {
    public static void displayToggleMessage(String msg, String key) {
        UIUtil.postInfoWithToggle((String)"Liferay Tomcat Server", (String)msg, (String)"Do not show this message again", (boolean)false, (IPersistentPreferenceStore)LiferayTomcatPlugin.getPreferenceStore(), (String)key);
    }

    public static IPath[] getAllUserClasspathLibraries(IPath runtimeLocation, IPath portalDir) {
        ArrayList<Path> libs = new ArrayList<Path>();
        IPath libFolder = runtimeLocation.append("lib");
        IPath webinfLibFolder = portalDir.append("WEB-INF/lib");
        try {
            List libFiles = FileListing.getFileListing((File)new File(libFolder.toOSString()));
            for (File lib : libFiles) {
                if (!lib.exists() || !lib.getName().endsWith(".jar")) continue;
                libs.add(new Path(lib.getPath()));
            }
            libFiles = FileListing.getFileListing((File)new File(webinfLibFolder.toOSString()));
            for (File lib : libFiles) {
                if (!lib.exists() || !lib.getName().endsWith(".jar")) continue;
                libs.add(new Path(lib.getPath()));
            }
        }
        catch (FileNotFoundException e) {
            LiferayTomcatPlugin.logError((Throwable)e);
        }
        return libs.toArray(new IPath[0]);
    }

    public static Properties getCategories(IPath runtimeLocation, IPath portalDir) {
        Properties retval = null;
        File implJar = portalDir.append("WEB-INF/lib/portal-impl.jar").toFile();
        if (implJar.exists()) {
            try {
                JarFile jar = new JarFile(implJar);
                Properties categories = new Properties();
                Properties props = new Properties();
                props.load(jar.getInputStream(jar.getEntry("content/Language.properties")));
                Enumeration<?> names = props.propertyNames();
                while (names.hasMoreElements()) {
                    String name = names.nextElement().toString();
                    if (!name.startsWith("category.")) continue;
                    categories.put(name, props.getProperty(name));
                }
                retval = categories;
            }
            catch (IOException e) {
                LiferayTomcatPlugin.logError((Throwable)e);
            }
        }
        return retval;
    }

    public static ILiferayTomcatRuntime getLiferayTomcatRuntime(IRuntime runtime) {
        if (runtime != null) {
            return (ILiferayTomcatRuntime)runtime.createWorkingCopy().loadAdapter(ILiferayTomcatRuntime.class, null);
        }
        return null;
    }

    public static IPath getPortalDir(IPath appServerDir) {
        return appServerDir.append("/webapps/ROOT");
    }

    public static String[] getSupportedHookProperties(IPath runtimeLocation, IPath portalDir) throws IOException {
        String[] hookProperties;
        IPath hookPropertiesPath = LiferayTomcatPlugin.getDefault().getStateLocation().append("hook_properties").append(String.valueOf(runtimeLocation.toPortableString().replaceAll("\\/", "_")) + "_hook_properties.txt");
        IPath errorPath = LiferayTomcatPlugin.getDefault().getStateLocation().append("hookError.log");
        File hookPropertiesFile = hookPropertiesPath.toFile();
        File errorFile = errorPath.toFile();
        if (!hookPropertiesFile.exists()) {
            LiferayTomcatUtil.loadHookPropertiesFile(runtimeLocation, portalDir, hookPropertiesFile, errorFile);
        }
        if ((hookProperties = FileUtil.readLinesFromFile((File)hookPropertiesFile)).length == 0) {
            LiferayTomcatUtil.loadHookPropertiesFile(runtimeLocation, portalDir, hookPropertiesFile, errorFile);
            hookProperties = FileUtil.readLinesFromFile((File)hookPropertiesFile);
        }
        return hookProperties;
    }

    public static String getVersion(IPath location, IPath portalDir) throws IOException {
        File versionFile;
        IPath versionsInfoPath = LiferayTomcatPlugin.getDefault().getStateLocation().append("version.properties");
        String locationKey = location.toPortableString().replaceAll("\\/", "_");
        File versionInfoFile = versionsInfoPath.toFile();
        Properties properties = new Properties();
        if (versionInfoFile.exists()) {
            try {
                properties.load(new FileInputStream(versionInfoFile));
                String version = (String)properties.get(locationKey);
                if (!CoreUtil.isNullOrEmpty((String)version)) {
                    return version;
                }
            }
            catch (Exception exception) {}
        }
        if ((versionFile = LiferayTomcatPlugin.getDefault().getStateLocation().append("version.txt").toFile()).exists()) {
            FileUtil.clearContents((File)versionFile);
        }
        IPath errorPath = LiferayTomcatPlugin.getDefault().getStateLocation().append("versionError.log");
        File errorFile = errorPath.toFile();
        LiferayTomcatUtil.loadVersionInfoFile(location, portalDir, versionFile, errorFile);
        Version version = CoreUtil.readVersionFile((File)versionFile);
        if (version.equals((Object)Version.emptyVersion)) {
            LiferayTomcatUtil.loadVersionInfoFile(location, portalDir, versionInfoFile, errorFile);
            version = CoreUtil.readVersionFile((File)versionInfoFile);
        }
        if (!version.equals((Object)Version.emptyVersion)) {
            properties.put(locationKey, version.toString());
            try {
                properties.store(new FileOutputStream(versionInfoFile), "");
            }
            catch (Exception exception) {}
        }
        return version.toString();
    }

    public static boolean isExtProjectContext(Context context) {
        return false;
    }

    public static boolean isLiferayModule(IModule module) {
        boolean retval = false;
        if (module != null) {
            IProject project = module.getProject();
            retval = ProjectUtil.isLiferayProject((IProject)project);
        }
        return retval;
    }

    public static Context loadContextFile(File contextFile) {
        Context context;
        block14: {
            FileInputStream fis = null;
            context = null;
            if (contextFile != null && contextFile.exists()) {
                try {
                    try {
                        String path;
                        Factory factory = new Factory();
                        factory.setPackageName("org.eclipse.jst.server.tomcat.core.internal.xml.server40");
                        fis = new FileInputStream(contextFile);
                        context = (Context)factory.loadDocument((InputStream)fis);
                        if (context != null && (path = context.getPath()) == null) {
                            String fileName = contextFile.getName();
                            path = fileName.substring(0, fileName.length() - ".xml".length());
                            if ("ROOT".equals(path)) {
                                path = "";
                            }
                            context.setPath("/" + path);
                        }
                    }
                    catch (Exception exception) {
                        try {
                            fis.close();
                        }
                        catch (IOException iOException) {}
                        break block14;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return context;
    }

    public static void loadHookPropertiesFile(IPath runtimeLocation, IPath portalDir, File hookPropertiesFile, File errorFile) throws IOException {
        String portalSupportClass = "com.liferay.ide.eclipse.server.core.support.GetSupportedHookProperties";
        IPath[] libRoots = new IPath[]{runtimeLocation.append("lib"), runtimeLocation.append("lib/ext")};
        URL[] urls = new URL[]{FileLocator.toFileURL((URL)LiferayServerCorePlugin.getDefault().getBundle().getEntry("portal-support/portal-support.jar"))};
        PortalSupportHelper helper = new PortalSupportHelper(libRoots, portalDir, portalSupportClass, hookPropertiesFile, errorFile, urls, new String[0]);
        try {
            helper.launch(null);
        }
        catch (CoreException e) {
            LiferayTomcatPlugin.logError((Throwable)e);
        }
    }

    public static void loadVersionInfoFile(IPath runtimeLocation, IPath portalDir, File versionInfoFile, File errorFile) throws IOException {
        String portalSupportClass = "com.liferay.ide.eclipse.server.core.support.ReleaseInfoGetVersion";
        IPath[] libRoots = new IPath[]{runtimeLocation.append("lib"), runtimeLocation.append("lib/ext")};
        URL[] urls = new URL[]{FileLocator.toFileURL((URL)LiferayServerCorePlugin.getDefault().getBundle().getEntry("portal-support/portal-support.jar"))};
        PortalSupportHelper helper = new PortalSupportHelper(libRoots, portalDir, portalSupportClass, versionInfoFile, errorFile, urls, new String[0]);
        try {
            helper.launch(null);
        }
        catch (CoreException e) {
            LiferayTomcatPlugin.logError((Throwable)e);
        }
    }

    public static IPath modifyLocationForBundle(IPath currentLocation) {
        Path modifiedLocation = null;
        if (currentLocation == null || CoreUtil.isNullOrEmpty((String)currentLocation.toOSString())) {
            return null;
        }
        File location = currentLocation.toFile();
        if (location.exists() && location.isDirectory()) {
            File[] files = location.listFiles();
            boolean[] matches = new boolean[3];
            String[] patterns = new String[]{"data", "deploy", "^tomcat-.*"};
            File tomcatDir = null;
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                int i = 0;
                while (i < patterns.length) {
                    if (file.isDirectory() && file.getName().matches(patterns[i])) {
                        matches[i] = true;
                        if (i != 2) break;
                        tomcatDir = file;
                        break;
                    }
                    ++i;
                }
                ++n2;
            }
            if (matches[0] && matches[1] && matches[2] && tomcatDir != null) {
                modifiedLocation = new Path(tomcatDir.getPath());
            }
        }
        return modifiedLocation;
    }

    public static void syncStopServer(final IServer server) {
        if (server.getServerState() != 2) {
            return;
        }
        final LiferayTomcatServerBehavior serverBehavior = (LiferayTomcatServerBehavior)((Object)server.loadAdapter(LiferayTomcatServerBehavior.class, null));
        Thread shutdownThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                serverBehavior.stop(true);
                IServer iServer = server;
                synchronized (iServer) {
                    try {
                        server.wait(5000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        };
        IServerListener shutdownListener = new IServerListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void serverChanged(ServerEvent event) {
                if (event.getState() == 4) {
                    IServer iServer = server;
                    synchronized (iServer) {
                        server.notifyAll();
                    }
                }
            }
        };
        server.addServerListener(shutdownListener);
        try {
            shutdownThread.start();
            shutdownThread.join();
        }
        catch (InterruptedException interruptedException) {}
        server.removeServerListener(shutdownListener);
    }

    public static IStatus validateRuntimeStubLocation(IPath runtimeStubLocation) {
        try {
            IRuntimeWorkingCopy runtimeStub = ServerCore.findRuntimeType((String)"com.liferay.ide.eclipse.server.tomcat.runtime.60").createRuntime(null, null);
            runtimeStub.setLocation(runtimeStubLocation);
            runtimeStub.setStub(true);
            return runtimeStub.validate(null);
        }
        catch (Exception e) {
            return LiferayTomcatPlugin.createErrorStatus((Exception)e);
        }
    }
}

