/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ImageData;
import org.eclipse.sapphire.ui.SapphireEditor;
import org.eclipse.sapphire.ui.SapphireEditorPagePart;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.SapphirePartEvent;
import org.eclipse.sapphire.ui.SapphirePartListener;
import org.eclipse.sapphire.ui.renderers.swt.SwtRendererUtil;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public abstract class SapphireEditorFormPage
extends FormPage {
    private final SapphireEditor editor;
    private final SapphireEditorPagePart part;
    private final SapphirePartListener listener;

    public SapphireEditorFormPage(SapphireEditor editor, SapphireEditorPagePart editorPagePart) {
        super((FormEditor)editor, null, null);
        this.editor = editor;
        this.part = editorPagePart;
        this.listener = new SapphirePartListener(){

            public void handleEvent(SapphirePartEvent event) {
                if (event instanceof SapphirePart.ImageChangedEvent) {
                    SapphireEditorFormPage.this.refreshImage();
                }
            }
        };
        this.part.addListener(this.listener);
    }

    public final SapphireEditor getEditor() {
        return this.editor;
    }

    public SapphireEditorPagePart getPart() {
        return this.part;
    }

    public final IModelElement getModelElement() {
        return this.part.getModelElement();
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.refreshImage();
    }

    private final void refreshImage() {
        if (this.getManagedForm() != null) {
            ImageData newImageData;
            ScrolledForm form = this.getManagedForm().getForm();
            Image oldImage = form.getImage();
            if (oldImage != null) {
                oldImage.dispose();
            }
            if ((newImageData = this.part.getPageHeaderImage()) == null) {
                form.setImage(null);
            } else {
                form.setImage(SwtRendererUtil.toImageDescriptor(newImageData).createImage());
            }
        }
    }

    public void dispose() {
        Image image;
        super.dispose();
        this.part.removeListener(this.listener);
        if (this.getManagedForm() != null && (image = this.getManagedForm().getForm().getImage()) != null) {
            image.dispose();
        }
    }

    public abstract String getId();
}

