/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import java.lang.reflect.Field;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelPropertyChangeEvent;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.ui.SapphirePageBook;
import org.eclipse.sapphire.ui.def.ISapphirePageBookExtDef;
import org.eclipse.sapphire.ui.def.ISapphireUiDef;

public final class SapphireEnumControlledPageBook
extends SapphirePageBook {
    private ValueProperty property;

    protected void init() {
        super.init();
        this.property = (ValueProperty)this.resolve(((ISapphirePageBookExtDef)this.definition).getControlProperty().getText());
        this.setExposePageValidationState(true);
        this.updateCurrentPage();
    }

    protected Object parsePageKey(String panelKeyString) {
        Field field;
        int lastDot = panelKeyString.lastIndexOf(46);
        String className = panelKeyString.substring(0, lastDot);
        String enumItemName = panelKeyString.substring(lastDot + 1);
        ISapphireUiDef rootdef = (ISapphireUiDef)this.definition.nearest(ISapphireUiDef.class);
        Class<?> classObject = rootdef.resolveClass(className);
        try {
            field = classObject.getField(enumItemName);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        try {
            return field.get(null);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    protected void handleModelElementChange(ModelPropertyChangeEvent event) {
        super.handleModelElementChange(event);
        if (event.getProperty() == this.property) {
            this.updateCurrentPage();
        }
    }

    private void updateCurrentPage() {
        IModelElement modelElement = this.getModelElement();
        Value newEnumItemValue = modelElement.read(this.property);
        Enum newEnumItem = (Enum)newEnumItemValue.getContent(true);
        this.changePage(modelElement, newEnumItem);
    }
}

