/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.def.ISapphireLabelDef;
import org.eclipse.sapphire.ui.swt.SapphireTextPopup;
import org.eclipse.sapphire.ui.swt.renderer.GridLayoutUtil;
import org.eclipse.sapphire.ui.swt.renderer.SwtUtil;
import org.eclipse.sapphire.ui.swt.renderer.internal.formtext.SapphireFormText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;

public final class SapphireLabel
extends SapphirePart {
    private static final String BREAK_TOKEN = "###brk###";
    private SapphireFormText labelFormText;
    private String labelExtendedContent;
    private FunctionResult labelFunctionResult;

    public void render(SapphireRenderingContext context) {
        ISapphireLabelDef def = (ISapphireLabelDef)this.definition;
        this.labelFormText = new SapphireFormText(context.getComposite(), 0);
        this.labelFormText.setLayoutData(GridLayoutUtil.gdhindent(GridLayoutUtil.gdwhint(GridLayoutUtil.gdhspan(GridLayoutUtil.gdhfill(), 2), 100), 9));
        context.adapt((Control)this.labelFormText);
        this.labelFunctionResult = this.initExpression(this.getModelElement(), (Function)def.getText().getContent(), String.class, null, new Runnable(){

            public void run() {
                SapphireLabel.this.refreshLabel();
            }
        });
        this.labelFormText.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent event) {
                SapphireLabel.this.activateExtendedDescriptionContentPopup();
            }
        });
        this.refreshLabel();
        SwtUtil.reflowOnResize((Control)this.labelFormText);
    }

    private void refreshLabel() {
        String description = null;
        if (this.labelFunctionResult != null) {
            description = (String)this.labelFunctionResult.value();
        }
        description = description == null ? "#null#" : description.trim();
        int index = description.indexOf(BREAK_TOKEN);
        StringBuilder buf = new StringBuilder();
        buf.append("<form><p vspace=\"false\">");
        if (index > 0) {
            String displayDescription = description.substring(0, index);
            buf.append(displayDescription);
            if (!displayDescription.endsWith(" ")) {
                buf.append(" ");
            }
            buf.append("<a href=\"action\" nowrap=\"true\">");
            buf.append(Resources.moreDetails);
            buf.append("</a>");
            this.labelExtendedContent = String.valueOf(displayDescription) + description.substring(index + BREAK_TOKEN.length(), description.length());
        } else {
            buf.append(description);
            this.labelExtendedContent = null;
        }
        buf.append("</p></form>");
        this.labelFormText.setText(buf.toString(), true, false);
    }

    private void activateExtendedDescriptionContentPopup() {
        if (this.labelExtendedContent != null) {
            Point position;
            Point cursor = this.labelFormText.getDisplay().getCursorLocation();
            Rectangle bounds = this.labelFormText.getBounds();
            Point location = this.labelFormText.toDisplay(new Point(bounds.x, bounds.y));
            Rectangle displayBounds = new Rectangle(location.x, location.y, bounds.width, bounds.height);
            if (displayBounds.contains(cursor)) {
                position = cursor;
            } else {
                System.out.println("not in displayBounds: ");
                position = cursor;
            }
            SapphireTextPopup popup = new SapphireTextPopup(this.labelFormText.getShell(), position);
            popup.setText(this.labelExtendedContent);
            popup.open();
        }
    }

    private static final class Resources
    extends NLS {
        public static String moreDetails;

        static {
            Resources.initializeMessages((String)SapphireLabel.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

