/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.help.IContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.java.JavaType;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ImageData;
import org.eclipse.sapphire.modeling.ModelElementListener;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.ModelPath;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ModelPropertyChangeEvent;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.el.FailSafeFunction;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.el.Literal;
import org.eclipse.sapphire.modeling.el.ModelElementFunctionContext;
import org.eclipse.sapphire.modeling.localization.LocalizationService;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.ProblemOverlayImageDescriptor;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireActionGroup;
import org.eclipse.sapphire.ui.SapphireActionLink;
import org.eclipse.sapphire.ui.SapphireComposite;
import org.eclipse.sapphire.ui.SapphireDialogPart;
import org.eclipse.sapphire.ui.SapphireEnumControlledPageBook;
import org.eclipse.sapphire.ui.SapphireGroup;
import org.eclipse.sapphire.ui.SapphireHtmlPanel;
import org.eclipse.sapphire.ui.SapphireIfElseDirective;
import org.eclipse.sapphire.ui.SapphireImageCache;
import org.eclipse.sapphire.ui.SapphireLabel;
import org.eclipse.sapphire.ui.SapphireListControlledPageBook;
import org.eclipse.sapphire.ui.SapphirePartContainer;
import org.eclipse.sapphire.ui.SapphirePartEvent;
import org.eclipse.sapphire.ui.SapphirePartListener;
import org.eclipse.sapphire.ui.SapphirePropertyEditor;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.SapphireSeparator;
import org.eclipse.sapphire.ui.SapphireSpacer;
import org.eclipse.sapphire.ui.SapphireStaticTextField;
import org.eclipse.sapphire.ui.SapphireWithDirective;
import org.eclipse.sapphire.ui.SapphireWithDirectiveHelper;
import org.eclipse.sapphire.ui.SapphireWithDirectiveImplied;
import org.eclipse.sapphire.ui.SapphireWizardPagePart;
import org.eclipse.sapphire.ui.TabGroupPart;
import org.eclipse.sapphire.ui.def.IFormPartInclude;
import org.eclipse.sapphire.ui.def.ISapphireActionLinkDef;
import org.eclipse.sapphire.ui.def.ISapphireCompositeDef;
import org.eclipse.sapphire.ui.def.ISapphireCustomPartDef;
import org.eclipse.sapphire.ui.def.ISapphireDialogDef;
import org.eclipse.sapphire.ui.def.ISapphireGroupDef;
import org.eclipse.sapphire.ui.def.ISapphireHtmlPanelDef;
import org.eclipse.sapphire.ui.def.ISapphireIfElseDirectiveDef;
import org.eclipse.sapphire.ui.def.ISapphireLabelDef;
import org.eclipse.sapphire.ui.def.ISapphirePageBookExtDef;
import org.eclipse.sapphire.ui.def.ISapphireParam;
import org.eclipse.sapphire.ui.def.ISapphirePartDef;
import org.eclipse.sapphire.ui.def.ISapphirePartListenerDef;
import org.eclipse.sapphire.ui.def.ISapphirePropertyEditorDef;
import org.eclipse.sapphire.ui.def.ISapphireSeparatorDef;
import org.eclipse.sapphire.ui.def.ISapphireSpacerDef;
import org.eclipse.sapphire.ui.def.ISapphireStaticTextFieldDef;
import org.eclipse.sapphire.ui.def.ISapphireTabGroupDef;
import org.eclipse.sapphire.ui.def.ISapphireWithDirectiveDef;
import org.eclipse.sapphire.ui.def.ISapphireWizardPageDef;
import org.eclipse.sapphire.ui.def.PageBookPartControlMethod;
import org.eclipse.sapphire.ui.internal.SapphireUiFrameworkPlugin;
import org.eclipse.sapphire.ui.renderers.swt.SwtRendererUtil;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SapphirePart
implements ISapphirePart {
    private ISapphirePart parent;
    private IModelElement modelElement;
    protected ISapphirePartDef definition;
    protected Map<String, String> params;
    private ModelElementListener modelElementListener;
    private Status validationState;
    private Set<SapphirePartListener> listeners;
    private SapphireImageCache imageCache;
    private Map<String, SapphireActionGroup> actions;

    public final void init(ISapphirePart parent, IModelElement modelElement, ISapphirePartDef definition, Map<String, String> params) {
        this.parent = parent;
        this.definition = definition;
        this.params = params;
        SapphireImageCache sapphireImageCache = this.imageCache = this.parent == null ? new SapphireImageCache() : this.parent.getImageCache();
        if (modelElement == null) {
            throw new IllegalArgumentException();
        }
        this.modelElement = modelElement;
        this.modelElementListener = new ModelElementListener(){

            public void propertyChanged(ModelPropertyChangeEvent event) {
                SapphirePart.this.handleModelElementChange(event);
            }
        };
        this.modelElement.addListener(this.modelElementListener);
        this.validationState = Status.createOkStatus();
        this.listeners = null;
        for (ISapphirePartListenerDef listenerDefinition : definition.getListeners()) {
            JavaType listenerClass = (JavaType)listenerDefinition.getListenerClass().resolve();
            if (listenerClass == null) continue;
            Object listener = null;
            try {
                listener = listenerClass.artifact().newInstance();
            }
            catch (Exception e) {
                String msg = NLS.bind((String)Resources.failedToInstantiate, (Object)listenerClass.name());
                SapphireUiFrameworkPlugin.logError(msg, e);
            }
            if (listener == null) continue;
            if (listener instanceof SapphirePartListener) {
                this.addListener(listener);
                continue;
            }
            String msg = NLS.bind((String)Resources.doesNotExtend, (Object)listenerClass.name());
            SapphireUiFrameworkPlugin.logError(msg);
        }
        this.init();
        this.updateValidationState();
    }

    protected void init() {
    }

    protected final FunctionResult initExpression(IModelElement contextModelElement, Function function, Class<?> expectedType, Function defaultValue, final Runnable refreshOp) {
        Literal f = function == null ? Literal.NULL : function;
        f = FailSafeFunction.create((Function)f, (Function)Literal.create(expectedType), (Function)defaultValue);
        ModelElementFunctionContext context = new ModelElementFunctionContext(contextModelElement, (LocalizationService)this.definition.adapt(LocalizationService.class)){

            public FunctionResult property(Object element, String name) {
                if (name.equalsIgnoreCase("params")) {
                    return Literal.create(SapphirePart.this.params).evaluate((FunctionContext)this);
                }
                return super.property(element, name);
            }
        };
        FunctionResult fr = f.evaluate((FunctionContext)context);
        fr.addListener(new FunctionResult.Listener(){

            public void handleValueChanged() {
                Runnable notifyOfUpdateOperation = new Runnable(){

                    public void run() {
                        refreshOp.run();
                    }
                };
                Display.getDefault().asyncExec(notifyOfUpdateOperation);
            }
        });
        return fr;
    }

    public abstract void render(SapphireRenderingContext var1);

    @Override
    public ISapphirePartDef getDefinition() {
        return this.definition;
    }

    @Override
    public final ISapphirePart getParentPart() {
        return this.parent;
    }

    @Override
    public final <T> T nearest(Class<T> partType) {
        if (partType.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        if (this.parent != null) {
            return this.parent.nearest(partType);
        }
        return null;
    }

    @Override
    public final IModelElement getModelElement() {
        return this.modelElement;
    }

    public final Map<String, String> getParams() {
        return Collections.unmodifiableMap(this.params);
    }

    @Override
    public final Status getValidationState() {
        return this.validationState;
    }

    protected Status computeValidationState() {
        return Status.createOkStatus();
    }

    public final void updateValidationState() {
        Status newValidationState = this.computeValidationState();
        boolean updateNeeded = false;
        if (this.validationState != newValidationState) {
            if (this.validationState == null || newValidationState == null) {
                updateNeeded = true;
            } else if (this.validationState.severity() != newValidationState.severity() || !this.validationState.message().equals(newValidationState.message())) {
                updateNeeded = true;
            }
        }
        if (updateNeeded) {
            Status oldValidationState = this.validationState;
            this.validationState = newValidationState;
            if (this.listeners != null) {
                for (SapphirePartListener listener : this.listeners) {
                    try {
                        listener.handleValidateStateChange(oldValidationState, newValidationState);
                    }
                    catch (Exception e) {
                        SapphireUiFrameworkPlugin.log(e);
                    }
                }
            }
        }
    }

    public boolean setFocus() {
        return false;
    }

    public boolean setFocus(ModelPath path) {
        return false;
    }

    public final boolean setFocus(String path) {
        return this.setFocus(new ModelPath(path));
    }

    protected final void notifyFocusRecievedEventListeners() {
        if (this.listeners != null) {
            SapphirePartEvent event = new SapphirePartEvent(this);
            for (SapphirePartListener listener : this.listeners) {
                try {
                    listener.handleFocusReceivedEvent(event);
                }
                catch (Exception e) {
                    SapphireUiFrameworkPlugin.log(e);
                }
            }
        }
    }

    @Override
    public IContext getDocumentationContext() {
        return null;
    }

    @Override
    public SapphireImageCache getImageCache() {
        return this.imageCache;
    }

    protected void handleModelElementChange(ModelPropertyChangeEvent event) {
    }

    @Override
    public final void addListener(SapphirePartListener listener) {
        if (this.listeners == null) {
            this.listeners = Collections.singleton(listener);
        } else {
            this.listeners = new HashSet<SapphirePartListener>(this.listeners);
            this.listeners.add(listener);
        }
    }

    @Override
    public final void removeListener(SapphirePartListener listener) {
        if (this.listeners != null && this.listeners.contains(listener)) {
            if (this.listeners.size() == 1) {
                this.listeners = null;
            } else {
                this.listeners = new HashSet<SapphirePartListener>(this.listeners);
                this.listeners.remove(listener);
            }
        }
    }

    public final Set<SapphirePartListener> getListeners() {
        if (this.listeners == null) {
            return Collections.emptySet();
        }
        return this.listeners;
    }

    public final void notifyStructureChangedEventListeners(SapphirePartEvent event) {
        if (this.listeners != null) {
            for (SapphirePartListener listener : this.listeners) {
                try {
                    listener.handleStructureChangedEvent(event);
                }
                catch (Exception e) {
                    SapphireUiFrameworkPlugin.log(e);
                }
            }
        }
        if (this.parent != null && this.parent instanceof SapphirePart) {
            ((SapphirePart)this.parent).notifyStructureChangedEventListeners(event);
        }
    }

    public final void notifyListeners(SapphirePartEvent event) {
        if (this.listeners != null) {
            for (SapphirePartListener listener : this.listeners) {
                try {
                    listener.handleEvent(event);
                }
                catch (Exception e) {
                    SapphireUiFrameworkPlugin.log(e);
                }
            }
        }
    }

    public final ModelProperty resolve(String propertyName) {
        return this.resolve(this.modelElement, propertyName);
    }

    public final ModelProperty resolve(IModelElement modelElement, String propertyName) {
        return SapphirePart.resolve(modelElement, propertyName, this.params);
    }

    public static final ModelProperty resolve(IModelElement modelElement, String propertyName, Map<String, String> params) {
        if (propertyName != null) {
            propertyName = SapphirePart.substituteParams(propertyName.trim(), params);
            ModelElementType type = modelElement.getModelElementType();
            ModelProperty property = type.getProperty(propertyName);
            if (property == null) {
                throw new RuntimeException("Could not find property " + propertyName + " in " + type.getQualifiedName());
            }
            return property;
        }
        return null;
    }

    public final String substituteParams(String str) {
        return SapphirePart.substituteParams(str, this.params);
    }

    public static final String substituteParams(String str, Map<String, String> params) {
        String result = str;
        if (str != null && str.contains("@{")) {
            for (Map.Entry<String, String> param : params.entrySet()) {
                StringBuilder token = new StringBuilder();
                token.append("@{");
                token.append(param.getKey());
                token.append('}');
                result = result.replace(token, param.getValue());
            }
        }
        return result;
    }

    @Override
    public Set<String> getActionContexts() {
        return Collections.emptySet();
    }

    @Override
    public String getMainActionContext() {
        Set<String> contexts = this.getActionContexts();
        if (!contexts.isEmpty()) {
            return contexts.iterator().next();
        }
        return null;
    }

    @Override
    public final SapphireActionGroup getActions() {
        String context = this.getMainActionContext();
        if (context != null) {
            return this.getActions(context);
        }
        return null;
    }

    @Override
    public final SapphireActionGroup getActions(String context) {
        if (this.actions == null) {
            this.actions = new HashMap<String, SapphireActionGroup>();
            for (String ctxt : this.getActionContexts()) {
                SapphireActionGroup actionsForContext = new SapphireActionGroup(this, ctxt);
                this.actions.put(ctxt.toLowerCase(), actionsForContext);
            }
        }
        return this.actions.get(context.toLowerCase());
    }

    @Override
    public final SapphireAction getAction(String id) {
        for (String context : this.getActionContexts()) {
            SapphireAction action = this.getActions(context).getAction(id);
            if (action == null) continue;
            return action;
        }
        if (this.parent != null) {
            return this.parent.getAction(id);
        }
        return null;
    }

    public boolean isSingleLinePart() {
        return false;
    }

    @Override
    public void dispose() {
        this.modelElement.removeListener(this.modelElementListener);
        if (this.parent == null) {
            this.imageCache.dispose();
        }
        if (this.actions != null) {
            for (SapphireActionGroup actionsForContext : this.actions.values()) {
                actionsForContext.dispose();
            }
        }
    }

    public static final SapphirePart create(SapphirePart parent, IModelElement modelElement, ISapphirePartDef definition, Map<String, String> params) {
        if (modelElement == null) {
            throw new IllegalArgumentException();
        }
        SapphirePart part = null;
        Map<String, String> partParams = params;
        ISapphirePartDef def = definition;
        if (definition instanceof ISapphirePropertyEditorDef) {
            part = new SapphirePropertyEditor();
        } else if (definition instanceof ISapphireLabelDef) {
            part = new SapphireLabel();
        } else if (definition instanceof ISapphireSeparatorDef) {
            part = new SapphireSeparator();
        } else if (definition instanceof ISapphireSpacerDef) {
            part = new SapphireSpacer();
        } else if (definition instanceof ISapphireActionLinkDef) {
            part = new SapphireActionLink();
        } else if (definition instanceof ISapphireCustomPartDef) {
            JavaType customPartImplClass = (JavaType)((ISapphireCustomPartDef)definition).getImplClass().resolve();
            if (customPartImplClass != null) {
                try {
                    part = (SapphirePart)customPartImplClass.artifact().newInstance();
                }
                catch (Exception e) {
                    SapphireUiFrameworkPlugin.log(e);
                }
            }
        } else if (definition instanceof ISapphireStaticTextFieldDef) {
            part = new SapphireStaticTextField();
        } else if (definition instanceof ISapphireGroupDef) {
            part = new SapphireGroup();
        } else if (definition instanceof ISapphireWithDirectiveDef) {
            SapphireWithDirectiveHelper.ResolvePathResult resolvePathResult = SapphireWithDirectiveHelper.resolvePath(modelElement, (ISapphireWithDirectiveDef)definition, partParams);
            part = resolvePathResult.property == null ? new SapphireWithDirectiveImplied() : new SapphireWithDirective();
        } else if (definition instanceof ISapphirePageBookExtDef) {
            ISapphirePageBookExtDef pageBookPartDef = (ISapphirePageBookExtDef)definition;
            part = pageBookPartDef.getControlMethod().getContent() == PageBookPartControlMethod.ENUM_VALUE ? new SapphireEnumControlledPageBook() : new SapphireListControlledPageBook();
        } else if (definition instanceof ISapphireDialogDef) {
            part = new SapphireDialogPart();
        } else if (definition instanceof ISapphireWizardPageDef) {
            part = new SapphireWizardPagePart();
        } else if (definition instanceof ISapphireCompositeDef) {
            part = new SapphireComposite();
        } else if (definition instanceof IFormPartInclude) {
            IFormPartInclude inc = (IFormPartInclude)definition;
            def = (ISapphirePartDef)inc.getPart().resolve();
            if (def != null) {
                partParams = new HashMap<String, String>(params);
                for (ISapphireParam param : inc.getParams()) {
                    String paramName = param.getName().getText();
                    String paramValue = param.getValue().getText();
                    if (paramName == null || paramValue == null) continue;
                    partParams.put(paramName, paramValue);
                }
                part = new SapphirePartContainer();
            }
        } else if (definition instanceof ISapphireTabGroupDef) {
            part = new TabGroupPart();
        } else if (definition instanceof ISapphireIfElseDirectiveDef) {
            part = new SapphireIfElseDirective();
        } else if (definition instanceof ISapphireHtmlPanelDef) {
            part = new SapphireHtmlPanel();
        }
        if (part == null) {
            throw new IllegalStateException();
        }
        part.init(parent, modelElement, def, partParams);
        return part;
    }

    public static final class ImageChangedEvent
    extends SapphirePartEvent {
        public ImageChangedEvent(SapphirePart part) {
            super(part);
        }
    }

    protected final class ImageManager {
        private final FunctionResult imageFunctionResult;
        private ImageData baseImageData;
        private ImageDescriptor base;
        private ImageDescriptor error;
        private ImageDescriptor warning;
        private ImageDescriptor current;

        public ImageManager(IModelElement element, Function imageFunction) {
            this(element, imageFunction, (Function)Literal.NULL);
        }

        public ImageManager(IModelElement element, Function imageFunction, Function defaultValueFunction) {
            this.imageFunctionResult = SapphirePart.this.initExpression(element, imageFunction, ImageData.class, defaultValueFunction, new Runnable(){

                public void run() {
                    ImageManager.this.refresh(true);
                }
            });
            SapphirePart.this.addListener(new SapphirePartListener(){

                public void handleValidateStateChange(Status oldValidateState, Status newValidationState) {
                    ImageManager.this.refresh(true);
                }
            });
            this.refresh(false);
        }

        public ImageDescriptor getImage() {
            return this.current;
        }

        private void refresh(boolean notifyListenersIfNecessary) {
            Status st = SapphirePart.this.getValidationState();
            Status.Severity severity = st.severity();
            ImageDescriptor old = this.current;
            if (this.imageFunctionResult != null) {
                ImageData newBaseImageData = (ImageData)this.imageFunctionResult.value();
                if (this.baseImageData != newBaseImageData) {
                    this.baseImageData = newBaseImageData;
                    this.base = SwtRendererUtil.toImageDescriptor(this.baseImageData);
                    this.error = null;
                    this.warning = null;
                }
                if (this.base == null) {
                    this.current = null;
                } else if (severity == Status.Severity.ERROR) {
                    if (this.error == null) {
                        this.error = new ProblemOverlayImageDescriptor(this.base, Status.Severity.ERROR);
                    }
                    this.current = this.error;
                } else if (severity == Status.Severity.WARNING) {
                    if (this.warning == null) {
                        this.warning = new ProblemOverlayImageDescriptor(this.base, Status.Severity.WARNING);
                    }
                    this.current = this.warning;
                } else {
                    this.current = this.base;
                }
            }
            if (notifyListenersIfNecessary && this.current != old) {
                SapphirePart.this.notifyListeners(new ImageChangedEvent(SapphirePart.this));
            }
        }

        public void dispose() {
            this.imageFunctionResult.dispose();
        }
    }

    public static final class LabelChangedEvent
    extends SapphirePartEvent {
        public LabelChangedEvent(SapphirePart part) {
            super(part);
        }
    }

    private static final class Resources
    extends NLS {
        public static String failedToInstantiate;
        public static String doesNotExtend;

        static {
            Resources.initializeMessages((String)SapphirePart.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

