/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import java.util.Map;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.ElementProperty;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ImpliedElementProperty;
import org.eclipse.sapphire.modeling.ModelPath;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.def.ISapphireWithDirectiveDef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SapphireWithDirectiveHelper {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ResolvePathResult resolvePath(IModelElement context, ISapphireWithDirectiveDef def, Map<String, String> params) {
        ResolvePathResult result = new ResolvePathResult();
        String pathString = def.getPath().getText();
        result.path = new ModelPath(pathString);
        result.element = context;
        int i = 0;
        int n = result.path.length();
        while (i < n) {
            ModelPath.Segment segment = result.path.segment(i);
            if (segment instanceof ModelPath.ModelRootSegment) {
                result.element = (IModelElement)result.element.root();
            } else if (segment instanceof ModelPath.ParentElementSegment) {
                IModelParticle parent = result.element.parent();
                if (!(parent instanceof IModelElement)) {
                    parent = parent.parent();
                }
                result.element = (IModelElement)parent;
            } else {
                if (!(segment instanceof ModelPath.PropertySegment)) throw new RuntimeException(NLS.bind((String)Resources.invalidPath, (Object)pathString));
                ModelProperty prop = SapphirePart.resolve(result.element, ((ModelPath.PropertySegment)segment).getPropertyName(), params);
                if (prop instanceof ImpliedElementProperty) {
                    result.element = result.element.read((ImpliedElementProperty)prop);
                } else {
                    if (!(prop instanceof ElementProperty)) throw new RuntimeException(NLS.bind((String)Resources.invalidPath, (Object)pathString));
                    result.property = (ElementProperty)prop;
                    if (i + 1 != n) {
                        throw new RuntimeException(NLS.bind((String)Resources.invalidPath, (Object)pathString));
                    }
                }
            }
            ++i;
        }
        return result;
    }

    public static final class ResolvePathResult {
        public ModelPath path;
        public IModelElement element;
        public ElementProperty property;
    }

    private static final class Resources
    extends NLS {
        public static String invalidPath;

        static {
            Resources.initializeMessages((String)SapphireWithDirectiveHelper.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

