/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.SapphirePartEvent;
import org.eclipse.sapphire.ui.SapphirePartListener;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.TabGroupPagePart;
import org.eclipse.sapphire.ui.def.ISapphireTabDef;
import org.eclipse.sapphire.ui.def.ISapphireTabGroupDef;
import org.eclipse.sapphire.ui.swt.renderer.GridLayoutUtil;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TabGroupPart
extends SapphirePart {
    private List<TabGroupPagePart> pages;

    @Override
    protected void init() {
        super.init();
        IModelElement element = this.getModelElement();
        this.pages = new ArrayList<TabGroupPagePart>();
        for (ISapphireTabDef pageDef : ((ISapphireTabGroupDef)this.definition).getTabs()) {
            TabGroupPagePart pagePart = new TabGroupPagePart();
            pagePart.init(this, element, pageDef, this.params);
            this.pages.add(pagePart);
            SapphirePartListener tabPartListener = new SapphirePartListener(){

                public void handleValidateStateChange(Status oldValidateState, Status newValidationState) {
                    TabGroupPart.this.updateValidationState();
                }
            };
            pagePart.addListener(tabPartListener);
        }
    }

    @Override
    public void render(SapphireRenderingContext context) {
        boolean expandVertically = Boolean.valueOf(this.definition.getHint("expand.vertically"));
        TabFolder tabGroup = new TabFolder(context.getComposite(), 128);
        tabGroup.setLayoutData((Object)GridLayoutUtil.gdhspan(expandVertically ? GridLayoutUtil.gdfill() : GridLayoutUtil.gdhfill(), 2));
        context.adapt((Control)tabGroup);
        for (final TabGroupPagePart page : this.pages) {
            Composite tabControl = new Composite((Composite)tabGroup, 0);
            tabControl.setLayout((Layout)GridLayoutUtil.glayout(2, 0, 0));
            final TabItem tab = new TabItem(tabGroup, 0);
            tab.setText(page.getLabel());
            tab.setControl((Control)tabControl);
            final HashMap<ImageDescriptor, Image> images = new HashMap<ImageDescriptor, Image>();
            this.updateTabImage(tab, page, images);
            final SapphirePartListener tabPartListener = new SapphirePartListener(){

                public void handleEvent(SapphirePartEvent event) {
                    if (event instanceof SapphirePart.LabelChangedEvent) {
                        tab.setText(page.getLabel());
                    } else if (event instanceof SapphirePart.ImageChangedEvent) {
                        TabGroupPart.this.updateTabImage(tab, page, images);
                    }
                }
            };
            page.addListener(tabPartListener);
            tab.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    page.removeListener(tabPartListener);
                    for (Image image : images.values()) {
                        image.dispose();
                    }
                }
            });
            page.render(new SapphireRenderingContext(page, context, tabControl));
        }
    }

    private void updateTabImage(TabItem tab, TabGroupPagePart tabPart, Map<ImageDescriptor, Image> images) {
        ImageDescriptor imageDescriptor = tabPart.getImage();
        Image image = images.get(imageDescriptor);
        if (image == null) {
            image = imageDescriptor.createImage();
            images.put(imageDescriptor, image);
        }
        tab.setImage(image);
    }

    @Override
    protected Status computeValidationState() {
        Status.CompositeStatusFactory factory = Status.factoryForComposite();
        for (TabGroupPagePart page : this.pages) {
            factory.add(page.getValidationState());
        }
        return factory.create();
    }

    @Override
    public void dispose() {
        super.dispose();
        for (SapphirePart sapphirePart : this.pages) {
            sapphirePart.dispose();
        }
    }
}

