/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.def;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SapphireKeySequence {
    public static final char DEL = '\u007f';
    public static final int KEYCODE_BIT = 0x1000000;
    public static final int ARROW_UP = 0x1000001;
    public static final int ARROW_DOWN = 0x1000002;
    private static final char SEPARATOR = '+';
    private static final String SYMBOL_SHIFT = "SHIFT";
    private static final String SYMBOL_ALT = "ALT";
    private static final String SYMBOL_CONTROL = "CONTROL";
    private static final String SYMBOL_DEL = "DEL";
    private static final String SYMBOL_ARROW_UP = "ARROW_UP";
    private static final String SYMBOL_ARROW_DOWN = "ARROW_DOWN";
    private final Set<Modifier> modifiers;
    private final int keyCode;

    public SapphireKeySequence(String definition) {
        HashSet<Modifier> modifiers = new HashSet<Modifier>();
        int keyCode = -1;
        String[] stringArray = definition.split("\\+");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            if (segment.equalsIgnoreCase(SYMBOL_SHIFT)) {
                if (modifiers.contains((Object)Modifier.SHIFT)) {
                    throw new IllegalArgumentException();
                }
                modifiers.add(Modifier.SHIFT);
            } else if (segment.equalsIgnoreCase(SYMBOL_ALT)) {
                if (modifiers.contains((Object)Modifier.ALT)) {
                    throw new IllegalArgumentException();
                }
                modifiers.add(Modifier.ALT);
            } else if (segment.equalsIgnoreCase(SYMBOL_CONTROL)) {
                if (modifiers.contains((Object)Modifier.CONTROL)) {
                    throw new IllegalArgumentException();
                }
                modifiers.add(Modifier.CONTROL);
            } else if (segment.equalsIgnoreCase(SYMBOL_DEL)) {
                if (keyCode != -1) {
                    throw new IllegalArgumentException();
                }
                keyCode = 127;
            } else if (segment.equalsIgnoreCase(SYMBOL_ARROW_UP)) {
                if (keyCode != -1) {
                    throw new IllegalArgumentException();
                }
                keyCode = 0x1000001;
            } else if (segment.equalsIgnoreCase(SYMBOL_ARROW_DOWN)) {
                if (keyCode != -1) {
                    throw new IllegalArgumentException();
                }
                keyCode = 0x1000002;
            } else if (segment.length() == 1) {
                if (keyCode != -1) {
                    throw new IllegalArgumentException();
                }
                keyCode = segment.charAt(0);
            } else {
                throw new IllegalArgumentException();
            }
            ++n2;
        }
        if (keyCode == -1) {
            throw new IllegalArgumentException();
        }
        this.modifiers = Collections.unmodifiableSet(modifiers);
        this.keyCode = keyCode;
    }

    public Set<Modifier> getModifiers() {
        return this.modifiers;
    }

    public int getKeyCode() {
        return this.keyCode;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        Modifier[] modifierArray = Modifier.values();
        int n = modifierArray.length;
        int n2 = 0;
        while (n2 < n) {
            Modifier modifier = modifierArray[n2];
            if (buf.length() > 0) {
                buf.append('+');
            }
            buf.append(modifier.name());
            ++n2;
        }
        if (buf.length() > 0) {
            buf.append('+');
        }
        buf.append((char)this.keyCode);
        return buf.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Modifier {
        SHIFT,
        ALT,
        CONTROL;

    }
}

