/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.diagram.actions;

import java.util.List;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.def.ISapphireActionHandlerDef;
import org.eclipse.sapphire.ui.diagram.SapphireDiagramActionHandler;
import org.eclipse.sapphire.ui.diagram.editor.DiagramConnectionPart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramConnectionTemplate;
import org.eclipse.sapphire.ui.diagram.editor.DiagramEmbeddedConnectionTemplate;
import org.eclipse.sapphire.ui.diagram.editor.DiagramImplicitConnectionPart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodePart;
import org.eclipse.sapphire.ui.diagram.editor.SapphireDiagramEditorPagePart;

public class DiagramDeleteActionHandler
extends SapphireDiagramActionHandler {
    private static final String DELETE_ACTION_ID = "Sapphire.Delete";

    public void init(SapphireAction action, ISapphireActionHandlerDef def) {
        super.init(action, def);
        ISapphirePart part = this.getPart();
        this.setEnabled(!(part instanceof DiagramImplicitConnectionPart));
    }

    public boolean canExecute(Object obj) {
        return this.isEnabled();
    }

    protected Object run(SapphireRenderingContext context) {
        ISapphirePart part = context.getPart();
        if (part instanceof DiagramConnectionPart) {
            DiagramConnectionPart connPart = (DiagramConnectionPart)part;
            IModelElement element = connPart.getLocalModelElement();
            ModelElementList list = (ModelElementList)element.parent();
            list.remove((Object)element);
        } else if (part instanceof DiagramNodePart) {
            DiagramNodePart nodePart = (DiagramNodePart)part;
            IModelElement nodeModel = nodePart.getLocalModelElement();
            this.deleteNodeConnections(nodePart);
            SapphireDiagramEditorPagePart editorPart = nodePart.getDiagramNodeTemplate().getDiagramEditorPart();
            List<DiagramConnectionTemplate> connTemplates = editorPart.getConnectionTemplates();
            for (DiagramConnectionTemplate connTemplate : connTemplates) {
                IModelElement connParentElement;
                if (connTemplate.getConnectionType() != DiagramConnectionTemplate.ConnectionType.OneToMany || (connParentElement = connTemplate.getConnectionParentElement(nodeModel)) == null) continue;
                ModelElementList connParentList = (ModelElementList)connParentElement.parent();
                connParentList.remove((Object)connParentElement);
            }
            ModelElementList list = (ModelElementList)nodeModel.parent();
            list.remove((Object)nodeModel);
        }
        return null;
    }

    public boolean hasDoneModelChanges() {
        return true;
    }

    private void deleteNodeConnections(DiagramNodePart nodePart) {
        IModelElement nodeModel = nodePart.getLocalModelElement();
        DiagramEmbeddedConnectionTemplate embeddedConn = nodePart.getDiagramNodeTemplate().getEmbeddedConnectionTemplate();
        if (embeddedConn != null) {
            for (DiagramConnectionPart connPart : embeddedConn.getDiagramConnections(null)) {
                if (!connPart.getEndpoint1().equals(nodeModel) && !connPart.getEndpoint2().equals(nodeModel)) continue;
                this.deleteConnection(connPart);
            }
        }
        SapphireDiagramEditorPagePart diagramPart = nodePart.getDiagramNodeTemplate().getDiagramEditorPart();
        for (DiagramConnectionTemplate connTemplate : diagramPart.getConnectionTemplates()) {
            for (DiagramConnectionPart connPart : connTemplate.getDiagramConnections(null)) {
                if (!connPart.getEndpoint1().equals(nodeModel) && !connPart.getEndpoint2().equals(nodeModel) || connPart instanceof DiagramImplicitConnectionPart) continue;
                this.deleteConnection(connPart);
            }
        }
    }

    private void deleteConnection(DiagramConnectionPart connPart) {
        SapphireActionHandler deleteActionHandler = connPart.getAction(DELETE_ACTION_ID).getFirstActiveHandler();
        SapphireRenderingContext renderingCtx = new SapphireRenderingContext((ISapphirePart)connPart, null);
        deleteActionHandler.execute(renderingCtx);
    }
}

