/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.diagram.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.sapphire.modeling.ElementProperty;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ListProperty;
import org.eclipse.sapphire.modeling.ModelElementDisposedEvent;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelElementListener;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.ModelPath;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ModelPropertyChangeEvent;
import org.eclipse.sapphire.modeling.ModelPropertyListener;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.annotations.Reference;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.localization.LocalizationService;
import org.eclipse.sapphire.ui.diagram.def.IDiagramConnectionDef;
import org.eclipse.sapphire.ui.diagram.def.IDiagramConnectionEndpointBindingDef;
import org.eclipse.sapphire.ui.diagram.def.IDiagramExplicitConnectionBindingDef;
import org.eclipse.sapphire.ui.diagram.editor.DiagramConnectionEvent;
import org.eclipse.sapphire.ui.diagram.editor.DiagramConnectionPart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramConnectionTemplate;
import org.eclipse.sapphire.ui.diagram.editor.DiagramEmbeddedConnectionPart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodePart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeTemplate;
import org.eclipse.sapphire.ui.diagram.editor.IdUtil;
import org.eclipse.sapphire.ui.diagram.editor.ModelUtil;
import org.eclipse.sapphire.ui.diagram.editor.SapphireDiagramPartListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiagramEmbeddedConnectionTemplate
extends DiagramConnectionTemplate {
    private DiagramNodeTemplate nodeTemplate;
    private Map<IModelElement, List<DiagramConnectionPart>> diagramConnectionMap;
    private ModelElementListener modelElementListener;
    private ModelPath endpointPath;

    public DiagramEmbeddedConnectionTemplate(IDiagramExplicitConnectionBindingDef connBindingDef) {
        super(connBindingDef);
    }

    @Override
    public void init() {
        this.nodeTemplate = (DiagramNodeTemplate)this.getParentPart();
        this.diagramEditor = this.nodeTemplate.getDiagramEditorPart();
        this.modelElement = this.getModelElement();
        this.definition = (IDiagramConnectionDef)super.getDefinition();
        this.diagramConnectionMap = new HashMap<IModelElement, List<DiagramConnectionPart>>();
        ListProperty nodeProperty = (ListProperty)this.nodeTemplate.getModelProperty();
        this.propertyName = (String)this.bindingDef.getProperty().getContent();
        this.connListProperty = (ListProperty)nodeProperty.getType().getProperty(this.propertyName);
        this.connPartListener = new SapphireDiagramPartListener(){

            public void handleConnectionUpdateEvent(DiagramConnectionEvent event) {
                DiagramEmbeddedConnectionTemplate.this.notifyConnectionUpdate((DiagramConnectionPart)event.getPart());
            }

            public void handleConnectionEndpointEvent(DiagramConnectionEvent event) {
                DiagramEmbeddedConnectionTemplate.this.notifyConnectionEndpointUpdate((DiagramConnectionPart)event.getPart());
            }
        };
        this.templateListeners = new CopyOnWriteArraySet();
        this.modelPropertyListener = new ModelPropertyListener(){

            public void handlePropertyChangedEvent(ModelPropertyChangeEvent event) {
                DiagramEmbeddedConnectionTemplate.this.handleModelPropertyChange(event);
            }
        };
        this.modelElementListener = new ModelElementListener(){

            public void handleElementDisposedEvent(ModelElementDisposedEvent event) {
                DiagramEmbeddedConnectionTemplate.this.handleModelElementDispose(event);
            }
        };
        String endpointPropStr = (String)((IDiagramConnectionEndpointBindingDef)this.bindingDef.getEndpoint2().element()).getProperty().getContent();
        this.endpointPath = new ModelPath(endpointPropStr);
        ModelElementList srcNodeList = this.modelElement.read(nodeProperty);
        for (IModelElement srcNodeModel : srcNodeList) {
            ModelProperty connProp = ModelUtil.resolve(srcNodeModel, this.propertyName);
            if (!(connProp instanceof ListProperty)) continue;
            ListProperty connListProperty = (ListProperty)connProp;
            ModelElementList connList = srcNodeModel.read(connListProperty);
            for (IModelElement endpointModel : connList) {
                this.createNewConnectionPart(endpointModel, srcNodeModel);
            }
            this.addModelListener(srcNodeModel);
        }
    }

    @Override
    public boolean canStartNewConnection(DiagramNodePart srcNode) {
        ModelElementType desiredsrcNodeType;
        IModelElement srcNodeModel = srcNode.getLocalModelElement();
        ModelElementType srcNodeType = srcNodeModel.getModelElementType();
        return srcNodeType.equals(desiredsrcNodeType = this.nodeTemplate.getNodeType());
    }

    @Override
    public boolean canCreateNewConnection(DiagramNodePart srcNode, DiagramNodePart targetNode) {
        if (!this.canStartNewConnection(srcNode)) {
            return false;
        }
        IModelElement srcNodeModel = srcNode.getLocalModelElement();
        ModelElementType targetType = targetNode.getLocalModelElement().getModelElementType();
        ModelProperty connProp = ModelUtil.resolve(srcNodeModel, this.propertyName);
        ModelElementType connType = connProp.getType();
        ModelProperty endpointProp = connType.getProperty((String)((IDiagramConnectionEndpointBindingDef)this.bindingDef.getEndpoint2().element()).getProperty().getContent());
        if (endpointProp.getType() == null && endpointProp.hasAnnotation(Reference.class)) {
            return ((Reference)endpointProp.getAnnotation(Reference.class)).target().isAssignableFrom(targetType.getModelElementClass());
        }
        return false;
    }

    @Override
    public DiagramConnectionPart createNewDiagramConnection(DiagramNodePart srcNode, DiagramNodePart targetNode) {
        IModelElement localModelElement;
        ElementProperty elementProperty;
        IModelElement srcNodeModel = srcNode.getLocalModelElement();
        ModelProperty modelProperty = this.nodeTemplate.getModelProperty();
        boolean found = false;
        if (modelProperty instanceof ListProperty) {
            ListProperty listProperty = (ListProperty)modelProperty;
            ModelElementList list = this.modelElement.read(listProperty);
            for (IModelElement listEntryModelElement : list) {
                if (!listEntryModelElement.equals(srcNodeModel)) continue;
                found = true;
                break;
            }
        } else if (modelProperty instanceof ElementProperty && this.modelElement.read(elementProperty = (ElementProperty)modelProperty) != null && (localModelElement = this.modelElement.read(elementProperty).element()) == srcNodeModel) {
            found = true;
        }
        if (!found) {
            throw new RuntimeException("Cannot locate the source node element");
        }
        ModelProperty connProp = ModelUtil.resolve(srcNodeModel, this.propertyName);
        IModelElement newEndpoint = null;
        if (connProp instanceof ListProperty) {
            ListProperty listProperty = (ListProperty)connProp;
            ModelElementList list = srcNodeModel.read(listProperty);
            newEndpoint = list.addNewElement();
        }
        IDiagramConnectionEndpointBindingDef endpointDef = (IDiagramConnectionEndpointBindingDef)this.bindingDef.getEndpoint2().element();
        String endpointProperty = (String)endpointDef.getProperty().getContent();
        Value<Function> endpointFunc = endpointDef.getValue();
        FunctionResult endpointFuncResult = this.getNodeReferenceFunction(targetNode, endpointFunc, (LocalizationService)this.bindingDef.adapt(LocalizationService.class));
        DiagramConnectionPart connPart = null;
        if (endpointFuncResult != null) {
            String endpointVal = (String)endpointFuncResult.value();
            endpointFuncResult.dispose();
            if (endpointVal == null || endpointVal.length() == 0) {
                endpointVal = IdUtil.computeNodeId(targetNode);
            }
            this.setModelProperty(newEndpoint, endpointProperty, endpointVal);
            connPart = this.createNewConnectionPart(newEndpoint, srcNodeModel);
        }
        return connPart;
    }

    @Override
    public DiagramConnectionPart createNewConnectionPart(IModelElement connElement, IModelElement srcNodeElement) {
        DiagramEmbeddedConnectionPart connPart = new DiagramEmbeddedConnectionPart(this.bindingDef, srcNodeElement, this.endpointPath);
        connPart.init(this, connElement, this.definition, Collections.<String, String>emptyMap());
        connPart.addListener(this.connPartListener);
        this.addConnectionPart(srcNodeElement, connPart);
        return connPart;
    }

    public void addModelListener(IModelElement srcNodeModel) {
        srcNodeModel.addListener(this.modelPropertyListener, this.propertyName);
        srcNodeModel.addListener(this.modelElementListener);
    }

    public void removeModelListener(IModelElement srcNodeModel) {
        srcNodeModel.removeListener(this.modelPropertyListener, this.propertyName);
        srcNodeModel.removeListener(this.modelElementListener);
    }

    @Override
    public void addModelListener() {
    }

    @Override
    public void removeModelListener() {
        ListProperty nodeProperty = (ListProperty)this.nodeTemplate.getModelProperty();
        ModelElementList srcNodeList = this.modelElement.read(nodeProperty);
        for (IModelElement srcNodeModel : srcNodeList) {
            this.removeModelListener(srcNodeModel);
        }
    }

    @Override
    public List<DiagramConnectionPart> getDiagramConnections(IModelElement srcNodeModel) {
        ArrayList<DiagramConnectionPart> allConnParts = new ArrayList<DiagramConnectionPart>();
        if (srcNodeModel != null) {
            if (this.diagramConnectionMap.get(srcNodeModel) != null) {
                allConnParts.addAll((Collection<DiagramConnectionPart>)this.diagramConnectionMap.get(srcNodeModel));
            }
        } else {
            Iterator<IModelElement> it = this.diagramConnectionMap.keySet().iterator();
            while (it.hasNext()) {
                allConnParts.addAll((Collection<DiagramConnectionPart>)this.diagramConnectionMap.get(it.next()));
            }
        }
        return allConnParts;
    }

    @Override
    protected void addConnectionPart(IModelElement srcNodeModel, DiagramConnectionPart connPart) {
        List<DiagramConnectionPart> connParts = this.diagramConnectionMap.get(srcNodeModel);
        if (connParts == null) {
            connParts = new ArrayList<DiagramConnectionPart>();
            this.diagramConnectionMap.put(srcNodeModel, connParts);
        }
        connParts.add(connPart);
    }

    @Override
    protected void removeConnectionPart(IModelElement srcNodeModel, DiagramConnectionPart connPart) {
        List<DiagramConnectionPart> connParts = this.diagramConnectionMap.get(srcNodeModel);
        if (connParts != null) {
            connParts.remove(connPart);
        }
    }

    private void handleModelElementDispose(ModelElementDisposedEvent event) {
        IModelElement element = event.getModelElement();
        List<DiagramConnectionPart> connParts = this.getDiagramConnections(null);
        for (DiagramConnectionPart connPart : connParts) {
            if (connPart.getEndpoint1() != element && connPart.getEndpoint2() != element) continue;
            this.notifyConnectionDelete(connPart);
            connPart.dispose();
        }
        connParts.clear();
        this.removeModelListener(element);
    }
}

