/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.diagram.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ImpliedElementProperty;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.ui.IPropertiesViewContributorPart;
import org.eclipse.sapphire.ui.PropertiesViewContributionManager;
import org.eclipse.sapphire.ui.PropertiesViewContributionPart;
import org.eclipse.sapphire.ui.SapphireEditorPagePart;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.SapphirePartEvent;
import org.eclipse.sapphire.ui.SapphirePartListener;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.diagram.def.IDiagramConnectionDef;
import org.eclipse.sapphire.ui.diagram.def.IDiagramEditorPageDef;
import org.eclipse.sapphire.ui.diagram.def.IDiagramExplicitConnectionBindingDef;
import org.eclipse.sapphire.ui.diagram.def.IDiagramImageChoice;
import org.eclipse.sapphire.ui.diagram.def.IDiagramImplicitConnectionBindingDef;
import org.eclipse.sapphire.ui.diagram.def.IDiagramNodeDef;
import org.eclipse.sapphire.ui.diagram.editor.DiagramConnectionEvent;
import org.eclipse.sapphire.ui.diagram.editor.DiagramConnectionPart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramConnectionTemplate;
import org.eclipse.sapphire.ui.diagram.editor.DiagramImplicitConnectionPart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramImplicitConnectionTemplate;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeEvent;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodePart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeTemplate;
import org.eclipse.sapphire.ui.diagram.editor.DiagramPageEvent;
import org.eclipse.sapphire.ui.diagram.editor.SapphireDiagramPartListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SapphireDiagramEditorPagePart
extends SapphireEditorPagePart {
    private IModelElement modelElement;
    private IDiagramEditorPageDef diagramPageDef = null;
    private List<IDiagramConnectionDef> connectionDefs;
    private List<DiagramNodeTemplate> nodeTemplates;
    private List<DiagramConnectionTemplate> connectionTemplates;
    private List<DiagramImplicitConnectionTemplate> implicitConnectionTemplates;
    private NodeTemplateListener nodeTemplateListener;
    private ConnectionTemplateListener connTemplateListener;
    private PropertiesViewContributionManager propertiesViewContributionManager;
    private SapphirePart selection;
    private ImplicitConnectionTemplateListener implicitConnTemplateListener;
    private boolean showGrid;

    @Override
    protected void init() {
        super.init();
        this.diagramPageDef = (IDiagramEditorPageDef)this.definition;
        ImpliedElementProperty modelElementProperty = (ImpliedElementProperty)this.resolve((String)this.diagramPageDef.getProperty().getContent());
        this.modelElement = modelElementProperty != null ? this.getModelElement().read(modelElementProperty) : this.getModelElement();
        this.showGrid = (Boolean)this.diagramPageDef.getGridDefinition().isVisible().getContent();
        this.nodeTemplateListener = new NodeTemplateListener();
        this.connTemplateListener = new ConnectionTemplateListener();
        this.implicitConnTemplateListener = new ImplicitConnectionTemplateListener();
        this.nodeTemplates = new ArrayList<DiagramNodeTemplate>();
        ModelElementList<IDiagramNodeDef> nodeDefs = this.diagramPageDef.getDiagramNodeDefs();
        this.connectionDefs = this.diagramPageDef.getDiagramConnectionDefs();
        for (IDiagramNodeDef nodeDef : nodeDefs) {
            DiagramNodeTemplate nodeTemplate = new DiagramNodeTemplate();
            nodeTemplate.init(this, this.modelElement, nodeDef, Collections.<String, String>emptyMap());
            this.nodeTemplates.add(nodeTemplate);
            nodeTemplate.addTemplateListener(this.nodeTemplateListener);
        }
        for (DiagramNodeTemplate nodeTemplate : this.nodeTemplates) {
            nodeTemplate.initEmbeddedConnections();
            if (nodeTemplate.getEmbeddedConnectionTemplate() == null) continue;
            nodeTemplate.getEmbeddedConnectionTemplate().addTemplateListener(this.connTemplateListener);
        }
        this.connectionTemplates = new ArrayList<DiagramConnectionTemplate>();
        ModelElementList<IDiagramExplicitConnectionBindingDef> connectionBindings = this.diagramPageDef.getDiagramConnectionBindingDefs();
        for (IDiagramExplicitConnectionBindingDef connBinding : connectionBindings) {
            IDiagramConnectionDef connDef = this.getDiagramConnectionDef((String)connBinding.getConnectionId().getContent());
            DiagramConnectionTemplate connectionTemplate = new DiagramConnectionTemplate(connBinding);
            connectionTemplate.init(this, this.modelElement, connDef, Collections.<String, String>emptyMap());
            this.connectionTemplates.add(connectionTemplate);
            connectionTemplate.addTemplateListener(this.connTemplateListener);
        }
        this.implicitConnectionTemplates = new ArrayList<DiagramImplicitConnectionTemplate>();
        ModelElementList<IDiagramImplicitConnectionBindingDef> implicitConnBindings = this.diagramPageDef.getImplicitConnectionBindingDefs();
        for (IDiagramImplicitConnectionBindingDef implicitConnBinding : implicitConnBindings) {
            IDiagramConnectionDef connDef = this.getDiagramConnectionDef((String)implicitConnBinding.getConnectionId().getContent());
            DiagramImplicitConnectionTemplate connectionTemplate = new DiagramImplicitConnectionTemplate(implicitConnBinding);
            connectionTemplate.init(this, this.modelElement, connDef, Collections.<String, String>emptyMap());
            this.implicitConnectionTemplates.add(connectionTemplate);
            connectionTemplate.addTemplateListener(this.implicitConnTemplateListener);
        }
        this.selection = this;
        this.propertiesViewContributionManager = new PropertiesViewContributionManager(this, this.modelElement);
        this.addListener(new SapphirePartListener(){

            public void handleEvent(SapphirePartEvent event) {
                if (event instanceof SapphireEditorPagePart.SelectionChangedEvent) {
                    SapphireDiagramEditorPagePart.this.refreshPropertiesViewContribution();
                }
            }
        });
        this.refreshPropertiesViewContribution();
    }

    public IModelElement getLocalModelElement() {
        return this.modelElement;
    }

    public boolean isGridVisible() {
        return this.showGrid;
    }

    public void syncGridStateWithDiagramLayout(boolean gridVisible) {
        this.showGrid = gridVisible;
    }

    public void setGridVisible(boolean visible) {
        if (visible != this.showGrid) {
            this.showGrid = visible;
            this.notifyGridStateChange();
        }
    }

    public List<IDiagramImageChoice> getImageDecorators() {
        return this.diagramPageDef.getDiagramImageDecorators();
    }

    public List<DiagramNodeTemplate> getNodeTemplates() {
        return this.nodeTemplates;
    }

    public List<IDiagramConnectionDef> getDiagramConnectionDefs() {
        return this.connectionDefs;
    }

    public IDiagramConnectionDef getDiagramConnectionDef(String connId) {
        if (connId == null) {
            throw new IllegalArgumentException();
        }
        IDiagramConnectionDef connDef = null;
        for (IDiagramConnectionDef def : this.connectionDefs) {
            String id = (String)def.getId().getContent();
            if (id == null || !id.equalsIgnoreCase(connId)) continue;
            connDef = def;
            break;
        }
        return connDef;
    }

    public List<DiagramConnectionTemplate> getConnectionTemplates() {
        return this.connectionTemplates;
    }

    public List<DiagramImplicitConnectionTemplate> getImplicitConnectionTemplates() {
        return this.implicitConnectionTemplates;
    }

    @Override
    public void render(SapphireRenderingContext context) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> getActionContexts() {
        HashSet<String> contextSet = new HashSet<String>();
        contextSet.add("Sapphire.Diagram");
        contextSet.add("Sapphire.Diagram.Editor");
        return contextSet;
    }

    public SapphirePart getSelection() {
        return this.selection;
    }

    public void setSelection(SapphirePart selection) {
        if (this.selection != selection) {
            SapphirePart newSelection;
            SapphirePart oldSelection = this.selection;
            this.selection = newSelection = selection;
            this.notifyListeners(new SapphireEditorPagePart.SelectionChangedEvent(this, oldSelection, newSelection));
        }
    }

    private void refreshPropertiesViewContribution() {
        SapphirePart selection = this.getSelection();
        PropertiesViewContributionPart propertiesViewContribution = null;
        if (selection == this) {
            propertiesViewContribution = this.propertiesViewContributionManager.getPropertiesViewContribution();
        } else if (selection instanceof IPropertiesViewContributorPart) {
            propertiesViewContribution = ((IPropertiesViewContributorPart)((Object)selection)).getPropertiesViewContribution();
        }
        this.setPropertiesViewContribution(propertiesViewContribution);
    }

    public DiagramNodePart getDiagramNodePart(IModelElement nodeElement) {
        if (nodeElement == null) {
            return null;
        }
        List<DiagramNodeTemplate> nodeTemplates = this.getNodeTemplates();
        for (DiagramNodeTemplate nodeTemplate : nodeTemplates) {
            List<DiagramNodePart> nodeParts = nodeTemplate.getDiagramNodes();
            for (DiagramNodePart nodePart : nodeParts) {
                if (!nodePart.getLocalModelElement().equals(nodeElement)) continue;
                return nodePart;
            }
        }
        return null;
    }

    @Override
    public void dispose() {
        super.dispose();
        for (DiagramNodeTemplate nodeTemplate : this.nodeTemplates) {
            nodeTemplate.dispose();
        }
        for (DiagramConnectionTemplate connTemplate : this.connectionTemplates) {
            connTemplate.dispose();
        }
    }

    private void notifyNodeUpdate(DiagramNodePart nodePart) {
        Set<SapphirePartListener> listeners = this.getListeners();
        for (SapphirePartListener listener : listeners) {
            if (!(listener instanceof SapphireDiagramPartListener)) continue;
            DiagramNodeEvent nue = new DiagramNodeEvent(nodePart);
            ((SapphireDiagramPartListener)listener).handleNodeUpdateEvent(nue);
        }
    }

    private void notifyNodeAdd(DiagramNodePart nodePart) {
        Set<SapphirePartListener> listeners = this.getListeners();
        for (SapphirePartListener listener : listeners) {
            if (!(listener instanceof SapphireDiagramPartListener)) continue;
            DiagramNodeEvent nue = new DiagramNodeEvent(nodePart);
            ((SapphireDiagramPartListener)listener).handleNodeAddEvent(nue);
        }
    }

    private void notifyNodeDelete(DiagramNodePart nodePart) {
        Set<SapphirePartListener> listeners = this.getListeners();
        for (SapphirePartListener listener : listeners) {
            if (!(listener instanceof SapphireDiagramPartListener)) continue;
            DiagramNodeEvent nue = new DiagramNodeEvent(nodePart);
            ((SapphireDiagramPartListener)listener).handleNodeDeleteEvent(nue);
        }
    }

    private void notifyNodeMove(DiagramNodeEvent event) {
        Set<SapphirePartListener> listeners = this.getListeners();
        for (SapphirePartListener listener : listeners) {
            if (!(listener instanceof SapphireDiagramPartListener)) continue;
            ((SapphireDiagramPartListener)listener).handleNodeMoveEvent(event);
        }
    }

    private void notifyConnectionUpdate(DiagramConnectionPart connPart) {
        Set<SapphirePartListener> listeners = this.getListeners();
        for (SapphirePartListener listener : listeners) {
            if (!(listener instanceof SapphireDiagramPartListener)) continue;
            DiagramConnectionEvent cue = new DiagramConnectionEvent(connPart);
            ((SapphireDiagramPartListener)listener).handleConnectionUpdateEvent(cue);
        }
    }

    private void notifyConnectionEndpointUpdate(DiagramConnectionPart connPart) {
        Set<SapphirePartListener> listeners = this.getListeners();
        for (SapphirePartListener listener : listeners) {
            if (!(listener instanceof SapphireDiagramPartListener)) continue;
            DiagramConnectionEvent cue = new DiagramConnectionEvent(connPart);
            ((SapphireDiagramPartListener)listener).handleConnectionEndpointEvent(cue);
        }
    }

    private void notifyConnectionAdd(DiagramConnectionPart connPart) {
        Set<SapphirePartListener> listeners = this.getListeners();
        for (SapphirePartListener listener : listeners) {
            if (!(listener instanceof SapphireDiagramPartListener)) continue;
            DiagramConnectionEvent cue = new DiagramConnectionEvent(connPart);
            ((SapphireDiagramPartListener)listener).handleConnectionAddEvent(cue);
        }
    }

    private void notifyConnectionDelete(DiagramConnectionPart connPart) {
        Set<SapphirePartListener> listeners = this.getListeners();
        for (SapphirePartListener listener : listeners) {
            if (!(listener instanceof SapphireDiagramPartListener)) continue;
            DiagramConnectionEvent cue = new DiagramConnectionEvent(connPart);
            ((SapphireDiagramPartListener)listener).handleConnectionDeleteEvent(cue);
        }
    }

    private void notifyGridStateChange() {
        Set<SapphirePartListener> listeners = this.getListeners();
        for (SapphirePartListener listener : listeners) {
            if (!(listener instanceof SapphireDiagramPartListener)) continue;
            DiagramPageEvent pageEvent = new DiagramPageEvent(this);
            ((SapphireDiagramPartListener)listener).handleGridStateChangeEvent(pageEvent);
        }
    }

    private class ConnectionTemplateListener
    extends DiagramConnectionTemplate.Listener {
        private ConnectionTemplateListener() {
        }

        public void handleConnectionUpdate(DiagramConnectionPart connPart) {
            SapphireDiagramEditorPagePart.this.notifyConnectionUpdate(connPart);
        }

        public void handleConnectionEndpointUpdate(DiagramConnectionPart connPart) {
            SapphireDiagramEditorPagePart.this.notifyConnectionEndpointUpdate(connPart);
        }

        public void handleConnectionAdd(DiagramConnectionPart connPart) {
            SapphireDiagramEditorPagePart.this.notifyConnectionAdd(connPart);
        }

        public void handleConnectionDelete(DiagramConnectionPart connPart) {
            SapphireDiagramEditorPagePart.this.notifyConnectionDelete(connPart);
        }
    }

    private class ImplicitConnectionTemplateListener
    extends DiagramImplicitConnectionTemplate.Listener {
        private ImplicitConnectionTemplateListener() {
        }

        public void handleConnectionAdd(DiagramImplicitConnectionPart connPart) {
            SapphireDiagramEditorPagePart.this.notifyConnectionAdd(connPart);
        }

        public void handleConnectionDelete(DiagramImplicitConnectionPart connPart) {
            SapphireDiagramEditorPagePart.this.notifyConnectionDelete(connPart);
        }
    }

    private class NodeTemplateListener
    extends DiagramNodeTemplate.Listener {
        private NodeTemplateListener() {
        }

        public void handleNodeUpdate(DiagramNodePart nodePart) {
            SapphireDiagramEditorPagePart.this.notifyNodeUpdate(nodePart);
        }

        public void handleNodeAdd(DiagramNodePart nodePart) {
            SapphireDiagramEditorPagePart.this.notifyNodeAdd(nodePart);
        }

        public void handleNodeDelete(DiagramNodePart nodePart) {
            SapphireDiagramEditorPagePart.this.notifyNodeDelete(nodePart);
        }

        public void handleNodeMove(DiagramNodeEvent event) {
            SapphireDiagramEditorPagePart.this.notifyNodeMove(event);
        }
    }
}

