/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireActionGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SapphireActionManager {
    private final ISapphirePart part;
    private final Set<String> contexts;
    private Map<String, SapphireActionGroup> actions;

    public SapphireActionManager(ISapphirePart part, Set<String> contexts) {
        this.part = part;
        this.contexts = contexts;
    }

    public Set<String> getActionContexts() {
        return this.contexts;
    }

    public String getMainActionContext() {
        Set<String> contexts = this.getActionContexts();
        if (!contexts.isEmpty()) {
            return contexts.iterator().next();
        }
        return null;
    }

    public SapphireActionGroup getActions() {
        String context = this.getMainActionContext();
        if (context != null) {
            return this.getActions(context);
        }
        return null;
    }

    public final SapphireActionGroup getActions(String context) {
        if (this.actions == null) {
            this.actions = new HashMap<String, SapphireActionGroup>();
            for (String ctxt : this.getActionContexts()) {
                SapphireActionGroup actionsForContext = new SapphireActionGroup(this.part, ctxt);
                this.actions.put(ctxt.toLowerCase(), actionsForContext);
            }
        }
        return this.actions.get(context.toLowerCase());
    }

    public final SapphireAction getAction(String id) {
        for (String context : this.getActionContexts()) {
            SapphireAction action = this.getActions(context).getAction(id);
            if (action == null) continue;
            return action;
        }
        if (this.part.getParentPart() != null) {
            return this.part.getParentPart().getAction(id);
        }
        return null;
    }

    public void dispose() {
        if (this.actions != null) {
            for (SapphireActionGroup actionsForContext : this.actions.values()) {
                actionsForContext.dispose();
            }
        }
    }
}

