/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.renderers.swt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.SortedSet;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ImageData;
import org.eclipse.sapphire.modeling.ImageService;
import org.eclipse.sapphire.modeling.ListProperty;
import org.eclipse.sapphire.modeling.LoggingService;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ModelPropertyChangeEvent;
import org.eclipse.sapphire.modeling.ModelService;
import org.eclipse.sapphire.modeling.PossibleValuesService;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.ValueImageService;
import org.eclipse.sapphire.modeling.ValueLabelService;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.NoDuplicates;
import org.eclipse.sapphire.modeling.localization.LocalizationService;
import org.eclipse.sapphire.ui.SapphireImageCache;
import org.eclipse.sapphire.ui.SapphirePropertyEditor;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.assist.internal.PropertyEditorAssistDecorator;
import org.eclipse.sapphire.ui.internal.SapphireUiFrameworkPlugin;
import org.eclipse.sapphire.ui.renderers.swt.ColumnSortComparator;
import org.eclipse.sapphire.ui.renderers.swt.ListPropertyEditorRenderer;
import org.eclipse.sapphire.ui.renderers.swt.PropertyEditorRenderer;
import org.eclipse.sapphire.ui.renderers.swt.PropertyEditorRendererFactory;
import org.eclipse.sapphire.ui.swt.renderer.GridLayoutUtil;
import org.eclipse.sapphire.ui.swt.renderer.SwtUtil;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class CheckBoxListPropertyEditorRenderer
extends ListPropertyEditorRenderer {
    private Table table;
    private CheckboxTableViewer tableViewer;
    private ModelElementType memberType;
    private ValueProperty memberProperty;

    public CheckBoxListPropertyEditorRenderer(SapphireRenderingContext context, SapphirePropertyEditor part) {
        super(context, part);
    }

    protected void createContents(Composite parent) {
        ModelProperty prop;
        SapphirePropertyEditor part = this.getPart();
        IModelElement element = part.getLocalModelElement();
        ListProperty listProperty = (ListProperty)part.getProperty();
        this.memberType = listProperty.getType();
        List allMemberProperties = this.memberType.getProperties();
        if (allMemberProperties.size() == 1) {
            prop = (ModelProperty)allMemberProperties.get(0);
            if (!(prop instanceof ValueProperty)) {
                throw new IllegalStateException();
            }
        } else {
            throw new IllegalStateException();
        }
        this.memberProperty = (ValueProperty)prop;
        final PossibleValuesService possibleValuesService = (PossibleValuesService)element.service((ModelProperty)this.memberProperty, PossibleValuesService.class);
        boolean showLabelAbove = part.getRenderingHint("show.label.above", false);
        boolean showLabelInline = part.getRenderingHint("show.label", !showLabelAbove);
        Label label = null;
        int baseIndent = part.getLeftMarginHint() + 9;
        if (showLabelInline || showLabelAbove) {
            label = new Label(parent, 0);
            label.setText(String.valueOf(listProperty.getLabel(false, CapitalizationType.FIRST_WORD_ONLY, true)) + ":");
            label.setLayoutData((Object)GridLayoutUtil.gdhindent(GridLayoutUtil.gdhspan(GridLayoutUtil.gdvalign(GridLayoutUtil.gd(), 128), showLabelAbove ? 2 : 1), baseIndent));
            this.context.adapt((Control)label);
        }
        this.setSpanBothColumns(!showLabelInline);
        Composite mainComposite = this.createMainComposite(parent);
        mainComposite.setLayout((Layout)GridLayoutUtil.glspacing(GridLayoutUtil.glayout(2, 0, 0), 2));
        PropertyEditorAssistDecorator decorator = this.createDecorator(mainComposite);
        decorator.control().setLayoutData((Object)GridLayoutUtil.gdvalign(GridLayoutUtil.gd(), 128));
        Composite tableComposite = new Composite(mainComposite, 0);
        tableComposite.setLayoutData((Object)GridLayoutUtil.gdwhint(GridLayoutUtil.gdfill(), 1));
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)tableColumnLayout);
        this.tableViewer = CheckboxTableViewer.newCheckList((Composite)tableComposite, (int)67584);
        this.table = this.tableViewer.getTable();
        TableViewerColumn viewerColumn = new TableViewerColumn((TableViewer)this.tableViewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(this.memberProperty.getLabel(false, CapitalizationType.TITLE_STYLE, false));
        tableColumnLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(1, 100, true));
        this.context.adapt((Control)mainComposite);
        decorator.addEditorControl((Control)mainComposite);
        SwtUtil.suppressDashedTableEntryBorder(this.table);
        final ColumnSortComparator comparator = new ColumnSortComparator(){

            protected String convertToString(Object obj) {
                return ((Entry)obj).value;
            }
        };
        IStructuredContentProvider contentProvider = new IStructuredContentProvider(){
            private List<Entry> entries = new ArrayList<Entry>();

            public Object[] getElements(Object input) {
                Entry entry;
                if (this.entries != null) {
                    for (Entry entry2 : this.entries) {
                        entry2.dispose();
                    }
                    this.entries = null;
                }
                Entry selection = (Entry)((IStructuredSelection)CheckBoxListPropertyEditorRenderer.this.tableViewer.getSelection()).getFirstElement();
                this.entries = new ArrayList<Entry>();
                HashSet<String> checked = new HashSet<String>();
                for (IModelElement element : CheckBoxListPropertyEditorRenderer.this.getList()) {
                    String value = CheckBoxListPropertyEditorRenderer.this.readMemberProperty(element);
                    if (selection != null && selection.value.equals(value)) {
                        entry = selection;
                        entry.element = element;
                        selection = null;
                    } else {
                        entry = new Entry(value, element);
                    }
                    this.entries.add(entry);
                    checked.add(value);
                }
                SortedSet possibleValues = null;
                try {
                    possibleValues = possibleValuesService.values();
                }
                catch (Exception e) {
                    SapphireUiFrameworkPlugin.log(e);
                }
                if (possibleValues != null) {
                    for (String value : possibleValues) {
                        if (checked.contains(value)) continue;
                        if (selection != null && selection.value.equals(value)) {
                            entry = selection;
                            entry.element = null;
                            selection = null;
                        } else {
                            entry = new Entry(value, null);
                        }
                        this.entries.add(entry);
                    }
                }
                Collections.sort(this.entries, comparator);
                return this.entries.toArray();
            }

            public void dispose() {
                for (Entry entry : this.entries) {
                    entry.dispose();
                }
                this.entries = null;
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
        this.tableViewer.setContentProvider((IContentProvider)contentProvider);
        ColumnLabelProvider labelProvider = new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((Entry)element).label();
            }

            public Image getImage(Object element) {
                return ((Entry)element).image();
            }

            public Color getForeground(Object element) {
                return ((Entry)element).foreground();
            }
        };
        viewerColumn.setLabelProvider((CellLabelProvider)labelProvider);
        ICheckStateProvider checkStateProvider = new ICheckStateProvider(){

            public boolean isChecked(Object element) {
                return ((Entry)element).selected();
            }

            public boolean isGrayed(Object element) {
                return false;
            }
        };
        this.tableViewer.setCheckStateProvider(checkStateProvider);
        if (part.getRenderingHint("show.header", true)) {
            this.table.setHeaderVisible(true);
            SwtUtil.makeTableSortable((TableViewer)this.tableViewer, Collections.singletonMap(column, comparator));
        }
        this.tableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                CheckBoxListPropertyEditorRenderer.this.handleCheckStateChangedEvent(event);
            }
        });
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                CheckBoxListPropertyEditorRenderer.this.handleDoubleClickEvent(event);
            }
        });
        this.tableViewer.setInput(new Object());
        this.addControl((Control)this.table);
    }

    protected boolean canExpandVertically() {
        return true;
    }

    protected void handleFocusReceivedEvent() {
        this.table.setFocus();
    }

    protected void handlePropertyChangedEvent() {
        super.handlePropertyChangedEvent();
        this.refresh();
    }

    protected void handleListElementChangedEvent(ModelPropertyChangeEvent event) {
        super.handleListElementChangedEvent(event);
        this.refresh();
    }

    private void refresh() {
        int oldItemCount = this.table.getItemCount();
        this.tableViewer.refresh();
        int newItemCount = this.table.getItemCount();
        if (oldItemCount != newItemCount) {
            this.table.getParent().layout(true, true);
        }
    }

    private void handleCheckStateChangedEvent(CheckStateChangedEvent event) {
        Entry entry = (Entry)event.getElement();
        entry.flip();
    }

    private void handleDoubleClickEvent(MouseEvent event) {
        Entry entry = null;
        TableItem[] tableItemArray = this.table.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getBounds().contains(event.x, event.y)) {
                entry = (Entry)item.getData();
                break;
            }
            ++n2;
        }
        if (entry != null) {
            entry.flip();
        }
    }

    private ModelElementType getMemberType() {
        return this.memberType;
    }

    private ValueProperty getMemberProperty() {
        return this.memberProperty;
    }

    private String readMemberProperty(IModelElement element) {
        String text = element.read(this.memberProperty).getText();
        return text == null ? "" : text;
    }

    public final class Entry {
        private final LocalizationService localizationService;
        private String value;
        private IModelElement element;
        private ValueLabelService valueLabelService;
        private ValueImageService valueImageService;
        private ImageService elementImageService;
        private ModelService.Listener listener;

        public Entry(String value, IModelElement element) {
            this.localizationService = (LocalizationService)CheckBoxListPropertyEditorRenderer.this.getPart().getDefinition().adapt(LocalizationService.class);
            this.value = value;
            this.element = element;
            IModelElement parent = CheckBoxListPropertyEditorRenderer.this.getModelElement();
            this.valueLabelService = (ValueLabelService)parent.service((ModelProperty)CheckBoxListPropertyEditorRenderer.this.memberProperty, ValueLabelService.class);
            this.valueImageService = (ValueImageService)parent.service((ModelProperty)CheckBoxListPropertyEditorRenderer.this.memberProperty, ValueImageService.class);
            this.listener = new ModelService.Listener(){

                public void handleEvent(ModelService.Event event) {
                    if (event instanceof ImageService.ImageChangedEvent) {
                        CheckBoxListPropertyEditorRenderer.this.tableViewer.update((Object)Entry.this, null);
                    }
                }
            };
            if (this.element != null) {
                this.elementImageService = (ImageService)this.element.service(ImageService.class);
                if (this.elementImageService != null) {
                    this.elementImageService.addListener(this.listener);
                }
            }
        }

        public String label() {
            String label = null;
            if (this.value.length() == 0) {
                label = Resources.emptyIndicator;
            } else {
                try {
                    label = this.valueLabelService.provide(this.value);
                }
                catch (Exception e) {
                    LoggingService.log((Exception)e);
                }
                if (label == null) {
                    label = this.value;
                } else if (!label.equals(this.value)) {
                    label = this.localizationService.transform(label, CapitalizationType.FIRST_WORD_ONLY, false);
                }
            }
            return label;
        }

        public Image image() {
            Image image;
            SapphireImageCache cache = CheckBoxListPropertyEditorRenderer.this.getPart().getImageCache();
            if (this.element == null || this.elementImageService == null) {
                ImageData imageData = null;
                try {
                    imageData = this.valueImageService.provide(this.value);
                }
                catch (Exception e) {
                    LoggingService.log((Exception)e);
                }
                if (imageData == null) {
                    imageData = CheckBoxListPropertyEditorRenderer.this.getMemberType().image();
                }
                image = cache.getImage(imageData);
            } else if (this.elementImageService != null) {
                Status st = this.element.read(CheckBoxListPropertyEditorRenderer.this.getMemberProperty()).validate();
                image = cache.getImage(this.elementImageService.provide(), st.severity());
            } else {
                image = null;
            }
            return image;
        }

        public Color foreground() {
            Color color = null;
            if (this.value.length() == 0) {
                color = Display.getCurrent().getSystemColor(16);
            }
            return color;
        }

        public boolean selected() {
            return this.element != null;
        }

        public void flip() {
            if (this.element == null) {
                this.element = CheckBoxListPropertyEditorRenderer.this.getList().addNewElement();
                this.element.write(CheckBoxListPropertyEditorRenderer.this.getMemberProperty(), (Object)this.value);
                this.elementImageService = (ImageService)this.element.service(ImageService.class);
                if (this.elementImageService != null) {
                    this.elementImageService.addListener(this.listener);
                }
            } else {
                if (this.elementImageService != null) {
                    this.elementImageService.removeListener(this.listener);
                    this.elementImageService = null;
                }
                IModelElement el = this.element;
                this.element = null;
                CheckBoxListPropertyEditorRenderer.this.getList().remove((Object)el);
            }
        }

        public void dispose() {
            if (this.elementImageService != null) {
                this.elementImageService.removeListener(this.listener);
            }
        }
    }

    public static final class EnumFactory
    extends PropertyEditorRendererFactory {
        public boolean isApplicableTo(SapphirePropertyEditor propertyEditorDefinition) {
            ModelProperty memberProperty;
            ModelElementType memberType;
            List properties;
            ListProperty listProperty;
            ModelProperty property = propertyEditorDefinition.getProperty();
            return property instanceof ListProperty && (listProperty = (ListProperty)property).getAllPossibleTypes().size() == 1 && (properties = (memberType = listProperty.getType()).getProperties()).size() == 1 && (memberProperty = (ModelProperty)properties.get(0)) instanceof ValueProperty && memberProperty.hasAnnotation(NoDuplicates.class) && Enum.class.isAssignableFrom(memberProperty.getTypeClass());
        }

        public PropertyEditorRenderer create(SapphireRenderingContext context, SapphirePropertyEditor part) {
            return new CheckBoxListPropertyEditorRenderer(context, part);
        }
    }

    public static final class Factory
    extends PropertyEditorRendererFactory {
        public boolean isApplicableTo(SapphirePropertyEditor propertyEditorDefinition) {
            return true;
        }

        public PropertyEditorRenderer create(SapphireRenderingContext context, SapphirePropertyEditor part) {
            return new CheckBoxListPropertyEditorRenderer(context, part);
        }
    }

    private static final class Resources
    extends NLS {
        public static String emptyIndicator;

        static {
            Resources.initializeMessages((String)CheckBoxListPropertyEditorRenderer.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

