/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.renderer;

import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.sapphire.ui.renderers.swt.ColumnSortComparator;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.forms.widgets.SharedScrolledComposite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SwtUtil {
    public static void setEnabledOnChildren(Composite composite, boolean enabled) {
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.setEnabled(enabled);
            ++n2;
        }
    }

    public static void makeTableSortable(TableViewer tableViewer) {
        Map<TableColumn, Comparator<Object>> comparators = Collections.emptyMap();
        SwtUtil.makeTableSortable(tableViewer, comparators, tableViewer.getTable().getColumn(0), 1024);
    }

    public static void makeTableSortable(TableViewer tableViewer, Map<TableColumn, Comparator<Object>> comparators) {
        SwtUtil.makeTableSortable(tableViewer, comparators, tableViewer.getTable().getColumn(0), 1024);
    }

    public static void makeTableSortable(final TableViewer tableViewer, Map<TableColumn, Comparator<Object>> comparators, TableColumn initialSortColumn, int initialSortDirection) {
        final Table table = tableViewer.getTable();
        SwtUtil.sortByTableColumn(tableViewer, initialSortColumn, initialSortDirection, comparators.get(initialSortColumn));
        TableColumn[] tableColumnArray = table.getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            final TableColumn column = tableColumnArray[n2];
            final Comparator<Object> comparator = comparators.get(column);
            column.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    TableColumn currentSortColumn = table.getSortColumn();
                    if (currentSortColumn != column) {
                        SwtUtil.sortByTableColumn(tableViewer, column, 1024, comparator);
                    } else {
                        int currentSortDirection = table.getSortDirection();
                        if (currentSortDirection == 1024) {
                            SwtUtil.sortByTableColumn(tableViewer, column, 128, comparator);
                        } else {
                            table.setSortColumn(null);
                            tableViewer.setComparator(null);
                        }
                    }
                }
            });
            ++n2;
        }
    }

    public static void sortByTableColumn(TableViewer tableViewer, TableColumn column, final int direction, Comparator<Object> comparator) {
        Table table = tableViewer.getTable();
        table.setSortColumn(column);
        table.setSortDirection(direction);
        final ColumnSortComparator comp = comparator != null ? comparator : new ColumnSortComparator();
        tableViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object x, Object y) {
                int result = comp.compare(x, y);
                if (direction == 128) {
                    result *= -1;
                }
                return result;
            }
        });
    }

    public static void suppressDashedTableEntryBorder(Table table) {
        table.addListener(40, new Listener(){

            public void handleEvent(Event event) {
                event.detail &= 0xFFFFFFFB;
            }
        });
    }

    public static void reflowOnResize(final Control control) {
        final GridData gd = (GridData)control.getLayoutData();
        final int originalWidthHint = gd.widthHint;
        Composite parent = control.getParent();
        while (parent != null && !(parent instanceof SharedScrolledComposite) && !(parent instanceof Shell)) {
            parent = parent.getParent();
        }
        final Composite topLevelComposite = parent;
        control.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                Rectangle bounds = control.getBounds();
                if (bounds.width != gd.widthHint + 20) {
                    gd.widthHint = bounds.width == gd.widthHint ? originalWidthHint : bounds.width - 20;
                    control.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            if (topLevelComposite.isDisposed()) {
                                return;
                            }
                            topLevelComposite.layout(true, true);
                            if (topLevelComposite instanceof SharedScrolledComposite) {
                                ((SharedScrolledComposite)topLevelComposite).reflow(true);
                            }
                        }
                    });
                }
            }
        });
    }
}

