/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.sdk;

import com.liferay.ide.eclipse.core.util.FileUtil;
import com.liferay.ide.eclipse.sdk.ISDKConstants;
import com.liferay.ide.eclipse.sdk.SDKPlugin;
import com.liferay.ide.eclipse.sdk.util.SDKHelper;
import com.liferay.ide.eclipse.sdk.util.SDKUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SDK {
    private static final String MSG_MANAGED_BY_LIFERAY_IDE = "Managed by Liferay IDE (remove this comment to prevent future updates)";
    private static final String PROJECT_FILE_PATTERN = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<projectDescription>\n\t<name>{0}</name>\n\t<comment></comment>\n\t<projects></projects>\n\t<buildSpec></buildSpec>\n\t<natures></natures>\n</projectDescription>\n";
    protected boolean contributed;
    protected boolean defaultSDK;
    protected IPath location;
    protected String name;
    protected String version;

    public static String createXMLNameValuePair(String name, String value) {
        return String.valueOf(name) + "=\"" + value + "\" ";
    }

    protected static IPreferenceStore getPrefStore() {
        return SDKPlugin.getDefault().getPreferenceStore();
    }

    public SDK() {
    }

    public SDK(IPath location) {
        this.location = location;
    }

    public void addProjectFile() {
        File projectFile;
        if (this.hasProjectFile()) {
            return;
        }
        if (this.location.toFile().exists() && !(projectFile = this.location.append(".project").toFile()).exists()) {
            try {
                FileUtil.writeFileFromStream((File)projectFile, (InputStream)new ByteArrayInputStream(MessageFormat.format(PROJECT_FILE_PATTERN, this.name).getBytes("UTF-8")));
            }
            catch (Exception e) {
                SDKPlugin.logError(e);
            }
        }
    }

    public IStatus buildLanguage(IProject project, IFile langFile, Map<String, String> overrideProperties, Map<String, String> appServerProperties) {
        SDKHelper antHelper = new SDKHelper(this);
        try {
            this.persistAppServerProperties(appServerProperties);
            HashMap<String, String> properties = new HashMap<String, String>();
            if (overrideProperties != null) {
                properties.putAll(overrideProperties);
            }
            String langDirLocation = langFile.getParent().getRawLocation().toOSString();
            String langFileName = langFile.getFullPath().removeFileExtension().lastSegment();
            properties.put("lang.dir", langDirLocation);
            properties.put("lang.file", langFileName);
            antHelper.runTarget(project.getFile(ISDKConstants.PROJECT_BUILD_XML).getRawLocation(), "build-lang-cmd", properties, true);
        }
        catch (Exception e) {
            return SDKPlugin.createErrorStatus(e);
        }
        return Status.OK_STATUS;
    }

    public IStatus buildService(IProject project, IFile serviceXmlFile, Map<String, String> overrideProperties, Map<String, String> appServerProperties) {
        SDKHelper antHelper = new SDKHelper(this);
        try {
            this.persistAppServerProperties(appServerProperties);
            HashMap<String, String> properties = new HashMap<String, String>();
            if (overrideProperties != null) {
                properties.putAll(overrideProperties);
            }
            String serviceFile = serviceXmlFile.getRawLocation().toOSString();
            properties.put("service.file", serviceXmlFile.getRawLocation().toOSString());
            properties.put("service.input.file", serviceFile);
            antHelper.runTarget(project.getFile(ISDKConstants.PROJECT_BUILD_XML).getRawLocation(), "build-service", properties, true);
        }
        catch (Exception e) {
            return SDKPlugin.createErrorStatus(e);
        }
        return Status.OK_STATUS;
    }

    public IStatus buildWSDD(IProject project, IFile serviceXmlFile, Map<String, String> overrideProperties, Map<String, String> appServerProperties) {
        SDKHelper antHelper = new SDKHelper(this);
        try {
            this.persistAppServerProperties(appServerProperties);
            HashMap<String, String> properties = new HashMap<String, String>();
            if (overrideProperties != null) {
                properties.putAll(overrideProperties);
            }
            String serviceFile = serviceXmlFile.getRawLocation().toOSString();
            properties.put("service.file", serviceXmlFile.getRawLocation().toOSString());
            properties.put("service.input.file", serviceFile);
            antHelper.runTarget(project.getFile(ISDKConstants.PROJECT_BUILD_XML).getRawLocation(), "build-wsdd", properties, true);
        }
        catch (Exception e) {
            return SDKPlugin.createErrorStatus(e);
        }
        return Status.OK_STATUS;
    }

    public IStatus cleanAppServer(IProject project, IPath bundleZipLocation, Map<String, String> appServerProperties) {
        try {
            this.persistAppServerProperties(appServerProperties);
            HashMap<String, String> properties = new HashMap<String, String>();
            String appServerDir = (String)properties.get("app.server.dir");
            IPath workPath = new Path(appServerDir).removeLastSegments(2);
            properties.put("app.server.zip.name", bundleZipLocation.toOSString());
            properties.put("ext.work.dir", workPath.toOSString());
            IStatus status = this.runTarget(project, properties, "clean-app-server", true);
            if (!status.isOK()) {
                return status;
            }
        }
        catch (Exception ex) {
            return SDKPlugin.createErrorStatus(ex);
        }
        return Status.OK_STATUS;
    }

    public IStatus compileThemePlugin(IProject project, Map<String, String> overrideProperties, Map<String, String> appServerProperties) {
        SDKHelper antHelper = new SDKHelper(this);
        try {
            this.persistAppServerProperties(appServerProperties);
            HashMap<String, String> properties = new HashMap<String, String>();
            if (overrideProperties != null) {
                properties.putAll(overrideProperties);
            }
            antHelper.runTarget(project.getFile(ISDKConstants.PROJECT_BUILD_XML).getRawLocation(), "compile", properties, true);
        }
        catch (Exception e) {
            return SDKPlugin.createErrorStatus(e);
        }
        return Status.OK_STATUS;
    }

    public IPath createNewExtProject(String extName, String extDisplayName, Map<String, String> appServerProperties) {
        try {
            SDKHelper antHelper = new SDKHelper(this);
            this.persistAppServerProperties(appServerProperties);
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.putAll(appServerProperties);
            properties.put("ext.name", extName);
            properties.put("ext.display.name", extDisplayName);
            IPath tempPath = SDKPlugin.getDefault().getStateLocation().append("create").append(String.valueOf(System.currentTimeMillis()));
            properties.put("ext.parent.dir", tempPath.toOSString());
            antHelper.runTarget(this.getLocation().append(ISDKConstants.EXT_PLUGIN_ANT_BUILD), "create", properties);
            return tempPath;
        }
        catch (Exception e) {
            SDKPlugin.logError(e);
            return null;
        }
    }

    public IPath createNewHookProject(String hookName, String hookDisplayName) {
        SDKHelper antHelper = new SDKHelper(this);
        try {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("hook.name", hookName);
            properties.put("hook.display.name", hookDisplayName);
            IPath newHookPath = SDKPlugin.getDefault().getStateLocation().append("create").append(String.valueOf(System.currentTimeMillis()));
            properties.put("hook.parent.dir", newHookPath.toOSString());
            antHelper.runTarget(this.getLocation().append(ISDKConstants.HOOK_PLUGIN_ANT_BUILD), "create", properties);
            return newHookPath;
        }
        catch (CoreException e) {
            SDKPlugin.logError((Exception)((Object)e));
            return null;
        }
    }

    public IPath createNewLayoutTplProject(String layoutTplName, String layoutTplDisplayName, Map<String, String> appServerProperties) {
        SDKHelper antHelper = new SDKHelper(this);
        try {
            this.persistAppServerProperties(appServerProperties);
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.putAll(appServerProperties);
            properties.put("layouttpl.name", layoutTplName);
            properties.put("layouttpl.display.name", layoutTplDisplayName);
            IPath newLayoutTplPath = SDKPlugin.getDefault().getStateLocation().append("create").append(String.valueOf(System.currentTimeMillis()));
            properties.put("layouttpl.parent.dir", newLayoutTplPath.toOSString());
            antHelper.runTarget(this.getLocation().append(ISDKConstants.LAYOUTTPL_PLUGIN_ANT_BUILD), "create", properties);
            return newLayoutTplPath;
        }
        catch (Exception e) {
            SDKPlugin.logError(e);
            return null;
        }
    }

    public IPath createNewPortletProject(String portletName, String portletDisplayName, Map<String, String> appServerProperties) {
        return this.createNewPortletProject(portletName, portletDisplayName, null, appServerProperties);
    }

    public IPath createNewPortletProject(String portletName, String portletDisplayName, String portletFramework, Map<String, String> appServerProperties) {
        SDKHelper antHelper = new SDKHelper(this);
        try {
            this.persistAppServerProperties(appServerProperties);
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("portlet.name", portletName);
            properties.put("portlet.display.name", portletDisplayName);
            properties.put("portlet.framework", portletFramework);
            IPath newPortletPath = SDKPlugin.getDefault().getStateLocation().append("create").append(String.valueOf(System.currentTimeMillis()));
            properties.put("portlet.parent.dir", newPortletPath.toOSString());
            antHelper.runTarget(this.getLocation().append(ISDKConstants.PORTLET_PLUGIN_ANT_BUILD), "create", properties);
            return newPortletPath;
        }
        catch (Exception e) {
            SDKPlugin.logError(e);
            return null;
        }
    }

    public IPath createNewThemeProject(String themeName, String themeDisplayName) {
        SDKHelper antHelper = new SDKHelper(this);
        try {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("theme.name", themeName);
            properties.put("theme.display.name", themeDisplayName);
            IPath tempPath = SDKPlugin.getDefault().getStateLocation().append("create").append(String.valueOf(System.currentTimeMillis()));
            properties.put("theme.parent.dir", tempPath.toOSString());
            antHelper.runTarget(this.getLocation().append(ISDKConstants.THEME_PLUGIN_ANT_BUILD), "create", properties);
            return tempPath;
        }
        catch (CoreException e) {
            SDKPlugin.logError((Exception)((Object)e));
            return null;
        }
    }

    public IStatus directDeploy(IProject project, Map<String, String> overrideProperties, boolean separateJRE, Map<String, String> appServerProperties) {
        try {
            SDKHelper antHelper = new SDKHelper(this);
            this.persistAppServerProperties(appServerProperties);
            HashMap<String, String> properties = new HashMap<String, String>();
            if (overrideProperties != null) {
                properties.putAll(overrideProperties);
            }
            antHelper.runTarget(project.getFile(ISDKConstants.PROJECT_BUILD_XML).getRawLocation(), "direct-deploy", properties, separateJRE);
        }
        catch (Exception e) {
            return SDKPlugin.createErrorStatus(e);
        }
        return Status.OK_STATUS;
    }

    public boolean equals(Object obj) {
        return obj instanceof SDK && this.getName() != null && this.getName().equals(((SDK)obj).getName()) && this.getLocation() != null && this.getLocation().equals((Object)((SDK)obj).getLocation());
    }

    public IPath[] getAntLibraries() {
        ArrayList<IPath> antLibs = new ArrayList<IPath>();
        String[] stringArray = ISDKConstants.ANT_LIBRARIES;
        int n = ISDKConstants.ANT_LIBRARIES.length;
        int n2 = 0;
        while (n2 < n) {
            String antLib = stringArray[n2];
            antLibs.add(this.getLocation().append(antLib));
            ++n2;
        }
        return antLibs.toArray(new IPath[0]);
    }

    public IPath getLocation() {
        return this.location;
    }

    public String getName() {
        return this.name;
    }

    public IPath getPortletTemplatePath() {
        return this.getLocation().append(ISDKConstants.PORTLET_PLUGIN_ZIP_PATH);
    }

    public String getVersion() {
        return this.version;
    }

    public boolean hasProjectFile() {
        return this.location != null && this.location.append(".project").toFile().exists();
    }

    public boolean isContributed() {
        return this.contributed;
    }

    public boolean isDefault() {
        return this.defaultSDK;
    }

    public boolean isValid() {
        IPath sdkLocation = this.getLocation();
        if (sdkLocation == null) {
            return false;
        }
        if (!SDKUtil.isSDKSupported(sdkLocation.toOSString())) {
            return false;
        }
        return SDKUtil.isValidSDKLocation(sdkLocation.toOSString());
    }

    public void loadFromMemento(IMemento sdkElement) {
        this.setName(sdkElement.getString("name"));
        this.setLocation(Path.fromPortableString((String)sdkElement.getString("location")));
        this.setVersion(sdkElement.getString("version"));
    }

    public void saveToMemento(IMemento child) {
        child.putString("name", this.getName());
        child.putString("location", this.getLocation().toPortableString());
        child.putString("version", this.getVersion());
    }

    public void setContributed(boolean contributed) {
        this.contributed = contributed;
    }

    public void setDefault(boolean defaultSDK) {
        this.defaultSDK = defaultSDK;
    }

    public void setLocation(IPath location) {
        this.location = location;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String toString() {
        return this.getName();
    }

    public String toXmlString() {
        StringBuilder builder = new StringBuilder();
        builder.append("<sdk ");
        builder.append(SDK.createXMLNameValuePair("name", this.getName()));
        builder.append(SDK.createXMLNameValuePair("location", this.getLocation().toPortableString()));
        builder.append(SDK.createXMLNameValuePair("version", this.getVersion()));
        builder.append("/>");
        return builder.toString();
    }

    public IStatus validate() {
        boolean validLocation = SDKUtil.isValidSDKLocation(this.getLocation().toOSString());
        boolean buildXmlExists = this.getLocation().append("build.xml").toFile().exists();
        if (!validLocation) {
            return SDKPlugin.createErrorStatus("SDK location is invalid.");
        }
        if (!buildXmlExists) {
            return SDKPlugin.createErrorStatus("build.xml file does not exist.");
        }
        return Status.OK_STATUS;
    }

    public IStatus war(IProject project, Map<String, String> overrideProperties, boolean separateJRE, Map<String, String> appServerProperties) {
        return this.war(project, overrideProperties, separateJRE, appServerProperties, null);
    }

    public IStatus war(IProject project, Map<String, String> overrideProperties, boolean separateJRE, Map<String, String> appServerProperties, String[] vmargs) {
        try {
            SDKHelper antHelper = new SDKHelper(this);
            antHelper.setVMArgs(vmargs);
            this.persistAppServerProperties(appServerProperties);
            HashMap<String, String> properties = new HashMap<String, String>();
            if (overrideProperties != null) {
                properties.putAll(overrideProperties);
            }
            antHelper.runTarget(project.getFile(ISDKConstants.PROJECT_BUILD_XML).getRawLocation(), "war", properties, separateJRE);
        }
        catch (Exception e) {
            return SDKPlugin.createErrorStatus(e);
        }
        return Status.OK_STATUS;
    }

    private boolean promptForOverwrite(final File userBuildFile) {
        final boolean[] retval = new boolean[1];
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                String message = MessageFormat.format("The user build.properties file in \"{0}\" SDK has not been updated with the latest app server build properties.  Should these properties be written to the file \"{1}\"?\n\nAnswering no will pass these properties directly to Ant and disregard any settings in the user build.properties file.", SDK.this.getName(), userBuildFile.getName());
                MessageDialogWithToggle dialog = MessageDialogWithToggle.openYesNoQuestion((Shell)Display.getDefault().getActiveShell(), (String)"Plugins SDK", (String)message, (String)"Remember this answer for future SDK operations.", (boolean)false, (IPreferenceStore)SDK.getPrefStore(), (String)"OVERWRITE_USER_BUILD_FILE");
                retval[0] = dialog.getReturnCode() == 2;
            }
        });
        return retval[0];
    }

    protected void persistAppServerProperties(Map<String, String> properties) throws FileNotFoundException, IOException, ConfigurationException {
        String userName;
        IPath loc = this.getLocation();
        File userBuildFile = loc.append("build." + (userName = System.getProperty("user.name")) + ".properties").toFile();
        if (userBuildFile.exists()) {
            String overwrite;
            PropertiesConfiguration propsConfig = new PropertiesConfiguration(userBuildFile);
            String header = propsConfig.getHeader();
            boolean shouldUpdateBuildFile = false;
            shouldUpdateBuildFile = header != null && header.contains(MSG_MANAGED_BY_LIFERAY_IDE) ? true : ("always".equals(overwrite = SDK.getPrefStore().getString("OVERWRITE_USER_BUILD_FILE")) ? true : ("never".equals(overwrite) ? false : this.promptForOverwrite(userBuildFile)));
            if (shouldUpdateBuildFile) {
                for (String key : properties.keySet()) {
                    propsConfig.setProperty(key, (Object)properties.get(key));
                }
                propsConfig.setHeader(MSG_MANAGED_BY_LIFERAY_IDE);
                propsConfig.save(userBuildFile);
            }
        } else {
            Properties props = new Properties();
            props.putAll(properties);
            props.store(new FileOutputStream(userBuildFile), MSG_MANAGED_BY_LIFERAY_IDE);
        }
    }

    protected IStatus runTarget(IProject project, Map<String, String> properties, String target, boolean separateJRE) {
        SDKHelper antHelper = new SDKHelper(this);
        try {
            antHelper.runTarget(project.getFile(ISDKConstants.PROJECT_BUILD_XML).getRawLocation(), target, properties, separateJRE);
        }
        catch (CoreException e) {
            return SDKPlugin.createErrorStatus(e);
        }
        return Status.OK_STATUS;
    }
}

