/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.sdk;

import com.liferay.ide.eclipse.core.CorePlugin;
import com.liferay.ide.eclipse.core.util.CoreUtil;
import com.liferay.ide.eclipse.sdk.ISDKConstants;
import com.liferay.ide.eclipse.sdk.SDK;
import com.liferay.ide.eclipse.sdk.SDKPlugin;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.framework.Version;

public final class SDKManager {
    private static SDKManager instance;
    private boolean initialized = false;
    private ArrayList<SDK> sdkList;

    public SDK getDefaultSDK() {
        SDK[] sDKArray = this.getSDKs();
        int n = sDKArray.length;
        int n2 = 0;
        while (n2 < n) {
            SDK sdk = sDKArray[n2];
            if (sdk.isDefault()) {
                return sdk;
            }
            ++n2;
        }
        return null;
    }

    public static SDKManager getInstance() {
        if (instance == null) {
            instance = new SDKManager();
        }
        return instance;
    }

    public static Version getLeastValidVersion() {
        return ISDKConstants.LEAST_SUPPORTED_SDK_VERSION;
    }

    public SDK getSDK(IPath sdkLocation) {
        SDK[] sDKArray = this.getSDKs();
        int n = sDKArray.length;
        int n2 = 0;
        while (n2 < n) {
            SDK sdk = sDKArray[n2];
            if (sdk.getLocation().equals((Object)sdkLocation)) {
                return sdk;
            }
            ++n2;
        }
        return null;
    }

    public void saveSDKs(SDK[] sdks) {
        this.setSDKs(sdks);
    }

    private SDKManager() {
        instance = this;
    }

    public void addSDK(SDK sdk) {
        if (!this.initialized) {
            this.initialize();
        }
        this.sdkList.add(sdk);
        if (this.sdkList.size() == 1) {
            sdk.setDefault(true);
        }
        this.saveSDKs();
    }

    public SDK getSDK(String sdkName) {
        if (sdkName == null) {
            return null;
        }
        SDK[] sDKArray = this.getSDKs();
        int n = sDKArray.length;
        int n2 = 0;
        while (n2 < n) {
            SDK sdk = sDKArray[n2];
            if (sdkName.equals(sdk.getName())) {
                return sdk;
            }
            ++n2;
        }
        return null;
    }

    public SDK[] getSDKs() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.sdkList.toArray(new SDK[this.sdkList.size()]);
    }

    public void setSDKs(SDK[] sdks) {
        this.sdkList.clear();
        SDK[] sDKArray = sdks;
        int n = sdks.length;
        int n2 = 0;
        while (n2 < n) {
            SDK sdk = sDKArray[n2];
            this.sdkList.add(sdk);
            ++n2;
        }
        this.saveSDKs();
    }

    private ScopedPreferenceStore getPrefStore() {
        return (ScopedPreferenceStore)SDKPlugin.getDefault().getPreferenceStore();
    }

    private void initialize() {
        this.loadSDKs();
        this.initialized = true;
    }

    private void loadSDKs() {
        this.sdkList = new ArrayList();
        ScopedPreferenceStore prefs = this.getPrefStore();
        String sdksXmlString = prefs.getString("sdks");
        if (!CoreUtil.isNullOrEmpty((String)sdksXmlString)) {
            try {
                IMemento[] children;
                XMLMemento root = XMLMemento.createReadRoot((Reader)new InputStreamReader(new ByteArrayInputStream(sdksXmlString.getBytes("UTF-8"))));
                String defaultSDKName = root.getString("default");
                IMemento[] iMementoArray = children = root.getChildren("sdk");
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    IMemento sdkElement = iMementoArray[n2];
                    SDK sdk = new SDK();
                    sdk.loadFromMemento(sdkElement);
                    boolean defaultSDK = sdk.getName() != null && sdk.getName().equals(defaultSDKName);
                    sdk.setDefault(defaultSDK);
                    this.sdkList.add(sdk);
                    ++n2;
                }
            }
            catch (Exception e) {
                SDKPlugin.logError(e);
            }
        }
    }

    private void saveSDKs() {
        XMLMemento root = XMLMemento.createWriteRoot((String)"sdks");
        for (SDK sdk : this.sdkList) {
            IMemento child = root.createChild("sdk");
            sdk.saveToMemento(child);
            if (!sdk.isDefault()) continue;
            root.putString("default", sdk.getName());
        }
        StringWriter writer = new StringWriter();
        try {
            root.save((Writer)writer);
            this.getPrefStore().setValue("sdks", writer.toString());
            this.getPrefStore().save();
        }
        catch (IOException e) {
            CorePlugin.logError((Throwable)e);
        }
    }

    public boolean containsSDK(SDK theSDK) {
        if (theSDK != null && this.getSDKs().length > 0) {
            SDK[] sDKArray = this.getSDKs();
            int n = sDKArray.length;
            int n2 = 0;
            while (n2 < n) {
                SDK sdk = sDKArray[n2];
                if (theSDK.equals(sdk)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }
}

