/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.sdk.pref;

import com.liferay.ide.eclipse.sdk.SDK;
import com.liferay.ide.eclipse.sdk.SDKManager;
import com.liferay.ide.eclipse.sdk.SDKPlugin;
import com.liferay.ide.eclipse.sdk.pref.InstalledSDKsCompostite;
import com.liferay.ide.eclipse.ui.util.SWTUtil;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class SDKsPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "com.liferay.ide.eclipse.sdk.preferences.installedSDKs";
    private Composite parent;
    protected InstalledSDKsCompostite installedSDKsComposite;

    public SDKsPreferencePage() {
        this.setImageDescriptor(SDKPlugin.imageDescriptorFromPlugin((String)"com.liferay.ide.eclipse.sdk", (String)"/icons/e16/sdk.png"));
    }

    public IPreferenceStore getPreferenceStore() {
        return SDKPlugin.getDefault().getPreferenceStore();
    }

    public void init(IWorkbench workbench) {
        this.noDefaultAndApplyButton();
    }

    public boolean isValid() {
        return this.installedSDKsComposite != null && (this.installedSDKsComposite.getSDKs().length == 0 || this.installedSDKsComposite.getCheckedSDK() != null);
    }

    public boolean performOk() {
        super.performOk();
        if (this.isValid()) {
            SDK[] sdks = this.installedSDKsComposite.getSDKs();
            if (sdks != null) {
                SDKManager.getInstance().saveSDKs(sdks);
            }
            return true;
        }
        this.setMessage("Must have at least one SDK checked as default", 3);
        return false;
    }

    protected Control createContents(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.parent = parent;
        SWTUtil.createWrapLabel((Composite)parent, (String)"Add, remove or edit SDK definitions. By default, the checked SDK is used for new Liferay Plugin projects.", (int)1, (int)100);
        SWTUtil.createVerticalSpacer((Composite)parent, (int)1, (int)1);
        this.installedSDKsComposite = new InstalledSDKsCompostite(parent, 0);
        this.installedSDKsComposite.setPreferencePage((PreferencePage)this);
        GridData data = new GridData(1808);
        data.horizontalSpan = 1;
        this.installedSDKsComposite.setLayoutData(data);
        this.installedSDKsComposite.setSDKs(SDKManager.getInstance().getSDKs());
        this.createFieldEditors();
        this.initialize();
        this.checkState();
        return parent;
    }

    public void applyData(Object data) {
        if ("new".equals(data)) {
            this.getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    SDKsPreferencePage.this.installedSDKsComposite.addSDK();
                }
            });
        }
    }

    protected void createFieldEditors() {
        RadioGroupFieldEditor edit = new RadioGroupFieldEditor("OVERWRITE_USER_BUILD_FILE", "Update build.<username>.properties before SDK is used.", 3, (String[][])new String[][]{{"Always", "always"}, {"Never", "never"}, {"Prompt", "prompt"}}, this.parent, true);
        edit.setPreferenceStore(this.getPreferenceStore());
        this.addField((FieldEditor)edit);
    }

    protected void performDefaults() {
        if (this.installedSDKsComposite != null && !this.installedSDKsComposite.isDisposed()) {
            this.installedSDKsComposite.setSDKs(SDKManager.getInstance().getSDKs());
        }
        this.getPreferenceStore().setValue("prompt", "OVERWRITE_USER_BUILD_FILE");
    }
}

