/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.eclipse.sdk.util;

import com.liferay.ide.eclipse.core.util.CoreUtil;
import com.liferay.ide.eclipse.sdk.SDK;
import com.liferay.ide.eclipse.sdk.SDKPlugin;
import com.liferay.ide.eclipse.ui.util.LaunchHelper;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.CommonTab;
import org.eclipse.jdt.internal.debug.ui.classpath.ClasspathModel;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.JavaRuntime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SDKHelper
extends LaunchHelper {
    public static final String ANT_CLASSPATH_PROVIDER = "org.eclipse.ant.ui.AntClasspathProvider";
    public static final String ANT_LAUNCH_CONFIG_TYPE_ID = "org.eclipse.ant.AntLaunchConfigurationType";
    protected IPath currentBuildFile;
    protected String currentTargets;
    protected SDK sdk;
    private String[] additionalVMArgs;

    public SDKHelper(SDK sdk) {
        super(ANT_LAUNCH_CONFIG_TYPE_ID);
        this.sdk = sdk;
        this.setLaunchSync(true);
        this.setLaunchInBackground(true);
        this.setLaunchCaptureInConsole(true);
        this.setLaunchIsPrivate(true);
    }

    public ILaunchConfiguration createLaunchConfiguration(IPath buildFile, String targets, Map<String, String> properties, boolean separateJRE) throws CoreException {
        ILaunchConfigurationWorkingCopy launchConfig = super.createLaunchConfiguration();
        launchConfig.setAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", buildFile.toOSString());
        launchConfig.setAttribute("org.eclipse.ui.externaltools.ATTR_WORKING_DIRECTORY", buildFile.removeLastSegments(1).toOSString());
        launchConfig.setAttribute("org.eclipse.ui.externaltools.ATTR_ANT_TARGETS", targets);
        CommonTab tab = new CommonTab();
        tab.setDefaults(launchConfig);
        tab.dispose();
        launchConfig.setAttribute("org.eclipse.debug.ui.ATTR_CAPTURE_IN_FILE", SDKPlugin.getDefault().getStateLocation().append("sdk.log").toOSString());
        launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_SOURCE_PATH_PROVIDER, ANT_CLASSPATH_PROVIDER);
        launchConfig.setAttribute("process_factory_id", "org.eclipse.ant.ui.remoteAntProcessFactory");
        launchConfig.setAttribute("org.eclipse.ui.externaltools.ATTR_ANT_PROPERTIES", properties);
        launchConfig.setAttribute("org.eclipse.ui.externaltools.ATTR_ANT_PROPERTY_FILES", null);
        if (separateJRE) {
            launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, "org.eclipse.ant.internal.launching.remote.InternalAntRunner");
            launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, this.getVMArgumentsAttr());
        }
        return launchConfig;
    }

    private String getVMArgumentsAttr() {
        StringBuffer args = new StringBuffer("-Xmx768m");
        if (!CoreUtil.isNullOrEmpty((Object[])this.additionalVMArgs)) {
            String[] stringArray = this.additionalVMArgs;
            int n = this.additionalVMArgs.length;
            int n2 = 0;
            while (n2 < n) {
                String vmArg = stringArray[n2];
                args.append(" " + vmArg);
                ++n2;
            }
        }
        return args.toString();
    }

    public String getClasspathProviderAttributeValue() {
        return "com.liferay.ide.eclipse.sdk.SDKClasspathProvider";
    }

    public String getNewLaunchConfigurationName() {
        StringBuffer buffer = new StringBuffer();
        if (this.sdk.getName() != null) {
            buffer.append(this.sdk.getName());
            buffer.append(' ');
        }
        if (this.currentBuildFile != null) {
            buffer.append(this.currentBuildFile.lastSegment());
        }
        if (this.currentTargets != null) {
            buffer.append(" [");
            buffer.append(this.currentTargets);
            buffer.append("]");
        }
        return buffer.toString();
    }

    public void runTarget(IPath buildFile, String targets, Map<String, String> properties) throws CoreException {
        this.runTarget(buildFile, targets, properties, false);
    }

    public void runTarget(IPath buildFile, String targets, Map<String, String> properties, boolean separateJRE) throws CoreException {
        if (this.isLaunchRunning()) {
            throw new IllegalStateException("Existing launch in progress");
        }
        this.currentBuildFile = buildFile;
        this.currentTargets = targets;
        ILaunchConfiguration launchConfig = this.createLaunchConfiguration(buildFile, targets, properties, separateJRE);
        this.launch(launchConfig, "run", null);
        this.currentBuildFile = null;
        this.currentTargets = null;
    }

    protected void addUserEntries(ClasspathModel model) throws CoreException {
        IPath[] antLibs;
        IPath[] iPathArray = antLibs = this.sdk.getAntLibraries();
        int n = antLibs.length;
        int n2 = 0;
        while (n2 < n) {
            IPath antLib = iPathArray[n2];
            if (antLib.toFile().exists()) {
                model.addEntry(1, JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)antLib));
            }
            ++n2;
        }
    }

    public void setVMArgs(String[] vmargs) {
        this.additionalVMArgs = vmargs;
    }
}

