/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.core.util;

import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.core.util.FileUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.j2ee.componentcore.J2EEModuleVirtualComponent;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;
import org.eclipse.wst.validation.internal.ValType;
import org.eclipse.wst.validation.internal.ValidationRunner;
import org.osgi.framework.Version;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoreUtil {
    public static void addNaturesToProject(IProject proj, String[] natureIds, IProgressMonitor monitor) throws CoreException {
        IProjectDescription description = proj.getDescription();
        String[] prevNatures = description.getNatureIds();
        String[] newNatures = new String[prevNatures.length + natureIds.length];
        System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
        int i = prevNatures.length;
        while (i < newNatures.length) {
            newNatures[i] = natureIds[i - prevNatures.length];
            ++i;
        }
        description.setNatureIds(newNatures);
        proj.setDescription(description, monitor);
    }

    public static int compareVersions(Version v1, Version v2) {
        if (v2 == v1) {
            return 0;
        }
        int result = v1.getMajor() - v2.getMajor();
        if (result != 0) {
            return result;
        }
        result = v1.getMinor() - v2.getMinor();
        if (result != 0) {
            return result;
        }
        result = v1.getMicro() - v2.getMicro();
        if (result != 0) {
            return result;
        }
        return v1.getQualifier().compareTo(v2.getQualifier());
    }

    public static boolean containsMember(IModuleResourceDelta delta, String[] paths) {
        if (delta == null) {
            return false;
        }
        IModuleResourceDelta[] currentChildren = delta.getAffectedChildren();
        if (currentChildren == null) {
            IFile file = (IFile)delta.getModuleResource().getAdapter(IFile.class);
            if (file != null) {
                String filePath = file.getFullPath().toString();
                String[] stringArray = paths;
                int n = paths.length;
                int n2 = 0;
                while (n2 < n) {
                    String path = stringArray[n2];
                    if (filePath.contains(path)) {
                        return true;
                    }
                    ++n2;
                }
            }
            return false;
        }
        int j = 0;
        int jmax = currentChildren.length;
        while (j < jmax) {
            IPath moduleRelativePath = currentChildren[j].getModuleRelativePath();
            String moduleRelativePathValue = moduleRelativePath.toString();
            String moduleRelativeLastSegment = moduleRelativePath.lastSegment();
            String[] stringArray = paths;
            int n = paths.length;
            int n3 = 0;
            while (n3 < n) {
                String path = stringArray[n3];
                if (moduleRelativePathValue.equals(path) || moduleRelativeLastSegment.equals(path)) {
                    return true;
                }
                ++n3;
            }
            boolean childContains = CoreUtil.containsMember(currentChildren[j], paths);
            if (childContains) {
                return true;
            }
            ++j;
        }
        return false;
    }

    public static IStatus createErrorStatus(String msg) {
        return new Status(4, "com.liferay.ide.core", msg);
    }

    public static final String createStringDigest(String str) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] input = str.getBytes("UTF-8");
            byte[] digest = md.digest(input);
            StringBuilder buf = new StringBuilder();
            int i = 0;
            while (i < digest.length) {
                String hex = Integer.toHexString(0xFF & digest[i]);
                if (hex.length() == 1) {
                    buf.append('0');
                }
                buf.append(hex);
                ++i;
            }
            return buf.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void deleteResource(IResource resource) throws CoreException {
        if (resource == null || !resource.exists()) {
            return;
        }
        resource.delete(true, null);
    }

    public static boolean empty(Object[] array) {
        return CoreUtil.isNullOrEmpty(array);
    }

    public static boolean empty(String val) {
        return CoreUtil.isNullOrEmpty(val);
    }

    public static IProject findProjectByContextName(String contextName) {
        IProject retval = null;
        if (!CoreUtil.isNullOrEmpty(contextName)) {
            IProject[] iProjectArray = CoreUtil.getAllProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                String contextRoot;
                Properties metaProperties;
                IProject project = iProjectArray[n2];
                IVirtualComponent c = ComponentCore.createComponent((IProject)project, (boolean)true);
                if (c != null && (metaProperties = c.getMetaProperties()) != null && contextName.equals(contextRoot = metaProperties.getProperty("context-root"))) {
                    retval = project;
                    break;
                }
                ++n2;
            }
        }
        return retval;
    }

    public static IProject[] getAllProjects() {
        return ResourcesPlugin.getWorkspace().getRoot().getProjects();
    }

    public static IClasspathEntry[] getClasspathEntries(IProject project) {
        if (project != null) {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            try {
                IClasspathEntry[] classPathEntries = javaProject.getRawClasspath();
                return classPathEntries;
            }
            catch (JavaModelException javaModelException) {}
        }
        return null;
    }

    public static IFolder getDefaultDocrootFolder(IProject project) {
        IFolder folder;
        IPath defaultFolder;
        IVirtualFolder webappRoot;
        if (project != null && (webappRoot = CoreUtil.getDocroot(project)) != null && (defaultFolder = J2EEModuleVirtualComponent.getDefaultDeploymentDescriptorFolder((IVirtualFolder)webappRoot)) != null && (folder = project.getFolder(defaultFolder)).exists()) {
            return folder;
        }
        return null;
    }

    public static IVirtualFolder getDocroot(IProject project) {
        IVirtualComponent comp;
        IVirtualFolder retval = null;
        if (project != null && (comp = ComponentCore.createComponent((IProject)project)) != null) {
            retval = comp.getRootFolder();
        }
        return retval;
    }

    public static IVirtualFolder getDocroot(String projectName) {
        IProject project = CoreUtil.getProject(projectName);
        return CoreUtil.getDocroot(project);
    }

    public static IFile getDocrootFile(IProject project, String filePath) {
        IVirtualFile file;
        IVirtualFolder webappRoot;
        IFile retval = null;
        if (project != null && !CoreUtil.isNullOrEmpty(filePath) && (webappRoot = CoreUtil.getDocroot(project)) != null && (file = webappRoot.getFile(filePath)) != null && file.exists()) {
            retval = file.getUnderlyingFile();
        }
        return retval;
    }

    public static IFolder getFirstSrcFolder(IProject project) {
        IPackageFragmentRoot[] sourceFolders = J2EEProjectUtilities.getSourceContainers((IProject)project);
        if (sourceFolders != null && sourceFolders.length > 0) {
            IResource resource = sourceFolders[0].getResource();
            return resource instanceof IFolder ? (IFolder)resource : null;
        }
        return null;
    }

    public static IFolder getFirstSrcFolder(String projectName) {
        IProject project = CoreUtil.getProject(projectName);
        return CoreUtil.getFirstSrcFolder(project);
    }

    public static Object getNewObject(Object[] oldObjects, Object[] newObjects) {
        if (oldObjects != null && newObjects != null && oldObjects.length < newObjects.length) {
            int i = 0;
            while (i < newObjects.length) {
                boolean found = false;
                Object object = newObjects[i];
                int j = 0;
                while (j < oldObjects.length) {
                    if (oldObjects[j] == object) {
                        found = true;
                        break;
                    }
                    ++j;
                }
                if (!found) {
                    return object;
                }
                ++i;
            }
        }
        if (oldObjects == null && newObjects != null && newObjects.length == 1) {
            return newObjects[0];
        }
        return null;
    }

    public static IProject getProject(String projectName) {
        return CoreUtil.getWorkspaceRoot().getProject(projectName);
    }

    public static IPath getResourceLocation(IResource resource) {
        IPath retval = null;
        if (resource != null && (retval = resource.getLocation()) == null) {
            retval = resource.getRawLocation();
        }
        return retval;
    }

    public static IFolder[] getSrcFolders(IProject project) {
        ArrayList<IFolder> retval = new ArrayList<IFolder>();
        IPackageFragmentRoot[] sourceFolders = J2EEProjectUtilities.getSourceContainers((IProject)project);
        if (sourceFolders != null && sourceFolders.length > 0) {
            IPackageFragmentRoot[] iPackageFragmentRootArray = sourceFolders;
            int n = sourceFolders.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot sourceFolder = iPackageFragmentRootArray[n2];
                if (sourceFolder.getResource() instanceof IFolder) {
                    retval.add((IFolder)sourceFolder.getResource());
                }
                ++n2;
            }
        }
        return retval.toArray(new IFolder[retval.size()]);
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public static Object invoke(String methodName, Object object, Class<?>[] argTypes, Object[] args) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method method = object.getClass().getDeclaredMethod(methodName, argTypes);
        method.setAccessible(true);
        return method.invoke(object, args);
    }

    public static boolean isEqual(Object object1, Object object2) {
        return object1 != null && object2 != null && object1.equals(object2);
    }

    public static boolean isLiferayProject(IProject project) {
        boolean retval;
        block4: {
            retval = false;
            if (project == null) {
                return retval;
            }
            try {
                IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
                if (facetedProject == null) break block4;
                for (IProjectFacetVersion facet : facetedProject.getProjectFacets()) {
                    IProjectFacet projectFacet = facet.getProjectFacet();
                    if (!projectFacet.getId().startsWith("liferay")) continue;
                    retval = true;
                    break;
                }
            }
            catch (Exception exception) {}
        }
        return retval;
    }

    public static boolean isNullOrEmpty(List<?> list) {
        return list == null || list.size() == 0;
    }

    public static boolean isNullOrEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isNullOrEmpty(String val) {
        return val == null || val.equals("") || val.trim().equals("");
    }

    public static boolean isNumeric(String str) {
        try {
            Double.parseDouble(str);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    public static boolean isResourceInDocroot(IModuleResource resource) {
        IContainer[] iContainerArray;
        IVirtualFolder webappRoot;
        IFile file = (IFile)resource.getAdapter(IFile.class);
        if (file != null && (webappRoot = CoreUtil.getDocroot(file.getProject())) != null && (iContainerArray = webappRoot.getUnderlyingFolders()).length != 0) {
            IContainer container = iContainerArray[0];
            return container != null && container.exists() && container.getFullPath().isPrefixOf(file.getFullPath());
        }
        return false;
    }

    public static void makeFolders(IFolder folder) throws CoreException {
        if (folder == null) {
            return;
        }
        IContainer parent = folder.getParent();
        if (parent instanceof IFolder) {
            CoreUtil.makeFolders((IFolder)parent);
        }
        if (!folder.exists()) {
            folder.create(true, true, null);
        }
    }

    public static IProgressMonitor newSubMonitor(IProgressMonitor parent, int ticks) {
        return parent == null ? null : new SubProgressMonitor(parent, ticks);
    }

    public static void prepareFolder(IFolder folder) throws CoreException {
        IContainer parent = folder.getParent();
        if (parent instanceof IFolder) {
            CoreUtil.prepareFolder((IFolder)parent);
        }
        if (!folder.exists()) {
            folder.create(1, true, null);
        }
    }

    public static String readPropertyFileValue(File propertiesFile, String key) throws FileNotFoundException, IOException {
        Properties props = new Properties();
        props.load(new FileInputStream(propertiesFile));
        return props.getProperty(key);
    }

    public static String readStreamToString(InputStream contents) throws IOException {
        return CoreUtil.readStreamToString(contents, true);
    }

    public static String readStreamToString(InputStream contents, boolean closeStream) throws IOException {
        int read;
        if (contents == null) {
            return null;
        }
        char[] buffer = new char[65536];
        StringBuilder out = new StringBuilder();
        InputStreamReader in = new InputStreamReader(contents, "UTF-8");
        do {
            if ((read = ((Reader)in).read(buffer, 0, buffer.length)) <= 0) continue;
            out.append(buffer, 0, read);
        } while (read >= 0);
        if (closeStream) {
            contents.close();
        }
        return out.toString();
    }

    public static Version readVersionFile(File versionInfoFile) {
        String versionContents = FileUtil.readContents(versionInfoFile);
        if (CoreUtil.isNullOrEmpty(versionContents)) {
            return Version.emptyVersion;
        }
        Version version = null;
        try {
            version = Version.parseVersion((String)versionContents.trim());
        }
        catch (NumberFormatException numberFormatException) {
            version = Version.emptyVersion;
        }
        return version;
    }

    public static void removeChildren(Node node) {
        if (node != null) {
            while (node.hasChildNodes()) {
                node.removeChild(node.getFirstChild());
            }
        }
    }

    public static void validateFolder(IFolder folder, IProgressMonitor monitor) {
        try {
            HashMap projects = new HashMap();
            final HashSet resources = new HashSet();
            folder.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    if (resource instanceof IFile || resource instanceof IFile) {
                        resources.add(resource);
                    }
                    return true;
                }
            });
            projects.put(folder.getProject(), resources);
            ValidationRunner.validate(projects, (ValType)ValType.Manual, (IProgressMonitor)monitor, (boolean)false);
        }
        catch (CoreException e) {
            LiferayCore.logError("Error while validating folder: " + folder.getFullPath(), e);
        }
    }

    public static void writeStreamFromString(String contents, OutputStream outputStream) throws IOException {
        int read;
        if (contents == null) {
            return;
        }
        char[] buffer = new char[65536];
        InputStreamReader in = new InputStreamReader(new ByteArrayInputStream(contents.getBytes("UTF-8")));
        OutputStreamWriter out = new OutputStreamWriter(outputStream, "UTF-8");
        do {
            if ((read = ((Reader)in).read(buffer, 0, buffer.length)) <= 0) continue;
            ((Writer)out).write(buffer, 0, read);
        } while (read >= 0);
        ((Reader)in).close();
        ((Writer)out).flush();
        ((Writer)out).close();
    }

    public static boolean isFileInLiferayProject(IFile file) {
        return false;
    }
}

