/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.core.util;

import com.liferay.ide.core.util.RuntimeClasspathModel;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.internal.launching.RuntimeClasspathEntry;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;

public class LaunchHelper
implements IDebugEventSetListener {
    protected String[] launchArgs = new String[0];
    protected boolean launchCaptureInConsole = true;
    protected String launchConfigTypeId;
    protected boolean launchInBackground = true;
    protected boolean launchIsPrivate = true;
    protected boolean launchSync = true;
    protected String mainClass;
    protected String mode = "run";
    protected ILaunch runningLaunch;

    public LaunchHelper() {
    }

    public LaunchHelper(String launchConfigTypeId) {
        this.launchConfigTypeId = launchConfigTypeId;
    }

    public ILaunchConfigurationWorkingCopy createLaunchConfiguration() throws CoreException {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType(this.launchConfigTypeId);
        String name = DebugPlugin.getDefault().getLaunchManager().generateLaunchConfigurationName(this.getNewLaunchConfigurationName());
        ILaunchConfigurationWorkingCopy launchConfig = type.newInstance(null, name);
        launchConfig.setAttribute("org.eclipse.debug.ui.ATTR_LAUNCH_IN_BACKGROUND", this.isLaunchInBackground());
        launchConfig.setAttribute("org.eclipse.debug.ui.ATTR_CAPTURE_IN_CONSOLE", this.isLaunchCaptureInConsole());
        launchConfig.setAttribute("org.eclipse.debug.ui.ATTR_PRIVATE", this.isLaunchIsPrivate());
        IRuntimeClasspathEntry[] classpath = this.getClasspath(launchConfig);
        ArrayList<String> mementos = new ArrayList<String>(classpath.length);
        int i = 0;
        while (i < classpath.length) {
            IRuntimeClasspathEntry entry = classpath[i];
            mementos.add(entry.getMemento());
            ++i;
        }
        launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, false);
        launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, mementos);
        if (this.mainClass != null) {
            launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, this.mainClass);
        }
        if (this.launchArgs != null && this.launchArgs.length > 0) {
            StringBuilder sb = new StringBuilder();
            int i2 = 0;
            while (i2 < this.launchArgs.length) {
                sb.append("\"" + this.launchArgs[i2] + "\" ");
                ++i2;
            }
            launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, sb.toString());
        }
        return launchConfig;
    }

    public String[] getLaunchArgs() {
        return this.launchArgs;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public String getMode() {
        return this.mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleDebugEvents(DebugEvent[] events) {
        DebugEvent[] debugEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            DebugEvent event = debugEventArray[n2];
            if (event.getSource() instanceof IProcess && ((IProcess)event.getSource()).getLaunch().equals(this.runningLaunch) && event.getKind() == 8) {
                LaunchHelper launchHelper = this;
                synchronized (launchHelper) {
                    DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                }
            }
            ++n2;
        }
    }

    public boolean isLaunchCaptureInConsole() {
        return this.launchCaptureInConsole;
    }

    public boolean isLaunchInBackground() {
        return this.launchInBackground;
    }

    public boolean isLaunchIsPrivate() {
        return this.launchIsPrivate;
    }

    public boolean isLaunchRunning() {
        return this.runningLaunch != null && !this.runningLaunch.isTerminated() && !this.runningLaunch.getProcesses()[0].isTerminated();
    }

    public boolean isLaunchSync() {
        return this.launchSync;
    }

    public void launch(ILaunchConfiguration config, String mode, IProgressMonitor monitor) throws CoreException {
        if (config == null) {
            throw new IllegalArgumentException("Launch config cannot be null");
        }
        if (this.isLaunchSync()) {
            DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
        }
        ILaunch launch = config.launch(mode, (IProgressMonitor)new NullProgressMonitor());
        if (this.isLaunchSync()) {
            this.runningLaunch = launch;
            try {
                try {
                    while (this.isLaunchRunning()) {
                        if (monitor != null && monitor.isCanceled() && !launch.isTerminated()) {
                            launch.getProcesses()[0].terminate();
                            launch.terminate();
                            continue;
                        }
                        Thread.sleep(100L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    this.runningLaunch.terminate();
                    this.runningLaunch = null;
                }
            }
            finally {
                this.runningLaunch = null;
            }
        }
    }

    public void launch(IProgressMonitor monitor) throws CoreException {
        ILaunchConfigurationWorkingCopy config = this.createLaunchConfiguration();
        this.launch((ILaunchConfiguration)config, this.mode, monitor);
    }

    public void setLaunchArgs(String[] launchArgs) {
        this.launchArgs = launchArgs;
    }

    public void setLaunchCaptureInConsole(boolean launchCaptureInConsole) {
        this.launchCaptureInConsole = launchCaptureInConsole;
    }

    public void setLaunchInBackground(boolean launchInBackground) {
        this.launchInBackground = launchInBackground;
    }

    public void setLaunchIsPrivate(boolean launchIsPrivate) {
        this.launchIsPrivate = launchIsPrivate;
    }

    public void setLaunchSync(boolean sync) {
        this.launchSync = sync;
    }

    public void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    protected void addUserEntries(RuntimeClasspathModel model) throws CoreException {
    }

    protected IRuntimeClasspathEntry[] getClasspath(ILaunchConfigurationWorkingCopy config) throws CoreException {
        RuntimeClasspathModel model = new RuntimeClasspathModel(config);
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH_PROVIDER, this.getClasspathProviderAttributeValue());
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, true);
        IRuntimeClasspathEntry[] defaultEntries = JavaRuntime.computeUnresolvedRuntimeClasspath((ILaunchConfiguration)config);
        int i = 0;
        while (i < defaultEntries.length) {
            IRuntimeClasspathEntry entry = defaultEntries[i];
            switch (entry.getClasspathProperty()) {
                case 3: {
                    model.addEntry(1, entry);
                    break;
                }
            }
            ++i;
        }
        this.addUserEntries(model);
        return this.getClasspathEntries(model);
    }

    protected IRuntimeClasspathEntry[] getClasspathEntries(RuntimeClasspathModel model) {
        IClasspathEntry[] user = model.getEntries(1, model.getConfig());
        ArrayList<IRuntimeClasspathEntry> entries = new ArrayList<IRuntimeClasspathEntry>();
        int i = 0;
        while (i < user.length) {
            IClasspathEntry userEntry = user[i];
            IRuntimeClasspathEntry entry = null;
            if (userEntry instanceof IRuntimeClasspathEntry) {
                entry = (IRuntimeClasspathEntry)user[i];
            } else if (userEntry instanceof IClasspathEntry) {
                entry = new RuntimeClasspathEntry(userEntry);
            }
            if (entry != null) {
                entry.setClasspathProperty(3);
                entries.add(entry);
            }
            ++i;
        }
        return entries.toArray(new IRuntimeClasspathEntry[entries.size()]);
    }

    protected String getClasspathProviderAttributeValue() {
        return null;
    }

    protected IVMInstall getDefaultVMInstall(ILaunchConfiguration config) {
        IVMInstall defaultVMInstall;
        try {
            defaultVMInstall = JavaRuntime.computeVMInstall((ILaunchConfiguration)config);
        }
        catch (CoreException coreException) {
            defaultVMInstall = JavaRuntime.getDefaultVMInstall();
        }
        return defaultVMInstall;
    }

    protected String getNewLaunchConfigurationName() {
        return this.getClass().getName();
    }
}

