/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal.listeners;

import org.eclipse.jpt.common.ui.internal.plugin.JptCommonUiPlugin;
import org.eclipse.jpt.common.ui.internal.swt.widgets.DisplayTools;
import org.eclipse.jpt.common.utility.internal.RunnableAdapter;
import org.eclipse.jpt.common.utility.internal.collection.SynchronizedQueue;
import org.eclipse.jpt.common.utility.model.event.CollectionAddEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionChangeEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionClearEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionRemoveEvent;
import org.eclipse.jpt.common.utility.model.listener.CollectionChangeListener;

public class SWTCollectionChangeListenerWrapper
implements CollectionChangeListener {
    private final CollectionChangeListener listener;
    private final SynchronizedQueue<CollectionEvent> events = new SynchronizedQueue();

    public SWTCollectionChangeListenerWrapper(CollectionChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.listener = listener;
    }

    public void itemsAdded(CollectionAddEvent event) {
        this.events.enqueue((Object)event);
        this.execute((Runnable)((Object)new ForwardEventsRunnable()));
    }

    public void itemsRemoved(CollectionRemoveEvent event) {
        this.events.enqueue((Object)event);
        this.execute((Runnable)((Object)new ForwardEventsRunnable()));
    }

    public void collectionCleared(CollectionClearEvent event) {
        this.events.enqueue((Object)event);
        this.execute((Runnable)((Object)new ForwardEventsRunnable()));
    }

    public void collectionChanged(CollectionChangeEvent event) {
        this.events.enqueue((Object)event);
        this.execute((Runnable)((Object)new ForwardEventsRunnable()));
    }

    void forwardEvents() {
        for (CollectionEvent event : this.events.drain()) {
            try {
                this.forwardEvent(event);
            }
            catch (RuntimeException ex) {
                JptCommonUiPlugin.instance().logError(ex);
            }
        }
    }

    private void forwardEvent(CollectionEvent event) {
        if (event instanceof CollectionAddEvent) {
            this.listener.itemsAdded((CollectionAddEvent)event);
        } else if (event instanceof CollectionRemoveEvent) {
            this.listener.itemsRemoved((CollectionRemoveEvent)event);
        } else if (event instanceof CollectionClearEvent) {
            this.listener.collectionCleared((CollectionClearEvent)event);
        } else if (event instanceof CollectionChangeEvent) {
            this.listener.collectionChanged((CollectionChangeEvent)event);
        }
    }

    private void execute(Runnable r) {
        DisplayTools.execute(r);
    }

    public String toString() {
        return "SWT(" + this.listener + ')';
    }

    class ForwardEventsRunnable
    extends RunnableAdapter {
        ForwardEventsRunnable() {
        }

        public void run() {
            SWTCollectionChangeListenerWrapper.this.forwardEvents();
        }
    }
}

