/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.components;

import java.beans.Beans;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.m2e.core.ui.internal.MavenImages;
import org.eclipse.m2e.core.ui.internal.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NestedProjectsComposite
extends Composite
implements IMenuListener {
    private static final Logger log = LoggerFactory.getLogger(NestedProjectsComposite.class);
    private static final String SEPARATOR = System.getProperty("file.separator");
    CheckboxTreeViewer codebaseViewer;
    Map<String, IProject> projectPaths;
    Collection<IProject> projects;
    IProject[] selectedProjects;
    private Link includeOutDateProjectslink;
    private Composite warningArea;
    private Button addOutOfDateBtn;
    private final Action selectTree = new Action(Messages.UpdateDepenciesDialog_selectTree){

        public void run() {
            NestedProjectsComposite.this.codebaseViewer.setSubtreeChecked((Object)NestedProjectsComposite.this.getSelection(), true);
            NestedProjectsComposite.this.updateSelectedProjects();
        }
    };
    private final Action deselectTree = new Action(Messages.UpdateDepenciesDialog_deselectTree){

        public void run() {
            NestedProjectsComposite.this.codebaseViewer.setSubtreeChecked((Object)NestedProjectsComposite.this.getSelection(), false);
            NestedProjectsComposite.this.updateSelectedProjects();
        }
    };

    public NestedProjectsComposite(Composite parent, int style, IProject[] initialSelection) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(2, false));
        Label lblAvailable = new Label((Composite)this, 0);
        lblAvailable.setText(Messages.UpdateDepenciesDialog_availableCodebasesLabel);
        lblAvailable.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 2, 1));
        this.codebaseViewer = new CheckboxTreeViewer((Composite)this, 2048);
        this.codebaseViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object element) {
                if (element instanceof Collection) {
                    return ((Collection)element).toArray();
                }
                return null;
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof IProject) {
                    String elePath = NestedProjectsComposite.this.getElePath(parentElement);
                    String prevPath = null;
                    ArrayList<IProject> children = new ArrayList<IProject>();
                    for (String path : NestedProjectsComposite.this.projectPaths.keySet()) {
                        if (path.length() == elePath.length() || !path.startsWith(elePath) || prevPath != null && path.startsWith(prevPath)) continue;
                        prevPath = path;
                        children.add(NestedProjectsComposite.this.getProject(path));
                    }
                    return children.toArray();
                }
                if (parentElement instanceof Collection) {
                    return ((Collection)parentElement).toArray();
                }
                return null;
            }

            public Object getParent(Object element) {
                String elePath = NestedProjectsComposite.this.getElePath(element);
                String prevPath = null;
                for (String path : NestedProjectsComposite.this.projectPaths.keySet()) {
                    if (elePath.length() == path.length() || !elePath.startsWith(path) || prevPath != null && prevPath.length() >= path.length()) continue;
                    prevPath = path;
                }
                return prevPath == null ? NestedProjectsComposite.this.projects : NestedProjectsComposite.this.getProject(prevPath);
            }

            public boolean hasChildren(Object element) {
                if (element instanceof IProject) {
                    String elePath = NestedProjectsComposite.this.getElePath(element);
                    for (String path : NestedProjectsComposite.this.projectPaths.keySet()) {
                        if (elePath.length() == path.length() || !path.startsWith(elePath)) continue;
                        return true;
                    }
                } else if (element instanceof Collection) {
                    return !((Collection)element).isEmpty();
                }
                return false;
            }
        });
        this.codebaseViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                if (Beans.isDesignTime()) {
                    return null;
                }
                ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
                if (element instanceof IProject && !((IProject)element).isAccessible()) {
                    return sharedImages.getImage("IMG_OBJ_PROJECT_CLOSED");
                }
                Image img = MavenImages.createOverlayImage("project-mlabel.gif", sharedImages.getImage("IMG_OBJ_PROJECT"), MavenImages.MAVEN_OVERLAY, 0);
                if (NestedProjectsComposite.this.requiresUpdate((IProject)element)) {
                    img = MavenImages.createOverlayImage("out_of_date_project", img, MavenImages.OUT_OF_DATE_OVERLAY, 3);
                }
                return img;
            }

            public String getText(Object element) {
                return element instanceof IProject ? ((IProject)element).getName() : "";
            }
        });
        this.projects = this.getMavenCodebases();
        this.codebaseViewer.setInput(this.projects);
        this.codebaseViewer.expandAll();
        if (initialSelection != null) {
            IProject[] iProjectArray = initialSelection;
            int n = initialSelection.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                this.codebaseViewer.setSubtreeChecked((Object)project, true);
                ++n2;
            }
            if (initialSelection.length > 0) {
                this.codebaseViewer.reveal((Object)initialSelection[0]);
            }
        }
        Tree tree = this.codebaseViewer.getTree();
        GridData gd = new GridData(4, 4, true, true, 1, 1);
        gd.heightHint = 300;
        gd.widthHint = 300;
        tree.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout(2, false);
        layout.marginLeft = 10;
        Composite selectionActionComposite = new Composite((Composite)this, 0);
        selectionActionComposite.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        GridLayout gl_selectionActionComposite = new GridLayout(1, false);
        gl_selectionActionComposite.marginWidth = 0;
        gl_selectionActionComposite.marginHeight = 0;
        selectionActionComposite.setLayout((Layout)gl_selectionActionComposite);
        this.createButtons(selectionActionComposite);
        this.createOutOfDateProjectsWarning(parent);
        this.createMenu();
        this.codebaseViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                NestedProjectsComposite.this.updateSelectedProjects();
            }
        });
        this.updateSelectedProjects();
    }

    private void createOutOfDateProjectsWarning(Composite composite) {
        this.warningArea = new Composite(composite, 0);
        this.warningArea.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 2, 1));
        this.warningArea.setLayout((Layout)new RowLayout(256));
        Label warningImg = new Label(this.warningArea, 0);
        warningImg.setImage(JFaceResources.getImage((String)"dialog_messasge_warning_image"));
        this.includeOutDateProjectslink = new Link(this.warningArea, 0);
        this.includeOutDateProjectslink.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                NestedProjectsComposite.this.includeOutOfDateProjects();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                NestedProjectsComposite.this.includeOutOfDateProjects();
            }
        });
    }

    private void updateIncludeOutDateProjectsLink(int outOfDateProjectsCount) {
        String btnTooltip;
        boolean visibility = true;
        String text = "";
        if (outOfDateProjectsCount == 0) {
            visibility = false;
            btnTooltip = Messages.NestedProjectsComposite_OutOfDateProjectBtn_Generic_Tooltip;
        } else if (outOfDateProjectsCount > 1) {
            text = NLS.bind((String)Messages.NestedProjectsComposite_Multiple_OOD_Projects_Link, (Object)outOfDateProjectsCount);
            btnTooltip = NLS.bind((String)Messages.NestedProjectsComposite_OutOfDateProjectBtn_AddProjects_Tooltip, (Object)outOfDateProjectsCount);
        } else {
            text = Messages.NestedProjectsComposite_Single_OOD_Project_Link;
            btnTooltip = Messages.NestedProjectsComposite_OutOfDateProjectBtn_AddOneProject_Tooltip;
        }
        this.includeOutDateProjectslink.setText(text);
        this.addOutOfDateBtn.setToolTipText(btnTooltip);
        this.warningArea.setVisible(visibility);
        this.warningArea.getParent().layout(new Control[]{this.warningArea});
    }

    private int computeOutOfDateProjectsCount() {
        int outOfDateProjectsCount = 0;
        for (IProject p : this.projectPaths.values()) {
            if (!this.requiresUpdate(p) || this.codebaseViewer.getChecked((Object)p)) continue;
            ++outOfDateProjectsCount;
        }
        return outOfDateProjectsCount;
    }

    private void includeOutOfDateProjects() {
        for (IProject project : this.projectPaths.values()) {
            if (!this.requiresUpdate(project)) continue;
            this.codebaseViewer.setChecked((Object)project, true);
        }
        this.updateSelectedProjects();
    }

    private void updateSelectedProjects() {
        this.selectedProjects = this.internalGetSelectedProjects();
        this.updateIncludeOutDateProjectsLink(this.computeOutOfDateProjectsCount());
    }

    protected void createButtons(Composite selectionActionComposite) {
        Button selectAllBtn = new Button(selectionActionComposite, 0);
        selectAllBtn.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        selectAllBtn.setText(Messages.UpdateDepenciesDialog_selectAll);
        selectAllBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (IProject project : NestedProjectsComposite.this.projects) {
                    NestedProjectsComposite.this.codebaseViewer.setSubtreeChecked((Object)project, true);
                }
                NestedProjectsComposite.this.updateSelectedProjects();
            }
        });
        this.addOutOfDateBtn = new Button(selectionActionComposite, 0);
        this.addOutOfDateBtn.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.addOutOfDateBtn.setText(Messages.NestedProjectsComposite_Add_OutOfDate);
        this.addOutOfDateBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NestedProjectsComposite.this.includeOutOfDateProjects();
            }
        });
        Button deselectAllBtn = new Button(selectionActionComposite, 0);
        deselectAllBtn.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        deselectAllBtn.setText(Messages.UpdateDepenciesDialog_deselectAll);
        deselectAllBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (IProject project : NestedProjectsComposite.this.projects) {
                    NestedProjectsComposite.this.codebaseViewer.setSubtreeChecked((Object)project, false);
                }
                NestedProjectsComposite.this.updateSelectedProjects();
            }
        });
        Button expandAllBtn = new Button(selectionActionComposite, 0);
        expandAllBtn.setLayoutData((Object)new GridData(4, 1024, false, false, 1, 1));
        expandAllBtn.setText(Messages.UpdateDepenciesDialog_expandAll);
        expandAllBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NestedProjectsComposite.this.codebaseViewer.expandAll();
            }
        });
        Button collapseAllBtn = new Button(selectionActionComposite, 0);
        collapseAllBtn.setLayoutData((Object)new GridData(4, 1024, false, false, 1, 1));
        collapseAllBtn.setText(Messages.UpdateDepenciesDialog_collapseAll);
        collapseAllBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NestedProjectsComposite.this.codebaseViewer.collapseAll();
            }
        });
    }

    String getElePath(Object element) {
        if (element instanceof IProject) {
            IProject project = (IProject)element;
            URI locationURI = project.getLocationURI();
            try {
                IFileStore store = EFS.getStore((URI)locationURI);
                File file = store.toLocalFile(0, null);
                return String.valueOf(file.toString()) + SEPARATOR;
            }
            catch (CoreException ex) {
                log.error(ex.getMessage(), (Throwable)ex);
            }
        }
        return null;
    }

    IProject getProject(String path) {
        return this.projectPaths.get(path);
    }

    private Collection<IProject> getMavenCodebases() {
        this.projectPaths = new TreeMap<String, IProject>();
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            try {
                String path;
                if (this.isInteresting(project) && project.getLocationURI() != null && (path = this.getElePath(project)) != null) {
                    this.projectPaths.put(path, project);
                }
            }
            catch (CoreException ex) {
                log.error(ex.getMessage(), (Throwable)ex);
            }
            ++n2;
        }
        if (this.projectPaths.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IProject> projects = new ArrayList<IProject>();
        String previous = this.projectPaths.keySet().iterator().next();
        NestedProjectsComposite.addProject(projects, previous);
        for (String path : this.projectPaths.keySet()) {
            if (path.startsWith(previous)) continue;
            previous = path;
            IProject project = this.getProject(path);
            if (project == null) continue;
            projects.add(project);
        }
        return projects;
    }

    protected boolean isInteresting(IProject project) throws CoreException {
        return project.isAccessible() && project.hasNature("org.eclipse.m2e.core.maven2Nature");
    }

    private static void addProject(Collection<IProject> projects, String location) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IContainer[] iContainerArray = root.findContainersForLocationURI(new File(location).toURI());
        int n = iContainerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IContainer container = iContainerArray[n2];
            if (container instanceof IProject) {
                projects.add((IProject)container);
                break;
            }
            ++n2;
        }
    }

    private void createMenu() {
        MenuManager menuMgr = new MenuManager();
        Menu contextMenu = menuMgr.createContextMenu(this.codebaseViewer.getControl());
        menuMgr.addMenuListener((IMenuListener)this);
        this.codebaseViewer.getControl().setMenu(contextMenu);
        menuMgr.setRemoveAllWhenShown(true);
    }

    public void menuAboutToShow(IMenuManager manager) {
        if (this.codebaseViewer.getSelection().isEmpty()) {
            return;
        }
        if (this.codebaseViewer.getSelection() instanceof IStructuredSelection) {
            manager.add((IAction)this.selectTree);
            manager.add((IAction)this.deselectTree);
        }
    }

    public IProject getSelection() {
        ISelection selection = this.codebaseViewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            return (IProject)((IStructuredSelection)selection).getFirstElement();
        }
        return null;
    }

    public IProject[] getSelectedProjects() {
        return this.selectedProjects;
    }

    IProject[] internalGetSelectedProjects() {
        Object[] obj = this.codebaseViewer.getCheckedElements();
        IProject[] projects = new IProject[obj.length];
        int i = 0;
        while (i < obj.length) {
            projects[i] = (IProject)obj[i];
            ++i;
        }
        return projects;
    }

    public void refresh() {
        this.projects = this.getMavenCodebases();
        this.codebaseViewer.setInput(this.projects);
        this.codebaseViewer.expandAll();
    }

    public void reset() {
        this.projects = this.getMavenCodebases();
        this.codebaseViewer.setInput(this.projects);
        this.codebaseViewer.expandAll();
        for (IProject project : this.projects) {
            this.codebaseViewer.setSubtreeChecked((Object)project, false);
        }
        this.updateSelectedProjects();
    }

    public void addSelectionChangeListener(ISelectionChangedListener listener) {
        this.codebaseViewer.addSelectionChangedListener(listener);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean requiresUpdate(IProject project) {
        try {
            IMarker[] markers;
            IMarker[] iMarkerArray = markers = project.findMarkers("org.eclipse.m2e.core.maven2Problem.configuration", true, 0);
            int n = markers.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IMarker marker = iMarkerArray[n2];
                String message = (String)marker.getAttribute("message");
                if (org.eclipse.m2e.core.internal.Messages.ProjectConfigurationUpdateRequired.equals(message)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (CoreException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
        return false;
    }
}

