/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.alloy.ui.action;

import com.liferay.ide.alloy.core.AlloyCore;
import com.liferay.ide.alloy.core.LautRunner;
import com.liferay.ide.ui.action.AbstractObjectAction;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.PlatformUI;

public class UpgradeToolAction
extends AbstractObjectAction {
    public void run(IAction action) {
        if (this.fSelection instanceof IStructuredSelection) {
            Object[] elems = ((IStructuredSelection)this.fSelection).toArray();
            Object elem = elems[0];
            IProject project = null;
            if (elem instanceof IFile) {
                IFile projectFile = (IFile)elem;
                project = projectFile.getProject();
            } else if (elem instanceof IProject) {
                project = (IProject)elem;
            }
            if (project != null) {
                this.runLaut(project);
            }
        }
    }

    private void runLaut(final IProject project) {
        final LautRunner lautRunner = AlloyCore.getLautRunner();
        if (lautRunner != null) {
            lautRunner.hasUpdateAvailable();
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    lautRunner.exec(project, monitor);
                }
            };
            try {
                PlatformUI.getWorkbench().getProgressService().run(true, false, runnable);
            }
            catch (Exception e) {
                AlloyCore.logError((String)"Unable to execute laut tool", (Exception)e);
            }
        }
    }
}

