/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivyde.common.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.ivyde.common.model.IDocumentedValueProvider;
import org.apache.ivyde.common.model.IValueProvider;
import org.apache.ivyde.common.model.IvyFile;
import org.apache.ivyde.common.model.IvyTagAttribute;
import org.apache.ivyde.common.model.Proposal;

public class IvyTag {
    private static final ResourceBundle DOC_RESOURCE;
    private IvyTag parent;
    private String name;
    private String doc;
    private Map attributes = new HashMap();
    private List childs = new ArrayList();
    private boolean allowNoChild = true;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.ivyde.common.model.IvyTag");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        DOC_RESOURCE = ResourceBundle.getBundle(String.valueOf(clazz.getPackage().getName()) + ".tagsdoc");
    }

    public IvyTag(String name) {
        this.name = name;
    }

    public IvyTag(String name, IvyTagAttribute[] atts) {
        this.name = name;
        int i = 0;
        while (i < atts.length) {
            this.addAttribute(atts[i]);
            ++i;
        }
    }

    public IvyTag(String name, String doc) {
        this.name = name;
        this.doc = doc;
    }

    public IvyTag(String name, String doc, IvyTagAttribute[] atts) {
        this.name = name;
        this.doc = doc;
        int i = 0;
        while (i < atts.length) {
            this.addAttribute(atts[i]);
            ++i;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addAttribute(IvyTagAttribute attribute) {
        attribute.setContainer(this);
        this.attributes.put(attribute.getName(), attribute);
    }

    public IvyTag addChildIvyTag(IvyTag att) {
        att.setParent(this);
        this.childs.add(att);
        return this;
    }

    public boolean hasChild() {
        return this.childs.size() > 0;
    }

    public List getAttributes() {
        return new ArrayList(this.attributes.values());
    }

    public List getChilds() {
        return this.childs;
    }

    public String getEndTag() {
        if (this.getChilds().size() > 0) {
            return "</" + this.getName() + ">";
        }
        return "/>";
    }

    public String getStartTag() {
        return "<" + this.getName() + (this.getChilds().size() > 0 ? ">" : "");
    }

    public String getDoc() {
        if (this.doc == null) {
            try {
                this.doc = DOC_RESOURCE.getString(this.getId());
            }
            catch (MissingResourceException missingResourceException) {
                this.doc = "";
            }
        }
        return this.doc;
    }

    public String getId() {
        if (this.getParent() != null) {
            return String.valueOf(this.getParent().getId()) + "." + this.getName();
        }
        return this.getName();
    }

    public void setDoc(String doc) {
        this.doc = doc;
    }

    public IvyTag getParent() {
        return this.parent;
    }

    void setParent(IvyTag parent) {
        this.parent = parent;
    }

    public String toString() {
        return this.name;
    }

    public String[] getPossibleValuesForAttribute(String att, IvyFile ivyfile) {
        IvyTagAttribute ivyTagAttribute = (IvyTagAttribute)this.attributes.get(att);
        if (ivyTagAttribute == null) {
            return null;
        }
        IValueProvider provider = ivyTagAttribute.getValueProvider();
        if (provider != null) {
            String qualifier = ivyfile.getAttributeValueQualifier();
            String[] values = provider.getValuesfor(ivyTagAttribute, ivyfile);
            if (values != null) {
                HashSet<String> ret = new HashSet<String>(values.length);
                int i = 0;
                while (i < values.length) {
                    if (values[i].startsWith(qualifier)) {
                        ret.add(values[i]);
                    }
                    ++i;
                }
                return ret.toArray(new String[ret.size()]);
            }
            return null;
        }
        System.out.println("No provider set for:" + att);
        return null;
    }

    public String getPossibleDocForValue(String value, IvyFile ivyfile) {
        IvyTagAttribute ivyTagAttribute = (IvyTagAttribute)this.attributes.get(ivyfile.getAttributeName());
        if (ivyTagAttribute == null) {
            return null;
        }
        IValueProvider provider = ivyTagAttribute.getValueProvider();
        if (provider != null && provider instanceof IDocumentedValueProvider) {
            String doc = ((IDocumentedValueProvider)provider).getDocForValue(value, ivyfile);
            return doc;
        }
        return null;
    }

    public boolean isAllowNoChild() {
        return this.allowNoChild;
    }

    public void setAllowNoChild(boolean allowNoChild) {
        this.allowNoChild = allowNoChild;
    }

    public Proposal[] getProposals() {
        ArrayList<Proposal> ret = new ArrayList<Proposal>();
        String text = String.valueOf(this.getStartTag()) + this.getEndTag();
        int cursor = this.getStartTag().length();
        ret.add(new Proposal(text, cursor, this.getDoc()));
        if (this.allowNoChild && this.getChilds().size() > 0) {
            ret.add(new Proposal("<" + this.getName() + " />", cursor, this.getDoc()));
        }
        return ret.toArray(new Proposal[ret.size()]);
    }
}

