/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivyde.internal.eclipse;

import java.util.ArrayList;
import org.apache.ivyde.internal.eclipse.IvyPlugin;
import org.apache.ivyde.internal.eclipse.cpcontainer.ClasspathEntriesResolver;
import org.apache.ivyde.internal.eclipse.cpcontainer.IvyClasspathContainerImpl;
import org.apache.ivyde.internal.eclipse.resolve.IvyResolveJob;
import org.apache.ivyde.internal.eclipse.resolve.ResolveRequest;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry2;
import org.eclipse.jdt.launching.IRuntimeClasspathEntryResolver;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;

public class IvyDERuntimeClasspathEntryResolver
implements IRuntimeClasspathEntryResolver {
    public IRuntimeClasspathEntry[] resolveRuntimeClasspathEntry(IRuntimeClasspathEntry entry, ILaunchConfiguration configuration) throws CoreException {
        if (entry == null) {
            return new IRuntimeClasspathEntry[0];
        }
        IJavaProject project = entry.getJavaProject();
        return this.computeDefaultContainerEntries(entry, project);
    }

    private IRuntimeClasspathEntry[] computeDefaultContainerEntries(IRuntimeClasspathEntry entry, IJavaProject project) throws JavaModelException, CoreException {
        IvyClasspathContainerImpl ivycp;
        if (project == null) {
            ivycp = new IvyClasspathContainerImpl(null, entry.getPath(), null, null);
        } else {
            IClasspathContainer container = JavaCore.getClasspathContainer((IPath)entry.getPath(), (IJavaProject)project);
            if (container == null) {
                String message = "Could not resolve classpath container: " + entry.getPath().toString();
                throw new CoreException((IStatus)new Status(4, "org.apache.ivyde.eclipse", 150, message, null));
            }
            ivycp = (IvyClasspathContainerImpl)container;
        }
        return IvyDERuntimeClasspathEntryResolver.computeDefaultContainerEntries(ivycp, entry);
    }

    private static IRuntimeClasspathEntry[] computeDefaultContainerEntries(IvyClasspathContainerImpl ivycp, IRuntimeClasspathEntry entry) throws CoreException {
        IClasspathEntry[] cpes;
        if (ivycp.getClasspathEntries() == null || ivycp.getConf().getInheritedAdvancedSetup().isResolveBeforeLaunch()) {
            ClasspathEntriesResolver resolver = new ClasspathEntriesResolver(ivycp, false);
            ResolveRequest request = new ResolveRequest(resolver, ivycp.getState());
            request.setForceFailOnError(true);
            request.setInWorkspace(ivycp.getConf().getInheritedClasspathSetup().isResolveInWorkspace());
            request.setTransitive(ivycp.getConf().getInheritedClasspathSetup().isTransitiveResolve());
            IvyResolveJob resolveJob = IvyPlugin.getDefault().getIvyResolveJob();
            IStatus status = resolveJob.launchRequest(request, (IProgressMonitor)new NullProgressMonitor());
            if (status.getCode() != 0) {
                throw new CoreException(status);
            }
            cpes = resolver.getClasspathEntries();
        } else {
            cpes = ivycp.getClasspathEntries();
        }
        ArrayList<IRuntimeClasspathEntry> resolved = new ArrayList<IRuntimeClasspathEntry>(cpes.length);
        ArrayList<IJavaProject> projects = new ArrayList<IJavaProject>();
        int i = 0;
        while (i < cpes.length) {
            IRuntimeClasspathEntry e;
            IClasspathEntry cpe = cpes[i];
            if (cpe.getEntryKind() == 2) {
                IProject p = ResourcesPlugin.getWorkspace().getRoot().getProject(cpe.getPath().segment(0));
                IJavaProject jp = JavaCore.create((IProject)p);
                if (!projects.contains(jp)) {
                    projects.add(jp);
                    IRuntimeClasspathEntry classpath = JavaRuntime.newProjectRuntimeClasspathEntry((IJavaProject)jp);
                    resolved.add(classpath);
                    IRuntimeClasspathEntry[] entries = JavaRuntime.resolveRuntimeClasspathEntry((IRuntimeClasspathEntry)classpath, (IJavaProject)jp);
                    int j = 0;
                    while (j < entries.length) {
                        IRuntimeClasspathEntry e2 = entries[j];
                        if (!resolved.contains(e2)) {
                            resolved.add(entries[j]);
                        }
                        ++j;
                    }
                }
            } else if (cpe.getEntryKind() == 1 && !resolved.contains(e = JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)cpe.getPath()))) {
                resolved.add(e);
            }
            ++i;
        }
        IRuntimeClasspathEntry[] result = new IRuntimeClasspathEntry[resolved.size()];
        int i2 = 0;
        while (i2 < result.length) {
            result[i2] = (IRuntimeClasspathEntry)resolved.get(i2);
            result[i2].setClasspathProperty(3);
            ++i2;
        }
        return result;
    }

    public IRuntimeClasspathEntry[] resolveRuntimeClasspathEntry(IRuntimeClasspathEntry entry, IJavaProject project) throws CoreException {
        if (!(entry instanceof IRuntimeClasspathEntry2)) {
            if (entry.getType() == 4) {
                return this.computeDefaultContainerEntries(entry, project);
            }
            return new IRuntimeClasspathEntry[]{entry};
        }
        IRuntimeClasspathEntry2 entry2 = (IRuntimeClasspathEntry2)entry;
        IRuntimeClasspathEntry[] entries = entry2.getRuntimeClasspathEntries(null);
        ArrayList<IRuntimeClasspathEntry> resolved = new ArrayList<IRuntimeClasspathEntry>();
        int i = 0;
        while (i < entries.length) {
            IRuntimeClasspathEntry[] temp = JavaRuntime.resolveRuntimeClasspathEntry((IRuntimeClasspathEntry)entries[i], (IJavaProject)project);
            int j = 0;
            while (j < temp.length) {
                resolved.add(temp[j]);
                ++j;
            }
            ++i;
        }
        return resolved.toArray(new IRuntimeClasspathEntry[resolved.size()]);
    }

    public IVMInstall resolveVMInstall(IClasspathEntry entry) throws CoreException {
        return null;
    }
}

