/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivyde.internal.eclipse.handlers;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ivyde.eclipse.cp.IvyClasspathContainerHelper;
import org.apache.ivyde.internal.eclipse.cpcontainer.IvyClasspathContainerImpl;
import org.apache.ivyde.internal.eclipse.cpcontainer.IvyClasspathUtil;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.ui.packageview.ClassPathContainer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class AbstractIvyDEHandler
extends AbstractHandler {
    static /* synthetic */ Class class$0;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        Map projects = AbstractIvyDEHandler.getProjectAndContainers((IStructuredSelection)selection);
        if (projects.size() > 0) {
            this.handleProjects(projects);
        }
        return null;
    }

    public static Map getProjectAndContainers(IStructuredSelection selection) {
        HashMap<IProject, HashSet<IvyClasspathContainerImpl>> projects = new HashMap<IProject, HashSet<IvyClasspathContainerImpl>>();
        Iterator it = selection.iterator();
        while (it.hasNext()) {
            Object element = it.next();
            if (element instanceof IWorkingSet) {
                IAdaptable[] elements = ((IWorkingSet)element).getElements();
                int i = 0;
                while (i < elements.length) {
                    AbstractIvyDEHandler.addElement(projects, elements[i]);
                    ++i;
                }
                continue;
            }
            if (element instanceof ClassPathContainer) {
                IvyClasspathContainerImpl ivycp = IvyClasspathUtil.jdt2IvyCPC((ClassPathContainer)element);
                IJavaProject javaProject = ivycp.getConf().getJavaProject();
                if (javaProject == null) continue;
                HashSet<IvyClasspathContainerImpl> cplist = (HashSet<IvyClasspathContainerImpl>)projects.get(javaProject.getProject());
                if (cplist == null) {
                    cplist = new HashSet<IvyClasspathContainerImpl>();
                    projects.put(javaProject.getProject(), cplist);
                }
                cplist.add(ivycp);
                continue;
            }
            AbstractIvyDEHandler.addElement(projects, element);
        }
        return projects;
    }

    private static void addElement(Map projects, Object adaptableProject) {
        List containers;
        IProject project = null;
        if (adaptableProject instanceof IProject) {
            project = (IProject)adaptableProject;
        } else if (adaptableProject instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)adaptableProject;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IProject");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            project = (IProject)iAdaptable.getAdapter((Class)clazz);
        }
        if (project != null && !(containers = IvyClasspathContainerHelper.getContainers(project)).isEmpty()) {
            projects.put(project, new HashSet(containers));
        }
    }

    protected void handleProjects(Map projects) {
        Iterator it = projects.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Iterator itContainers = ((Set)entry.getValue()).iterator();
            while (itContainers.hasNext()) {
                this.handleContainer((IProject)entry.getKey(), (IvyClasspathContainerImpl)itContainers.next());
            }
        }
    }

    protected void handleContainer(IProject project, IvyClasspathContainerImpl cp) {
        throw new UnsupportedOperationException();
    }
}

