/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivyde.internal.eclipse.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;

public class ConfTableViewer
extends Composite {
    private CheckboxTableViewer confTableViewer;
    private final List listeners = new ArrayList();
    private Button selectAll;
    private Button up;
    private Button down;
    private Configuration[] orderedConfigurations = new Configuration[0];
    private Button all;
    private Button none;

    public ConfTableViewer(Composite parent, int style) {
        super(parent, style);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.selectAll = new Button((Composite)this, 32);
        this.selectAll.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.selectAll.setText("Select every configuration");
        this.selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = !ConfTableViewer.this.selectAll.getSelection();
                ConfTableViewer.this.confTableViewer.getTable().setEnabled(enabled);
                ConfTableViewer.this.updateAllNoneEnableButtons(enabled);
                ConfTableViewer.this.updateUpDownEnableButtons(enabled);
                ConfTableViewer.this.confTableUpdated();
            }
        });
        this.confTableViewer = CheckboxTableViewer.newCheckList((Composite)this, (int)2816);
        this.confTableViewer.getTable().setHeaderVisible(true);
        this.confTableViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        TableColumn col1 = new TableColumn(this.confTableViewer.getTable(), 0);
        col1.setText("Name");
        col1.setWidth(100);
        TableColumn col2 = new TableColumn(this.confTableViewer.getTable(), 0);
        col2.setText("Description");
        col2.setWidth(300);
        this.confTableViewer.setColumnProperties(new String[]{"Name", "Description"});
        this.confTableViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        this.confTableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.confTableViewer.setLabelProvider((IBaseLabelProvider)new ConfigurationLabelProvider());
        this.confTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ConfTableViewer.this.updateUpDownEnableButtons(true);
                ConfTableViewer.this.updateAllNoneEnableButtons(true);
                ConfTableViewer.this.confTableUpdated();
            }
        });
        Composite upDownButtons = new Composite((Composite)this, 0);
        upDownButtons.setLayoutData((Object)new GridData(4, 4, false, true));
        upDownButtons.setLayout((Layout)new GridLayout());
        this.all = new Button(upDownButtons, 8);
        this.all.setText("All");
        this.all.setLayoutData((Object)new GridData(4, 1, true, false));
        this.all.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfTableViewer.this.confTableViewer.setCheckedElements((Object[])ConfTableViewer.this.orderedConfigurations);
                ConfTableViewer.this.updateAllNoneEnableButtons(true);
            }
        });
        this.none = new Button(upDownButtons, 8);
        this.none.setText("None");
        this.none.setLayoutData((Object)new GridData(4, 1, true, false));
        this.none.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfTableViewer.this.confTableViewer.setCheckedElements((Object[])new Configuration[0]);
                ConfTableViewer.this.updateAllNoneEnableButtons(true);
            }
        });
        this.up = new Button(upDownButtons, 8);
        this.up.setText("Up");
        this.up.setLayoutData((Object)new GridData(4, 1, true, false));
        this.up.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int i = ConfTableViewer.this.getSelectedConfigurationIndex();
                Configuration c = ConfTableViewer.this.orderedConfigurations[i];
                ((ConfTableViewer)ConfTableViewer.this).orderedConfigurations[i] = ConfTableViewer.this.orderedConfigurations[i - 1];
                ((ConfTableViewer)ConfTableViewer.this).orderedConfigurations[i - 1] = c;
                ConfTableViewer.this.confTableViewer.refresh();
                ConfTableViewer.this.updateUpDownEnableButtons(true);
            }
        });
        this.down = new Button(upDownButtons, 8);
        this.down.setText("Down");
        this.down.setLayoutData((Object)new GridData(4, 1, true, false));
        this.down.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int i = ConfTableViewer.this.getSelectedConfigurationIndex();
                Configuration c = ConfTableViewer.this.orderedConfigurations[i];
                ((ConfTableViewer)ConfTableViewer.this).orderedConfigurations[i] = ConfTableViewer.this.orderedConfigurations[i + 1];
                ((ConfTableViewer)ConfTableViewer.this).orderedConfigurations[i + 1] = c;
                ConfTableViewer.this.confTableViewer.refresh();
                ConfTableViewer.this.updateUpDownEnableButtons(true);
            }
        });
    }

    private int getSelectedConfigurationIndex() {
        IStructuredSelection selection = (IStructuredSelection)this.confTableViewer.getSelection();
        Configuration c = (Configuration)selection.getFirstElement();
        int i = 0;
        while (i < this.orderedConfigurations.length) {
            if (this.orderedConfigurations[i] == c) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void updateUpDownEnableButtons(boolean enabled) {
        boolean selected = this.confTableViewer.getTable().getSelectionCount() != 0;
        int i = this.getSelectedConfigurationIndex();
        this.up.setEnabled(enabled && selected && i > 0);
        this.down.setEnabled(enabled && selected && i < this.orderedConfigurations.length - 1);
    }

    private void updateAllNoneEnableButtons(boolean enabled) {
        int nbChecked = this.confTableViewer.getCheckedElements().length;
        this.all.setEnabled(!this.selectAll.getSelection() && nbChecked != this.orderedConfigurations.length);
        this.none.setEnabled(!this.selectAll.getSelection() && nbChecked > 0);
    }

    public void setModuleDescriptor(ModuleDescriptor md) {
        this.orderedConfigurations = md == null ? new Configuration[0] : md.getConfigurations();
        this.confTableViewer.setInput((Object)this.orderedConfigurations);
    }

    public void init(List confs) {
        boolean enabled;
        if (confs.size() == 1 && "*".equals(confs.get(0))) {
            enabled = true;
            this.selectAll.setSelection(true);
            int i = 0;
            while (i < this.orderedConfigurations.length) {
                this.confTableViewer.setChecked((Object)this.orderedConfigurations[i], true);
                ++i;
            }
        } else {
            enabled = false;
            this.selectAll.setSelection(false);
            int i = 0;
            while (i < confs.size()) {
                String c = (String)confs.get(i);
                int j = 0;
                while (j < this.orderedConfigurations.length) {
                    if (this.orderedConfigurations[j].getName().equals(c)) {
                        this.confTableViewer.setChecked((Object)this.orderedConfigurations[j], true);
                        break;
                    }
                    ++j;
                }
                ++i;
            }
        }
        this.confTableViewer.getTable().setEnabled(!this.selectAll.getSelection());
        this.updateAllNoneEnableButtons(enabled);
        this.updateUpDownEnableButtons(enabled);
    }

    public List getSelectedConfigurations() {
        if (this.selectAll.getSelection()) {
            return Arrays.asList("*");
        }
        Object[] confs = this.confTableViewer.getCheckedElements();
        ArrayList<String> confList = new ArrayList<String>();
        int i = 0;
        while (i < confs.length) {
            Configuration c = (Configuration)confs[i];
            confList.add(c.getName());
            ++i;
        }
        return confList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ConfTableListener listener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remodeListener(ConfTableListener listener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void confTableUpdated() {
        List list = this.listeners;
        synchronized (list) {
            Iterator it = this.listeners.iterator();
            while (it.hasNext()) {
                ((ConfTableListener)it.next()).confTableUpdated(this.getSelectedConfigurations());
            }
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.selectAll.setEnabled(enabled);
        this.updateUpDownEnableButtons(enabled);
        this.updateAllNoneEnableButtons(enabled);
    }

    public static interface ConfTableListener {
        public void confTableUpdated(List var1);
    }

    static class ConfigurationLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ConfigurationLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return ((Configuration)element).getName();
            }
            return ((Configuration)element).getDescription();
        }
    }
}

