/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivyde.internal.eclipse.ui.editors.xml;

import org.apache.ivyde.internal.eclipse.ui.editors.xml.ColorManager;
import org.apache.ivyde.internal.eclipse.ui.editors.xml.IvyContentAssistProcessor;
import org.apache.ivyde.internal.eclipse.ui.editors.xml.NonRuleBasedDamagerRepairer;
import org.apache.ivyde.internal.eclipse.ui.editors.xml.XMLDoubleClickStrategy;
import org.apache.ivyde.internal.eclipse.ui.editors.xml.XMLScanner;
import org.apache.ivyde.internal.eclipse.ui.editors.xml.XMLTagScanner;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.widgets.Shell;

public class XMLConfiguration
extends SourceViewerConfiguration {
    private XMLDoubleClickStrategy doubleClickStrategy;
    private XMLTagScanner tagScanner;
    private XMLScanner scanner;
    private ColorManager colorManager;
    private IProject project;
    private IvyContentAssistProcessor processor;
    private IFile file;

    public XMLConfiguration(ColorManager colorManager, IvyContentAssistProcessor processor) {
        this.colorManager = colorManager;
        this.processor = processor;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__xml_comment", "__xml_tag"};
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        if (this.doubleClickStrategy == null) {
            this.doubleClickStrategy = new XMLDoubleClickStrategy();
        }
        return this.doubleClickStrategy;
    }

    protected XMLScanner getXMLScanner() {
        if (this.scanner == null) {
            this.scanner = new XMLScanner(this.colorManager);
            this.scanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.colorManager.getColor("editor.color.default"))));
        }
        return this.scanner;
    }

    protected XMLTagScanner getXMLTagScanner() {
        if (this.tagScanner == null) {
            this.tagScanner = new XMLTagScanner(this.colorManager);
            this.tagScanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.colorManager.getColor("editor.color.tag"))));
        }
        return this.tagScanner;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.getXMLTagScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__xml_tag");
        reconciler.setRepairer((IPresentationRepairer)dr, "__xml_tag");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getXMLScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        NonRuleBasedDamagerRepairer ndr = new NonRuleBasedDamagerRepairer(new TextAttribute(this.colorManager.getColor("editor.color.xmlComment")));
        reconciler.setDamager((IPresentationDamager)ndr, "__xml_comment");
        reconciler.setRepairer((IPresentationRepairer)ndr, "__xml_comment");
        return reconciler;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistant assistant = new ContentAssistant();
        assistant.setInformationControlCreator(new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, true);
            }
        });
        this.processor.setFile(this.file);
        assistant.setContentAssistProcessor((IContentAssistProcessor)this.processor, "__xml_tag");
        assistant.setContentAssistProcessor((IContentAssistProcessor)this.processor, "__xml_default");
        assistant.setContentAssistProcessor((IContentAssistProcessor)this.processor, "__dftl_partition_content_type");
        return assistant;
    }

    public void setFile(IFile file) {
        if (this.processor != null) {
            this.processor.setFile(file);
        }
        this.file = file;
    }
}

