/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.hook.ui.action;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.hook.ui.HookUI;
import com.liferay.ide.project.core.util.ProjectUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.modeling.annotations.FileSystemResourceType;
import org.eclipse.sapphire.modeling.annotations.ValidFileSystemResourceType;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.forms.PropertyEditorActionHandler;
import org.eclipse.sapphire.ui.forms.PropertyEditorCondition;
import org.eclipse.sapphire.ui.forms.PropertyEditorPart;

public class CreateSrcFileActionHandler
extends PropertyEditorActionHandler {
    private String refreshOnRunProperty;

    protected final boolean computeEnablementState() {
        IFile srcFile;
        boolean isEnabled = super.computeEnablementState();
        if (this.getModelElement() != null && isEnabled && (srcFile = this.getSrcFile()) != null && srcFile.exists()) {
            isEnabled = false;
        }
        return isEnabled;
    }

    private IPath getDefaultSrcFolderPath() {
        IProject project = (IProject)this.getModelElement().adapt(IProject.class);
        Object[] folders = ProjectUtil.getSourceFolders((IProject)project);
        if (!CoreUtil.isNullOrEmpty((Object[])folders)) {
            return folders[0].getFullPath();
        }
        return null;
    }

    private IFile getSrcFile() {
        IPath defaultSrcFolderPath;
        IFile retval = null;
        ValueProperty valueProperty = (ValueProperty)ValueProperty.class.cast(this.property().definition());
        Value value = this.getModelElement().property(valueProperty);
        if (value != null && !CoreUtil.isNullOrEmpty((String)value.text()) && (defaultSrcFolderPath = this.getDefaultSrcFolderPath()) != null) {
            IPath filePath = defaultSrcFolderPath.append(value.text());
            retval = ResourcesPlugin.getWorkspace().getRoot().getFile(filePath);
        }
        return retval;
    }

    public Object run(Presentation context) {
        block4: {
            IFile file = this.getSrcFile();
            try {
                if (file.exists()) break block4;
                ByteArrayInputStream defaultContentStream = new ByteArrayInputStream("".getBytes());
                file.create((InputStream)defaultContentStream, true, null);
                try {
                    file.refreshLocal(2, null);
                }
                catch (Exception e) {
                    HookUI.logError(e);
                }
                ValueProperty valueProperty = (ValueProperty)ValueProperty.class.cast(this.property().definition());
                Object content = this.getModelElement().property(valueProperty).content();
                this.getModelElement().property(valueProperty).clear();
                this.getModelElement().property(valueProperty).write(content);
                this.refreshEnablementState();
            }
            catch (Exception e) {
                HookUI.logError("Unable to create src file: " + file.getName(), e);
            }
        }
        return null;
    }

    public static class Condition
    extends PropertyEditorCondition {
        protected final boolean evaluate(PropertyEditorPart part) {
            ValidFileSystemResourceType typeAnnotation;
            Property property = part.property();
            Element element = part.getModelElement();
            return property.definition() instanceof ValueProperty && element != null && property.definition().isOfType(Path.class) && (typeAnnotation = (ValidFileSystemResourceType)property.definition().getAnnotation(ValidFileSystemResourceType.class)) != null && typeAnnotation.value() == FileSystemResourceType.FILE;
        }
    }
}

