/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.assist.internal;

import org.eclipse.sapphire.ElementHandle;
import org.eclipse.sapphire.ListProperty;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.services.DefaultValueService;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContext;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContribution;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContributor;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistSection;
import org.eclipse.sapphire.ui.forms.PropertyEditorPart;
import org.eclipse.sapphire.ui.forms.WithPart;

public final class ResetActionsAssistContributor
extends PropertyEditorAssistContributor {
    @Text(value="Restore default value")
    private static LocalizableText restoreDefaultValue;
    @Text(value="Clear")
    private static LocalizableText clear;

    static {
        LocalizableText.init(ResetActionsAssistContributor.class);
    }

    public ResetActionsAssistContributor() {
        this.setId("System.ResetActionsContributor");
        this.setPriority(310);
    }

    @Override
    public void contribute(PropertyEditorAssistContext context) {
        SapphirePart part = context.getPart();
        ElementHandle<?> property0 = null;
        boolean propertyReadOnly = false;
        if (part instanceof PropertyEditorPart) {
            property0 = ((PropertyEditorPart)part).property();
            propertyReadOnly = ((PropertyEditorPart)part).isReadOnly();
        } else if (part instanceof WithPart) {
            property0 = ((WithPart)part).property();
            propertyReadOnly = property0.definition().isReadOnly();
        }
        if (property0 == null || property0.empty() || propertyReadOnly) {
            return;
        }
        ElementHandle<?> property = property0;
        if (property instanceof Value) {
            DefaultValueService defaultValueService = (DefaultValueService)property.service(DefaultValueService.class);
            boolean hasDefaultValue = defaultValueService == null ? false : defaultValueService.value() != null;
            boolean isBooleanType = property.definition().getTypeClass().equals(Boolean.class);
            String actionText = hasDefaultValue || isBooleanType ? restoreDefaultValue.text() : clear.text();
            PropertyEditorAssistContribution.Factory contribution = PropertyEditorAssistContribution.factory();
            contribution.text("<p><a href=\"action\" nowrap=\"true\">" + ResetActionsAssistContributor.escapeForXml(actionText) + "</a></p>");
            contribution.link("action", new Runnable((Property)property){
                private final /* synthetic */ Property val$property;
                {
                    this.val$property = property;
                }

                @Override
                public void run() {
                    this.val$property.clear();
                }
            });
            PropertyEditorAssistSection section = context.getSection("actions");
            section.addContribution(contribution.create());
        } else if (property.definition() instanceof ListProperty) {
            PropertyEditorAssistContribution.Factory contribution = PropertyEditorAssistContribution.factory();
            contribution.text("<p><a href=\"action\" nowrap=\"true\">" + ResetActionsAssistContributor.escapeForXml(clear.text()) + "</a></p>");
            contribution.link("action", new Runnable((Property)property){
                private final /* synthetic */ Property val$property;
                {
                    this.val$property = property;
                }

                @Override
                public void run() {
                    this.val$property.clear();
                }
            });
            PropertyEditorAssistSection section = context.getSection("actions");
            section.addContribution(contribution.create());
        } else if (property instanceof ElementHandle) {
            PropertyEditorAssistContribution.Factory contribution = PropertyEditorAssistContribution.factory();
            contribution.text("<p><a href=\"action\" nowrap=\"true\">" + ResetActionsAssistContributor.escapeForXml(clear.text()) + "</a></p>");
            contribution.link("action", new Runnable((Property)property){
                private final /* synthetic */ Property val$property;
                {
                    this.val$property = property;
                }

                @Override
                public void run() {
                    this.val$property.clear();
                }
            });
            PropertyEditorAssistSection section = context.getSection("actions");
            section.addContribution(contribution.create());
        }
    }
}

