/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.diagram.editor;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.ui.Bounds;
import org.eclipse.sapphire.ui.PartValidationEvent;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.diagram.def.IDiagramNodeDef;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeBounds;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeEvent;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeTemplate;
import org.eclipse.sapphire.ui.diagram.editor.ImagePart;
import org.eclipse.sapphire.ui.diagram.editor.RectanglePart;
import org.eclipse.sapphire.ui.diagram.editor.ShapePart;
import org.eclipse.sapphire.ui.diagram.editor.TextPart;
import org.eclipse.sapphire.ui.diagram.shape.def.ImageDef;
import org.eclipse.sapphire.ui.diagram.shape.def.RectangleDef;
import org.eclipse.sapphire.ui.diagram.shape.def.ShapeDef;
import org.eclipse.sapphire.ui.diagram.shape.def.TextDef;
import org.eclipse.sapphire.ui.forms.PropertiesViewContributionManager;
import org.eclipse.sapphire.ui.forms.PropertiesViewContributionPart;
import org.eclipse.sapphire.ui.forms.PropertiesViewContributorPart;

public class DiagramNodePart
extends SapphirePart
implements PropertiesViewContributorPart {
    private static final String DEFAULT_ACTION_ID = "Sapphire.Diagram.Node.Default";
    private DiagramNodeTemplate nodeTemplate;
    private IDiagramNodeDef definition;
    private Element modelElement;
    private FunctionResult idFunctionResult;
    private SapphireAction defaultAction;
    private SapphireActionHandler defaultActionHandler;
    private PropertiesViewContributionManager propertiesViewContributionManager;
    private DiagramNodeBounds nodeBounds = new DiagramNodeBounds();
    private ShapePart shapePart;
    private static final String NODE_ID_SEPARATOR = "#";

    @Override
    protected void init() {
        super.init();
        this.nodeTemplate = (DiagramNodeTemplate)this.parent();
        this.definition = (IDiagramNodeDef)((SapphirePart)this).definition;
        this.modelElement = this.getModelElement();
        this.idFunctionResult = this.initExpression((Function)this.definition.getInstanceId().content(), String.class, null, new Runnable(){

            @Override
            public void run() {
            }
        });
        this.createShapePart();
        if (this.getPropertiesViewContribution() != null) {
            this.getPropertiesViewContribution().attach((Listener)new FilteredListener<PartValidationEvent>(){

                protected void handleTypedEvent(PartValidationEvent event) {
                    DiagramNodePart.this.refreshValidation();
                }
            });
        }
    }

    public DiagramNodeTemplate getDiagramNodeTemplate() {
        return this.nodeTemplate;
    }

    @Override
    public Element getLocalModelElement() {
        return this.modelElement;
    }

    public ShapePart getShapePart() {
        return this.shapePart;
    }

    public List<TextPart> getContainedTextParts() {
        ShapePart shapePart = this.getShapePart();
        if (shapePart instanceof TextPart) {
            return Collections.singletonList((TextPart)shapePart);
        }
        return ShapePart.getContainedShapeParts(shapePart, TextPart.class);
    }

    public List<ImagePart> getContainedImageParts() {
        ShapePart shapePart = this.getShapePart();
        if (shapePart instanceof ImagePart) {
            return Collections.singletonList((ImagePart)shapePart);
        }
        return ShapePart.getContainedShapeParts(shapePart, ImagePart.class);
    }

    @Override
    public Set<String> getActionContexts() {
        HashSet<String> contextSet = new HashSet<String>();
        contextSet.add("Sapphire.Diagram.Node");
        contextSet.add("Sapphire.Diagram.Node.Hidden");
        return contextSet;
    }

    public SapphireActionHandler getDefaultActionHandler() {
        if (this.defaultAction == null) {
            this.defaultAction = this.getAction(DEFAULT_ACTION_ID);
            this.defaultActionHandler = this.defaultAction.getFirstActiveHandler();
        }
        return this.defaultActionHandler;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.idFunctionResult != null) {
            this.idFunctionResult.dispose();
        }
        this.shapePart.dispose();
    }

    @Override
    protected Status computeValidation() {
        Status.CompositeStatusFactory factory = Status.factoryForComposite();
        factory.merge(this.getShapePart().validation());
        if (this.getPropertiesViewContribution() != null) {
            factory.merge(this.getPropertiesViewContribution().validation());
        }
        return factory.create();
    }

    public String getNodeTypeId() {
        return (String)this.definition.getId().content();
    }

    public String getInstanceId() {
        String id = null;
        if (this.idFunctionResult != null) {
            id = (String)this.idFunctionResult.value();
        }
        return id;
    }

    public String getId() {
        StringBuffer buffer = new StringBuffer(this.getNodeTypeId());
        buffer.append(NODE_ID_SEPARATOR);
        String instanceId = this.getInstanceId();
        if (instanceId != null && instanceId.length() > 0) {
            buffer.append(this.getInstanceId());
            buffer.append(NODE_ID_SEPARATOR);
        }
        List<DiagramNodePart> nodeParts = this.getDiagramNodeTemplate().getDiagramNodes();
        int index = nodeParts.indexOf(this);
        buffer.append(index);
        return buffer.toString();
    }

    public boolean canResizeShape() {
        return (Boolean)this.definition.isResizable().content();
    }

    public DiagramNodeBounds getNodeBounds() {
        DiagramNodeBounds bounds = new DiagramNodeBounds(this.nodeBounds);
        if (bounds.getWidth() < 0 && this.definition.getWidth().content() != null) {
            bounds.setWidth((Integer)this.definition.getWidth().content());
        }
        if (bounds.getHeight() < 0 && this.definition.getHeight().content() != null) {
            bounds.setHeight((Integer)this.definition.getHeight().content());
        }
        return bounds;
    }

    public void setNodeBounds(int x, int y) {
        this.setNodeBounds(new DiagramNodeBounds(x, y, -1, -1, false, false));
    }

    public void setNodeBounds(int x, int y, int width, int height) {
        this.setNodeBounds(new DiagramNodeBounds(x, y, width, height, false, false));
    }

    public void setNodeBounds(int x, int y, boolean autoLayout, boolean defaultPosition) {
        this.setNodeBounds(new DiagramNodeBounds(x, y, -1, -1, autoLayout, defaultPosition));
    }

    public void setNodeBounds(Bounds bounds) {
        DiagramNodeBounds nodeBounds = new DiagramNodeBounds(bounds);
        this.setNodeBounds(nodeBounds);
    }

    public void setNodeBounds(DiagramNodeBounds bounds) {
        if (!this.nodeBounds.equals(bounds)) {
            this.nodeBounds.setX(bounds.getX());
            this.nodeBounds.setY(bounds.getY());
            this.nodeBounds.setWidth(bounds.getWidth());
            this.nodeBounds.setHeight(bounds.getHeight());
            this.nodeBounds.setAutoLayout(bounds.isAutoLayout());
            this.nodeBounds.setDefaultPosition(bounds.isDefaultPosition());
            this.notifyNodeMove();
        }
    }

    private void notifyNodeMove() {
        DiagramNodeEvent event = new DiagramNodeEvent(this);
        event.setNodeEventType(DiagramNodeEvent.NodeEventType.NodeMove);
        this.broadcast(event);
    }

    @Override
    public PropertiesViewContributionPart getPropertiesViewContribution() {
        if (this.propertiesViewContributionManager == null) {
            this.propertiesViewContributionManager = new PropertiesViewContributionManager(this, this.getLocalModelElement());
        }
        return this.propertiesViewContributionManager.getPropertiesViewContribution();
    }

    private void createShapePart() {
        ShapeDef shape = (ShapeDef)this.definition.getShape().content();
        if (shape instanceof TextDef) {
            this.shapePart = new TextPart();
        } else if (shape instanceof ImageDef) {
            this.shapePart = new ImagePart();
        } else if (shape instanceof RectangleDef) {
            this.shapePart = new RectanglePart();
        }
        if (this.definition.getSelectionPresentation() != null) {
            this.shapePart.setSelectionPresentation(this.definition.getSelectionPresentation());
        }
        this.shapePart.init(this, this.modelElement, shape, Collections.<String, String>emptyMap());
        this.shapePart.initialize();
        this.shapePart.attach((Listener)new FilteredListener<PartValidationEvent>(){

            protected void handleTypedEvent(PartValidationEvent event) {
                DiagramNodePart.this.refreshValidation();
            }
        });
    }
}

