/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.forms.swt;

import org.eclipse.sapphire.LoggingService;
import org.eclipse.sapphire.Sapphire;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.EditFailedException;
import org.eclipse.sapphire.ui.DelayedTasksExecutor;
import org.eclipse.sapphire.ui.forms.FormComponentPart;
import org.eclipse.sapphire.ui.forms.swt.PropertyEditorPresentation;
import org.eclipse.sapphire.ui.forms.swt.SwtPresentation;
import org.eclipse.swt.widgets.Composite;

public abstract class ValuePropertyEditorPresentation
extends PropertyEditorPresentation {
    private final ModifyPropertyValueTask modifyPropertyTask = new ModifyPropertyValueTask();

    public ValuePropertyEditorPresentation(FormComponentPart part, SwtPresentation parent, Composite composite) {
        super(part, parent, composite);
    }

    public Value<?> property() {
        return (Value)super.property();
    }

    protected final void setPropertyValue(String value) {
        this.setPropertyValue(value, true);
    }

    protected final void setPropertyValue(String value, boolean async) {
        if (async) {
            this.modifyPropertyTask.setValue(value);
            DelayedTasksExecutor.schedule(this.modifyPropertyTask);
        } else {
            boolean rollback = false;
            try {
                this.property().write((Object)value);
            }
            catch (Exception e) {
                EditFailedException editFailedException = EditFailedException.findAsCause((Throwable)e);
                if (editFailedException != null) {
                    rollback = true;
                }
                ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
            }
            if (rollback) {
                this.handlePropertyChangedEvent();
            }
        }
    }

    private final class ModifyPropertyValueTask
    extends DelayedTasksExecutor.Task {
        private String value = null;

        private ModifyPropertyValueTask() {
        }

        public synchronized String getValue() {
            return this.value;
        }

        public synchronized void setValue(String value) {
            this.value = value;
        }

        @Override
        public int getPriority() {
            return 100;
        }

        @Override
        public void run() {
            ValuePropertyEditorPresentation.this.setPropertyValue(this.getValue(), false);
        }
    }
}

