/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.sapphire.ui.SapphireEditor;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.SubActionBars;
import org.eclipse.ui.internal.PopupMenuExtender;
import org.eclipse.ui.internal.services.INestable;
import org.eclipse.ui.internal.services.IServiceLocatorCreator;
import org.eclipse.ui.internal.services.ServiceLocator;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.services.IDisposable;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public final class SapphireEditorContentOutline
extends Page
implements IContentOutlinePage,
ISelectionProvider,
ISelectionChangedListener {
    private SapphireEditor editor;
    private ISelection selection;
    private List<ISelectionChangedListener> listeners;
    private PageBook pagebook;
    private IContentOutlinePage currentPage;
    private IContentOutlinePage emptyPage;
    private Map<IContentOutlinePage, SubPageSite> pageToPageSite;

    public SapphireEditorContentOutline(SapphireEditor editor) {
        this.editor = editor;
        this.listeners = new ArrayList<ISelectionChangedListener>();
        this.pageToPageSite = new HashMap<IContentOutlinePage, SubPageSite>();
    }

    public void addFocusListener(FocusListener listener) {
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add(listener);
    }

    public void createControl(Composite parent) {
        this.pagebook = new PageBook(parent, 0);
    }

    public void setActionBars(IActionBars actionBars) {
        this.refresh();
    }

    public void dispose() {
        if (this.pagebook != null && !this.pagebook.isDisposed()) {
            this.pagebook.dispose();
        }
        if (this.emptyPage != null) {
            this.emptyPage.dispose();
            this.emptyPage = null;
        }
        for (IContentOutlinePage page : this.pageToPageSite.keySet()) {
            page.dispose();
        }
        this.pageToPageSite.clear();
        this.pagebook = null;
        this.listeners = null;
        this.getSite().getActionBars().updateActionBars();
    }

    public boolean isDisposed() {
        return this.listeners == null;
    }

    public Control getControl() {
        return this.pagebook;
    }

    public PageBook getPagebook() {
        return this.pagebook;
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
    }

    public void removeFocusListener(FocusListener listener) {
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove(listener);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.setSelection(event.getSelection());
    }

    public void setFocus() {
        if (this.currentPage != null) {
            this.currentPage.setFocus();
        }
    }

    private IContentOutlinePage getEmptyPage() {
        if (this.emptyPage == null) {
            this.emptyPage = new EmptyOutlinePage();
        }
        return this.emptyPage;
    }

    public void refresh() {
        SubPageSite site;
        IContentOutlinePage page = this.editor.getContentOutlineForActivePage();
        if (page == null) {
            page = this.getEmptyPage();
        }
        if (this.currentPage != null) {
            this.currentPage.removeSelectionChangedListener((ISelectionChangedListener)this);
            this.pageToPageSite.get(this.currentPage).deactivate();
        }
        page.addSelectionChangedListener((ISelectionChangedListener)this);
        this.currentPage = page;
        if (this.pagebook == null) {
            return;
        }
        Control control = page.getControl();
        if (control == null || control.isDisposed()) {
            site = new SubPageSite(this.getSite());
            this.pageToPageSite.put(page, site);
            if (page instanceof IPageBookViewPage) {
                try {
                    ((IPageBookViewPage)page).init((IPageSite)site);
                }
                catch (PartInitException e) {
                    throw new RuntimeException(e);
                }
            }
            page.createControl((Composite)this.pagebook);
            control = page.getControl();
        } else {
            site = this.pageToPageSite.get(this.currentPage);
        }
        site.activate();
        this.pagebook.showPage(control);
        this.currentPage = page;
        this.getSite().getActionBars().updateActionBars();
    }

    public void setSelection(ISelection selection) {
        this.selection = selection;
        if (this.listeners == null) {
            return;
        }
        SelectionChangedEvent e = new SelectionChangedEvent((ISelectionProvider)this, selection);
        int i = 0;
        while (i < this.listeners.size()) {
            this.listeners.get(i).selectionChanged(e);
            ++i;
        }
    }

    private static final class EmptyOutlinePage
    implements IContentOutlinePage {
        private Composite control;

        public void createControl(Composite parent) {
            this.control = new Composite(parent, 0);
        }

        public void dispose() {
        }

        public Control getControl() {
            return this.control;
        }

        public void setActionBars(IActionBars actionBars) {
        }

        public void setFocus() {
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
        }

        public ISelection getSelection() {
            return new ISelection(){

                public boolean isEmpty() {
                    return true;
                }
            };
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        }

        public void setSelection(ISelection selection) {
        }
    }

    private static final class SubPageSite
    implements IPageSite,
    INestable {
        private ArrayList menuExtenders;
        private IPageSite parentSite;
        private ISelectionProvider selectionProvider;
        private final ServiceLocator serviceLocator;
        private SubActionBars subActionBars;

        public SubPageSite(IPageSite parentViewSite) {
            Assert.isNotNull((Object)parentViewSite);
            this.parentSite = parentViewSite;
            this.subActionBars = new SubActionBars(parentViewSite.getActionBars(), (IServiceLocator)this);
            IServiceLocatorCreator slc = (IServiceLocatorCreator)this.parentSite.getService(IServiceLocatorCreator.class);
            this.serviceLocator = (ServiceLocator)slc.createServiceLocator((IServiceLocator)parentViewSite, null, new IDisposable(){

                public void dispose() {
                }
            });
            this.initializeDefaultServices();
        }

        private void initializeDefaultServices() {
        }

        protected void dispose() {
            if (this.menuExtenders != null) {
                HashSet<MenuManager> managers = new HashSet<MenuManager>(this.menuExtenders.size());
                int i = 0;
                while (i < this.menuExtenders.size()) {
                    PopupMenuExtender ext = (PopupMenuExtender)this.menuExtenders.get(i);
                    managers.add(ext.getManager());
                    ext.dispose();
                    ++i;
                }
                if (managers.size() > 0) {
                    for (MenuManager mgr : managers) {
                        mgr.dispose();
                    }
                }
                this.menuExtenders = null;
            }
            this.subActionBars.dispose();
            this.serviceLocator.dispose();
        }

        public IActionBars getActionBars() {
            return this.subActionBars;
        }

        public Object getAdapter(Class adapter) {
            return Platform.getAdapterManager().getAdapter((Object)this, adapter);
        }

        public IWorkbenchPage getPage() {
            return this.parentSite.getPage();
        }

        public ISelectionProvider getSelectionProvider() {
            return this.selectionProvider;
        }

        public final Object getService(Class key) {
            return this.serviceLocator.getService(key);
        }

        public Shell getShell() {
            return this.parentSite.getShell();
        }

        public IWorkbenchWindow getWorkbenchWindow() {
            return this.parentSite.getWorkbenchWindow();
        }

        public final boolean hasService(Class key) {
            return this.serviceLocator.hasService(key);
        }

        public void registerContextMenu(String menuID, MenuManager menuMgr, ISelectionProvider selProvider) {
            if (this.menuExtenders == null) {
                this.menuExtenders = new ArrayList(1);
            }
        }

        public void setSelectionProvider(ISelectionProvider provider) {
            this.selectionProvider = provider;
        }

        public void activate() {
            this.serviceLocator.activate();
            this.subActionBars.activate();
        }

        public void deactivate() {
            this.serviceLocator.deactivate();
            this.subActionBars.deactivate();
        }
    }
}

