/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.internal.core.JavaElement;
import org.eclipse.wst.jsdt.internal.core.Member;

public abstract class NamedMember
extends Member {
    protected String name;

    public NamedMember(JavaElement parent, String name) {
        super(parent);
        this.name = name;
    }

    public String getElementName() {
        return this.name;
    }

    protected String getKey(IField field, boolean forceOpen) throws JavaScriptModelException {
        StringBuffer key = new StringBuffer();
        IJavaScriptElement parent = field.getParent();
        String declaringKey = "??";
        if (parent instanceof IJavaScriptUnit) {
            declaringKey = this.getKey((IJavaScriptUnit)parent, forceOpen);
        } else if (parent instanceof IType) {
            declaringKey = this.getKey((IType)parent, forceOpen);
        }
        key.append(declaringKey);
        key.append('.');
        key.append(field.getElementName());
        return key.toString();
    }

    protected String getKey(IFunction method, boolean forceOpen) throws JavaScriptModelException {
        StringBuffer key = new StringBuffer();
        IJavaScriptElement parent = method.getParent();
        String declaringKey = "??";
        if (parent instanceof IJavaScriptUnit) {
            declaringKey = this.getKey((IJavaScriptUnit)parent, forceOpen);
        } else if (parent instanceof IType) {
            declaringKey = this.getKey((IType)parent, forceOpen);
        }
        key.append(declaringKey);
        key.append('.');
        String selector = method.getElementName();
        key.append(selector);
        key.append('(');
        String[] parameters = method.getParameterNames();
        int i = 0;
        int length = parameters.length;
        while (i < length) {
            key.append(parameters[i].replace('.', '/'));
            ++i;
        }
        key.append(')');
        if (forceOpen) {
            if (method.getReturnType() != null) {
                key.append(method.getReturnType().replace('.', '/'));
            }
        } else {
            key.append('V');
        }
        return key.toString();
    }

    protected String getKey(IJavaScriptUnit unit, boolean forceOpen) throws JavaScriptModelException {
        StringBuffer key = new StringBuffer();
        key.append('U');
        String packageName = unit.getParent().getElementName();
        key.append(packageName.replace('.', '/'));
        if (packageName.length() > 0) {
            key.append('/');
        }
        key.append(unit.getElementName());
        key.append(';');
        return key.toString();
    }

    protected String getKey(IType type, boolean forceOpen) throws JavaScriptModelException {
        String topLevelTypeName;
        String cuName;
        String mainTypeName;
        StringBuffer key = new StringBuffer();
        key.append('L');
        String packageName = type.getPackageFragment().getElementName();
        key.append(packageName.replace('.', '/'));
        if (packageName.length() > 0) {
            key.append('/');
        }
        String typeQualifiedName = type.getTypeQualifiedName();
        IJavaScriptUnit cu = (IJavaScriptUnit)type.getAncestor(5);
        if (cu != null && !(mainTypeName = (cuName = cu.getElementName()).substring(0, cuName.lastIndexOf(46))).equals(topLevelTypeName = typeQualifiedName)) {
            key.append(mainTypeName);
            key.append('~');
        }
        key.append(typeQualifiedName);
        key.append(';');
        return key.toString();
    }

    protected String getFullyQualifiedParameterizedName(String fullyQualifiedName, String uniqueKey) throws JavaScriptModelException {
        String[] typeArguments = new String[0];
        int length = typeArguments.length;
        if (length == 0) {
            return fullyQualifiedName;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(fullyQualifiedName);
        buffer.append('<');
        int i = 0;
        while (i < length) {
            String typeArgument = typeArguments[i];
            buffer.append(Signature.toString(typeArgument));
            if (i < length - 1) {
                buffer.append(',');
            }
            ++i;
        }
        buffer.append('>');
        return buffer.toString();
    }

    protected IPackageFragment getPackageFragment() {
        return null;
    }

    public String getFullyQualifiedName(char enclosingTypeSeparator, boolean showParameters) throws JavaScriptModelException {
        String packageName = this.getPackageFragment().getElementName();
        if (packageName.equals("")) {
            return this.getTypeQualifiedName(enclosingTypeSeparator, showParameters);
        }
        return String.valueOf(packageName) + '.' + this.getTypeQualifiedName(enclosingTypeSeparator, showParameters);
    }

    public String getTypeQualifiedName(char enclosingTypeSeparator, boolean showParameters) throws JavaScriptModelException {
        NamedMember declaringType;
        switch (this.parent.getElementType()) {
            case 5: {
                if (showParameters) {
                    StringBuffer buffer = new StringBuffer(this.name);
                    return buffer.toString();
                }
                return this.name;
            }
            case 6: {
                this.parent.getElementName();
                String typeName = this.name;
                if (showParameters) {
                    StringBuffer buffer = new StringBuffer(typeName);
                    return buffer.toString();
                }
                return typeName;
            }
            case 7: {
                declaringType = (NamedMember)this.parent;
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                declaringType = (NamedMember)((Object)((IMember)((Object)this.parent)).getDeclaringType());
                break;
            }
            default: {
                return null;
            }
        }
        String typeQualifiedName = declaringType != null ? declaringType.getTypeQualifiedName(enclosingTypeSeparator, showParameters) : "";
        StringBuffer buffer = new StringBuffer(typeQualifiedName);
        buffer.append(enclosingTypeSeparator);
        String simpleName = this.name.length() == 0 ? Integer.toString(this.occurrenceCount) : this.name;
        buffer.append(simpleName);
        return buffer.toString();
    }
}

