/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.WorkingCopyOwner;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchDocument;
import org.eclipse.wst.jsdt.core.search.SearchParticipant;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.core.search.SearchRequestor;
import org.eclipse.wst.jsdt.core.search.TypeNameMatch;
import org.eclipse.wst.jsdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.wst.jsdt.internal.compiler.env.AccessRestriction;
import org.eclipse.wst.jsdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.wst.jsdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.wst.jsdt.internal.compiler.parser.Parser;
import org.eclipse.wst.jsdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.wst.jsdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.wst.jsdt.internal.core.CompilationUnit;
import org.eclipse.wst.jsdt.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.JavaProject;
import org.eclipse.wst.jsdt.internal.core.Logger;
import org.eclipse.wst.jsdt.internal.core.search.HierarchyScope;
import org.eclipse.wst.jsdt.internal.core.search.IConstructorRequestor;
import org.eclipse.wst.jsdt.internal.core.search.IFunctionRequester;
import org.eclipse.wst.jsdt.internal.core.search.IModuleRequestor;
import org.eclipse.wst.jsdt.internal.core.search.IRestrictedAccessBindingRequestor;
import org.eclipse.wst.jsdt.internal.core.search.IRestrictedAccessTypeRequestor;
import org.eclipse.wst.jsdt.internal.core.search.IVariableRequester;
import org.eclipse.wst.jsdt.internal.core.search.IndexQueryRequestor;
import org.eclipse.wst.jsdt.internal.core.search.JavaSearchDocument;
import org.eclipse.wst.jsdt.internal.core.search.JavaSearchParticipant;
import org.eclipse.wst.jsdt.internal.core.search.JavaSearchScope;
import org.eclipse.wst.jsdt.internal.core.search.JavaSearchTypeNameMatch;
import org.eclipse.wst.jsdt.internal.core.search.PathCollector;
import org.eclipse.wst.jsdt.internal.core.search.PatternSearchJob;
import org.eclipse.wst.jsdt.internal.core.search.indexing.IIndexConstants;
import org.eclipse.wst.jsdt.internal.core.search.indexing.IndexManager;
import org.eclipse.wst.jsdt.internal.core.search.matching.ConstructorPattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.DeclarationOfAccessedFieldsPattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.DeclarationOfReferencedMethodsPattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.DeclarationOfReferencedTypesPattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.FieldPattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.MatchLocator;
import org.eclipse.wst.jsdt.internal.core.search.matching.MethodPattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.MultiTypeDeclarationPattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.TypeDeclarationPattern;
import org.eclipse.wst.jsdt.internal.core.util.Messages;
import org.eclipse.wst.jsdt.internal.core.util.QualificationHelpers;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class BasicSearchEngine {
    private static final String GLOBAL_TYPE_SYMBOL = new String(IIndexConstants.GLOBAL_SYMBOL);
    private Parser parser;
    private CompilerOptions compilerOptions;
    private IJavaScriptUnit[] workingCopies;
    private HashSet fWorkingCopiesPaths;
    private WorkingCopyOwner workingCopyOwner;
    public static boolean VERBOSE = false;

    public BasicSearchEngine() {
    }

    public BasicSearchEngine(IJavaScriptUnit[] workingCopies) {
        this.workingCopies = workingCopies;
    }

    char convertTypeKind(int typeDeclarationKind) {
        switch (typeDeclarationKind) {
            case 1: {
                return 'C';
            }
        }
        return '\u0000';
    }

    public BasicSearchEngine(WorkingCopyOwner workingCopyOwner) {
        this.workingCopyOwner = workingCopyOwner;
    }

    public static IJavaScriptSearchScope createHierarchyScope(IType type) throws JavaScriptModelException {
        return BasicSearchEngine.createHierarchyScope(type, DefaultWorkingCopyOwner.PRIMARY);
    }

    public static IJavaScriptSearchScope createHierarchyScope(IType type, WorkingCopyOwner owner) throws JavaScriptModelException {
        return new HierarchyScope(type, owner);
    }

    public static IJavaScriptSearchScope createJavaSearchScope(IJavaScriptElement[] elements) {
        return BasicSearchEngine.createJavaSearchScope(elements, true);
    }

    public static IJavaScriptSearchScope createJavaSearchScope(IJavaScriptElement[] elements, boolean includeReferencedProjects) {
        int includeMask = 7;
        if (includeReferencedProjects) {
            includeMask |= 8;
        }
        return BasicSearchEngine.createJavaSearchScope(elements, includeMask);
    }

    public static IJavaScriptSearchScope createJavaSearchScope(IJavaScriptElement[] elements, int includeMask) {
        JavaSearchScope scope = new JavaSearchScope();
        HashSet visitedProjects = new HashSet(2);
        int i = 0;
        int length = elements.length;
        while (i < length) {
            IJavaScriptElement element = elements[i];
            if (element != null) {
                try {
                    if (element instanceof JavaProject) {
                        scope.add((JavaProject)element, includeMask, visitedProjects);
                    } else {
                        scope.add(element);
                    }
                }
                catch (JavaScriptModelException javaScriptModelException) {}
            }
            ++i;
        }
        return scope;
    }

    public static TypeNameMatch createTypeNameMatch(IType type, int modifiers) {
        return new JavaSearchTypeNameMatch(type, modifiers);
    }

    public static IJavaScriptSearchScope createWorkspaceScope() {
        return JavaModelManager.getJavaModelManager().getWorkspaceScope();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void findMatches(SearchPattern pattern, SearchParticipant[] participants, IJavaScriptSearchScope scope, SearchRequestor requestor, IProgressMonitor monitor) throws CoreException {
        block20: {
            block19: {
                if (monitor != null && monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                try {
                    if (VERBOSE) {
                        Util.verbose("Searching for pattern: " + pattern.toString());
                        Util.verbose(scope.toString());
                    }
                    if (participants == null) {
                        if (VERBOSE) {
                            Util.verbose("No participants => do nothing!");
                        }
                        Object var17_6 = null;
                        requestor.endReporting();
                        if (monitor == null) return;
                        break block19;
                    }
                    int length = participants.length;
                    if (monitor != null) {
                        monitor.beginTask(Messages.engine_searching, 100 * length);
                    }
                    IndexManager indexManager = JavaModelManager.getJavaModelManager().getIndexManager();
                    requestor.beginReporting();
                    int i = 0;
                    while (i < length) {
                        Object var15_19;
                        if (monitor != null && monitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        SearchParticipant participant = participants[i];
                        try {
                            String[] indexMatchPaths;
                            if (monitor != null) {
                                monitor.subTask(Messages.bind(Messages.engine_searching_indexing, new String[]{participant.getDescription()}));
                            }
                            participant.beginSearching();
                            requestor.enterParticipant(participant);
                            PathCollector pathCollector = new PathCollector();
                            indexManager.performConcurrentJob(new PatternSearchJob(pattern, participant, scope, pathCollector), 3, (IProgressMonitor)(monitor == null ? null : new SubProgressMonitor(monitor, 50)));
                            if (monitor != null && monitor.isCanceled()) {
                                throw new OperationCanceledException();
                            }
                            if (monitor != null) {
                                monitor.subTask(Messages.bind(Messages.engine_searching_matching, new String[]{participant.getDescription()}));
                            }
                            if ((indexMatchPaths = pathCollector.getPaths()) != null) {
                                SearchDocument[] matches;
                                pathCollector = null;
                                int indexMatchLength = indexMatchPaths.length;
                                SearchDocument[] indexMatches = new SearchDocument[indexMatchLength];
                                int j = 0;
                                while (true) {
                                    if (j >= indexMatchLength) {
                                        matches = MatchLocator.addWorkingCopies(pattern, indexMatches, this.getWorkingCopies(), participant);
                                    }
                                    indexMatches[j] = participant.getDocument(indexMatchPaths[j]);
                                    ++j;
                                }
                                participant.locateMatches(matches, pattern, scope, requestor, (IProgressMonitor)(monitor == null ? null : new SubProgressMonitor(monitor, 50)));
                            }
                        }
                        catch (Throwable throwable) {
                            var15_19 = null;
                            requestor.exitParticipant(participant);
                            participant.doneSearching();
                            throw throwable;
                        }
                        {
                            var15_19 = null;
                            requestor.exitParticipant(participant);
                            participant.doneSearching();
                            ++i;
                        }
                    }
                    break block20;
                }
                catch (Throwable throwable) {
                    Object var17_7 = null;
                    requestor.endReporting();
                    if (monitor == null) throw throwable;
                    monitor.done();
                    throw throwable;
                }
            }
            monitor.done();
            return;
        }
        Object var17_8 = null;
        requestor.endReporting();
        if (monitor == null) return;
        monitor.done();
    }

    public static SearchParticipant getDefaultSearchParticipant() {
        return new JavaSearchParticipant();
    }

    public static String getMatchRuleString(int matchRule) {
        if (matchRule == 0) {
            return "R_EXACT_MATCH";
        }
        StringBuffer buffer = new StringBuffer();
        int i = 1;
        while (i <= 8) {
            int bit = matchRule & 1 << i - 1;
            if (bit != 0 && buffer.length() > 0) {
                buffer.append(" | ");
            }
            switch (bit) {
                case 1: {
                    buffer.append("R_PREFIX_MATCH");
                    break;
                }
                case 8: {
                    buffer.append("R_CASE_SENSITIVE");
                    break;
                }
                case 32: {
                    buffer.append("R_EQUIVALENT_MATCH");
                    break;
                }
                case 16: {
                    buffer.append("R_ERASURE_MATCH");
                    break;
                }
                case 64: {
                    buffer.append("R_FULL_MATCH");
                    break;
                }
                case 2: {
                    buffer.append("R_PATTERN_MATCH");
                    break;
                }
                case 4: {
                    buffer.append("R_REGEXP_MATCH");
                    break;
                }
                case 128: {
                    buffer.append("R_CAMELCASE_MATCH");
                }
            }
            ++i;
        }
        return buffer.toString();
    }

    public static String getSearchForString(int searchFor) {
        switch (searchFor) {
            case 0: {
                return "TYPE";
            }
            case 1: {
                return "METHOD";
            }
            case 2: {
                return "PACKAGE";
            }
            case 3: {
                return "CONSTRUCTOR";
            }
            case 4: {
                return "FIELD";
            }
            case 5: {
                return "CLASS";
            }
            case 12: {
                return "VAR";
            }
            case 13: {
                return "FUNCTION";
            }
        }
        return "UNKNOWN";
    }

    private Parser getParser() {
        if (this.parser == null) {
            this.compilerOptions = new CompilerOptions(JavaScriptCore.getOptions());
            ProblemReporter problemReporter = new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), this.compilerOptions, new DefaultProblemFactory());
            this.parser = new Parser(problemReporter, true);
        }
        return this.parser;
    }

    private IJavaScriptUnit[] getWorkingCopies() {
        int length;
        IJavaScriptUnit[] copies;
        if (this.workingCopies != null) {
            if (this.workingCopyOwner == null) {
                copies = JavaModelManager.getJavaModelManager().getWorkingCopies(DefaultWorkingCopyOwner.PRIMARY, false);
                if (copies == null) {
                    copies = this.workingCopies;
                } else {
                    IJavaScriptUnit unit;
                    HashMap<IPath, IJavaScriptUnit> pathToCUs = new HashMap<IPath, IJavaScriptUnit>();
                    int i = 0;
                    int length2 = copies.length;
                    while (i < length2) {
                        unit = copies[i];
                        pathToCUs.put(unit.getPath(), unit);
                        ++i;
                    }
                    i = 0;
                    length2 = this.workingCopies.length;
                    while (i < length2) {
                        unit = this.workingCopies[i];
                        pathToCUs.put(unit.getPath(), unit);
                        ++i;
                    }
                    length = pathToCUs.size();
                    copies = new IJavaScriptUnit[length];
                    pathToCUs.values().toArray(copies);
                }
            } else {
                copies = this.workingCopies;
            }
        } else {
            copies = this.workingCopyOwner != null ? JavaModelManager.getJavaModelManager().getWorkingCopies(this.workingCopyOwner, true) : JavaModelManager.getJavaModelManager().getWorkingCopies(DefaultWorkingCopyOwner.PRIMARY, false);
        }
        if (copies == null) {
            return null;
        }
        IJavaScriptUnit[] result = null;
        length = copies.length;
        int index = 0;
        int i = 0;
        while (i < length) {
            CompilationUnit copy = (CompilationUnit)copies[i];
            try {
                if (!copy.isPrimary() || copy.hasUnsavedChanges() || copy.hasResourceChanged()) {
                    if (result == null) {
                        result = new IJavaScriptUnit[length];
                    }
                    result[index++] = copy;
                }
            }
            catch (JavaScriptModelException javaScriptModelException) {}
            ++i;
        }
        if (index != length && result != null) {
            IJavaScriptUnit[] iJavaScriptUnitArray = result;
            result = new IJavaScriptUnit[index];
            System.arraycopy(iJavaScriptUnitArray, 0, result, 0, index);
        }
        return result;
    }

    private HashSet getWorkingCopiesPaths() {
        if (this.fWorkingCopiesPaths == null) {
            this.fWorkingCopiesPaths = new HashSet();
            IJavaScriptUnit[] workingCopies = this.getWorkingCopies();
            int i = 0;
            while (workingCopies != null && i < workingCopies.length) {
                this.fWorkingCopiesPaths.add(workingCopies[i].getPath().toString());
                ++i;
            }
        }
        return this.fWorkingCopiesPaths;
    }

    private IJavaScriptUnit[] getWorkingCopies(IJavaScriptElement element) {
        IJavaScriptUnit cu;
        if (element instanceof IMember && (cu = ((IMember)element).getJavaScriptUnit()) != null && cu.isWorkingCopy()) {
            int length;
            IJavaScriptUnit[] copies = this.getWorkingCopies();
            int n = length = copies == null ? 0 : copies.length;
            if (length > 0) {
                IJavaScriptUnit[] newWorkingCopies = new IJavaScriptUnit[length + 1];
                System.arraycopy(copies, 0, newWorkingCopies, 0, length);
                newWorkingCopies[length] = cu;
                return newWorkingCopies;
            }
            return new IJavaScriptUnit[]{cu};
        }
        return this.getWorkingCopies();
    }

    boolean match(char patternTypeSuffix, int modifiers) {
        switch (patternTypeSuffix) {
            case 'C': {
                return modifiers == 0;
            }
        }
        return true;
    }

    boolean match(char patternTypeSuffix, char[] patternPkg, char[] patternTypeName, int matchRule, int typeKind, char[] pkg, char[] typeName) {
        boolean isCaseSensitive;
        if (typeName == null) {
            typeName = CharOperation.NO_CHAR;
        }
        switch (patternTypeSuffix) {
            case 'C': {
                if (typeKind == 1) break;
                return false;
            }
        }
        boolean bl = isCaseSensitive = (matchRule & 8) != 0;
        if (patternPkg != null && !CharOperation.equals(patternPkg, pkg, isCaseSensitive)) {
            return false;
        }
        if (patternTypeName != null) {
            boolean matchFirstChar;
            boolean isCamelCase = (matchRule & 0x80) != 0;
            int matchMode = matchRule & 7;
            if (!isCaseSensitive && !isCamelCase) {
                patternTypeName = CharOperation.toLowerCase(patternTypeName);
            }
            boolean bl2 = matchFirstChar = !isCaseSensitive || patternTypeName[0] == typeName[0];
            if (isCamelCase && matchFirstChar && CharOperation.camelCaseMatch(patternTypeName, typeName)) {
                return true;
            }
            switch (matchMode) {
                case 0: {
                    if (!isCamelCase) {
                        return matchFirstChar && CharOperation.equals(patternTypeName, typeName, isCaseSensitive);
                    }
                }
                case 1: {
                    return matchFirstChar && CharOperation.prefixEquals(patternTypeName, typeName, isCaseSensitive);
                }
                case 2: {
                    return CharOperation.match(patternTypeName, typeName, isCaseSensitive);
                }
            }
        }
        return true;
    }

    public void search(SearchPattern pattern, SearchParticipant[] participants, IJavaScriptSearchScope scope, SearchRequestor requestor, IProgressMonitor monitor) throws CoreException {
        if (VERBOSE) {
            Util.verbose("BasicSearchEngine.search(SearchPattern, SearchParticipant[], IJavaScriptSearchScope, SearchRequestor, IProgressMonitor)");
        }
        this.findMatches(pattern, participants, scope, requestor, monitor);
    }

    /*
     * Exception decompiling
     */
    public void searchAllBindingNames(char[] packageName, char[] bindingName, int bindingType, int matchRule, IJavaScriptSearchScope scope, IRestrictedAccessBindingRequestor nameRequestor, int waitingPolicy, boolean doParse, IProgressMonitor progressMonitor) throws JavaScriptModelException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 1058->1062)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void searchAllSecondaryTypeNames(IPackageFragmentRoot[] sourceFolders, IRestrictedAccessTypeRequestor nameRequestor, boolean waitForIndexes, IProgressMonitor progressMonitor) throws JavaScriptModelException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 244->248)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void searchAllTypeNames(char[] prefix, int matchRule, IJavaScriptSearchScope scope, IRestrictedAccessTypeRequestor nameRequestor, int waitingPolicy, IProgressMonitor progressMonitor) throws JavaScriptModelException {
        TypeDeclarationPattern pattern = new TypeDeclarationPattern(prefix, matchRule);
        this.searchAllTypeNames(pattern, scope, nameRequestor, waitingPolicy, progressMonitor);
    }

    public void searchAllTypeNames(char[] qualification, char[] simpleTypeName, int matchRule, IJavaScriptSearchScope scope, IRestrictedAccessTypeRequestor nameRequestor, int waitingPolicy, IProgressMonitor progressMonitor) throws JavaScriptModelException {
        if (VERBOSE) {
            Util.verbose("BasicSearchEngine.searchAllTypeNames(char[], char[], int, int, IJavaScriptSearchScope, IRestrictedAccessTypeRequestor, int, IProgressMonitor)");
            Util.verbose("\t- package name: " + (qualification == null ? "null" : new String(qualification)));
            Util.verbose("\t- type name: " + (simpleTypeName == null ? "null" : new String(simpleTypeName)));
            Util.verbose("\t- match rule: " + BasicSearchEngine.getMatchRuleString(matchRule));
            Util.verbose("\t- scope: " + scope);
        }
        TypeDeclarationPattern pattern = new TypeDeclarationPattern(qualification, simpleTypeName, matchRule);
        this.searchAllTypeNames(pattern, scope, nameRequestor, waitingPolicy, progressMonitor);
    }

    public void searchAllTypeNames(char[][] qualifications, char[][] simpleTypeNames, int matchRule, IJavaScriptSearchScope scope, IRestrictedAccessTypeRequestor nameRequestor, int waitingPolicy, IProgressMonitor progressMonitor) throws JavaScriptModelException {
        if (VERBOSE) {
            Util.verbose("BasicSearchEngine.searchAllTypeNames(char[][], char[][], int, int, IJavaScriptSearchScope, IRestrictedAccessTypeRequestor, int, IProgressMonitor)");
            Util.verbose("\t- package name: " + (qualifications == null ? "null" : new String(CharOperation.concatWith(qualifications, ','))));
            Util.verbose("\t- type name: " + (simpleTypeNames == null ? "null" : new String(CharOperation.concatWith(simpleTypeNames, ','))));
            Util.verbose("\t- match rule: " + matchRule);
            Util.verbose("\t- scope: " + scope);
        }
        MultiTypeDeclarationPattern pattern = new MultiTypeDeclarationPattern(qualifications, simpleTypeNames, matchRule);
        this.searchAllTypeNames(pattern, scope, nameRequestor, waitingPolicy, progressMonitor);
    }

    /*
     * Exception decompiling
     */
    private void searchAllTypeNames(TypeDeclarationPattern pattern, IJavaScriptSearchScope scope, IRestrictedAccessTypeRequestor nameRequestor, int waitingPolicy, IProgressMonitor progressMonitor) throws JavaScriptModelException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 369->373)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void searchAllModuleDeclarations(SearchPattern pattern, IJavaScriptSearchScope scope, IModuleRequestor requestor, IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 769->773)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void searchDeclarations(IJavaScriptElement enclosingElement, SearchRequestor requestor, SearchPattern pattern, IProgressMonitor monitor) throws JavaScriptModelException {
        if (VERBOSE) {
            Util.verbose("\t- java element: " + enclosingElement);
        }
        IJavaScriptSearchScope scope = BasicSearchEngine.createJavaSearchScope(new IJavaScriptElement[]{enclosingElement});
        IResource resource = enclosingElement.getResource();
        if (enclosingElement instanceof IMember) {
            IMember member = (IMember)enclosingElement;
            IJavaScriptUnit cu = member.getJavaScriptUnit();
            if (cu != null) {
                resource = cu.getResource();
            } else if (member.isBinary()) {
                resource = null;
            }
        }
        try {
            if (!(resource instanceof IFile)) {
                this.search(pattern, new SearchParticipant[]{BasicSearchEngine.getDefaultSearchParticipant()}, scope, requestor, monitor);
                return;
            }
            try {
                requestor.beginReporting();
                if (VERBOSE) {
                    Util.verbose("Searching for " + pattern + " in " + resource.getFullPath());
                }
                SearchParticipant participant = BasicSearchEngine.getDefaultSearchParticipant();
                SearchDocument[] documents = MatchLocator.addWorkingCopies(pattern, new SearchDocument[]{new JavaSearchDocument(enclosingElement.getPath().toString(), participant)}, this.getWorkingCopies(enclosingElement), participant);
                participant.locateMatches(documents, pattern, scope, requestor, monitor);
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                requestor.endReporting();
                throw throwable;
            }
            {
                Object var9_12 = null;
                requestor.endReporting();
                return;
            }
        }
        catch (CoreException e) {
            if (!(e instanceof JavaScriptModelException)) throw new JavaScriptModelException(e);
            throw (JavaScriptModelException)e;
        }
    }

    public void searchDeclarationsOfAccessedFields(IJavaScriptElement enclosingElement, SearchRequestor requestor, IProgressMonitor monitor) throws JavaScriptModelException {
        if (VERBOSE) {
            Util.verbose("BasicSearchEngine.searchDeclarationsOfAccessedFields(IJavaScriptElement, SearchRequestor, SearchPattern, IProgressMonitor)");
        }
        DeclarationOfAccessedFieldsPattern pattern = new DeclarationOfAccessedFieldsPattern(enclosingElement);
        this.searchDeclarations(enclosingElement, requestor, pattern, monitor);
    }

    public void searchDeclarationsOfReferencedTypes(IJavaScriptElement enclosingElement, SearchRequestor requestor, IProgressMonitor monitor) throws JavaScriptModelException {
        if (VERBOSE) {
            Util.verbose("BasicSearchEngine.searchDeclarationsOfReferencedTypes(IJavaScriptElement, SearchRequestor, SearchPattern, IProgressMonitor)");
        }
        DeclarationOfReferencedTypesPattern pattern = new DeclarationOfReferencedTypesPattern(enclosingElement);
        this.searchDeclarations(enclosingElement, requestor, pattern, monitor);
    }

    public void searchDeclarationsOfSentMessages(IJavaScriptElement enclosingElement, SearchRequestor requestor, IProgressMonitor monitor) throws JavaScriptModelException {
        if (VERBOSE) {
            Util.verbose("BasicSearchEngine.searchDeclarationsOfSentMessages(IJavaScriptElement, SearchRequestor, SearchPattern, IProgressMonitor)");
        }
        DeclarationOfReferencedMethodsPattern pattern = new DeclarationOfReferencedMethodsPattern(enclosingElement);
        this.searchDeclarations(enclosingElement, requestor, pattern, monitor);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void searchAllConstructorDeclarations(char[] prefix, int typeMatchRule, IJavaScriptSearchScope scope, final IConstructorRequestor requestor, int waitingPolicy, IProgressMonitor progressMonitor) {
        ConstructorPattern pattern;
        block17: {
            if (VERBOSE) {
                Util.verbose("BasicSearchEngine.searchAllConstructorDeclarations(char[], char[], int, IJavaSearchScope, IRestrictedAccessConstructorRequestor, int, IProgressMonitor)");
                Util.verbose("\t- type name: " + (prefix == null ? "null" : new String(prefix)));
                Util.verbose("\t- type match rule: " + BasicSearchEngine.getMatchRuleString(typeMatchRule));
                Util.verbose("\t- scope: " + scope);
            }
            IndexManager indexManager = JavaModelManager.getJavaModelManager().getIndexManager();
            pattern = new ConstructorPattern(prefix, typeMatchRule);
            final HashSet workingCopiesPaths = this.getWorkingCopiesPaths();
            IndexQueryRequestor searchRequestor = new IndexQueryRequestor(){

                public boolean acceptIndexMatch(String documentPath, SearchPattern indexRecord, SearchParticipant participant, AccessRuleSet access) {
                    ConstructorPattern record = (ConstructorPattern)indexRecord;
                    if (!workingCopiesPaths.contains(documentPath)) {
                        AccessRestriction accessRestriction = null;
                        if (access != null) {
                            int nameLength = record.declaringSimpleName == null ? 0 : record.declaringSimpleName.length;
                            char[] path = new char[nameLength];
                            int pos = 0;
                            if (nameLength > 0) {
                                System.arraycopy(record.declaringSimpleName, 0, path, pos, nameLength);
                                pos += nameLength;
                            }
                            if (pos > 0) {
                                accessRestriction = access.getViolatedRestriction(path);
                            }
                        }
                        requestor.acceptConstructor(record.modifiers, QualificationHelpers.createFullyQualifiedName(record.declaringQualification, record.declaringSimpleName), record.parameterNames == null ? 0 : record.parameterNames.length, record.getFullyQualifiedParameterTypeNames(), record.parameterNames, documentPath, accessRestriction);
                    }
                    return true;
                }
            };
            try {
                if (progressMonitor != null) {
                    progressMonitor.beginTask(Messages.engine_searching, 1000);
                }
                indexManager.performConcurrentJob(new PatternSearchJob(pattern, BasicSearchEngine.getDefaultSearchParticipant(), scope, searchRequestor), waitingPolicy, (IProgressMonitor)(progressMonitor == null ? null : new SubProgressMonitor(progressMonitor, 1000)));
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                if (progressMonitor != null) {
                    progressMonitor.done();
                }
                throw throwable;
            }
            {
                Object var11_14 = null;
                if (progressMonitor == null) break block17;
            }
            progressMonitor.done();
        }
        IJavaScriptUnit[] workingCopies = this.getWorkingCopies();
        int w = 0;
        while (true) {
            block18: {
                if (workingCopies == null || w >= workingCopies.length) {
                    return;
                }
                IJavaScriptUnit workingCopy = workingCopies[w];
                if (!scope.encloses(workingCopy)) break block18;
                try {
                    if (!workingCopy.isConsistent()) {
                        workingCopy.makeConsistent(progressMonitor);
                    }
                    IType[] types = workingCopy.getAllTypes();
                    int t = 0;
                    while (t < types.length) {
                        block19: {
                            ConstructorPattern wcPattern;
                            IType type = types[t];
                            char[] wcTypeQualification = null;
                            char[] wcTypeSimpleName = null;
                            char[] wcTypeFullName = type.getTypeQualifiedName().toCharArray();
                            if (type.getTypeQualifiedName() != null) {
                                char[][] wcSeperatedDeclaringType = QualificationHelpers.seperateFullyQualifedName(wcTypeFullName);
                                wcTypeQualification = wcSeperatedDeclaringType[0];
                                wcTypeSimpleName = wcSeperatedDeclaringType[1];
                            }
                            if (wcTypeSimpleName == null || !pattern.matchesDecodedKey(wcPattern = new ConstructorPattern(wcTypeQualification, wcTypeSimpleName, typeMatchRule))) break block19;
                            IFunction[] allFunctions = type.getFunctions();
                            int f = 0;
                            while (f < allFunctions.length) {
                                block20: {
                                    IFunction function = allFunctions[f];
                                    if (!function.isConstructor()) break block20;
                                    String[] wcParameterNames = function.getParameterNames();
                                    char[][] wcParameterTypes = QualificationHelpers.stringArrayToCharArray(function.getParameterTypes());
                                    int i = 0;
                                    while (true) {
                                        block21: {
                                            if (i < wcParameterTypes.length) break block21;
                                        }
                                        try {
                                            wcParameterTypes[i] = Signature.toCharArray(wcParameterTypes[i]);
                                        }
                                        catch (IllegalArgumentException illegalArgumentException) {}
                                        ++i;
                                    }
                                    requestor.acceptConstructor(function.getFlags(), wcTypeFullName, wcParameterNames == null ? 0 : wcParameterNames.length, wcParameterTypes, QualificationHelpers.stringArrayToCharArray(wcParameterNames), workingCopy.getPath().toString(), null);
                                }
                                ++f;
                            }
                        }
                        ++t;
                    }
                }
                catch (JavaScriptModelException e) {
                    Logger.logException("Error while processing working copy", (Throwable)((Object)e));
                }
            }
            ++w;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void searchAllFunctions(final IFunctionRequester functionRequester, char[] selectorPattern, char[][] declaringTypes, int selectorPatternMatchRule, IJavaScriptSearchScope scope, int waitingPolicy, IProgressMonitor progressMonitor) {
        MethodPattern searchPattern;
        block22: {
            searchPattern = new MethodPattern(true, false, selectorPattern, declaringTypes, selectorPatternMatchRule);
            final HashSet workingCopiesPaths = this.getWorkingCopiesPaths();
            IndexQueryRequestor queryRequestor = new IndexQueryRequestor(){

                public boolean acceptIndexMatch(String documentPath, SearchPattern indexRecord, SearchParticipant participant, AccessRuleSet access) {
                    if (!workingCopiesPaths.contains(documentPath)) {
                        MethodPattern record = (MethodPattern)indexRecord;
                        functionRequester.acceptFunction(record.selector, QualificationHelpers.createFullyQualifiedNames(record.parameterQualifications, record.parameterSimpleNames), record.parameterNames, record.returnQualification, record.returnSimpleName, record.getDeclaringQualification(), record.getDeclaringSimpleName(), record.modifiers, documentPath);
                    }
                    return true;
                }
            };
            IndexManager indexManager = JavaModelManager.getJavaModelManager().getIndexManager();
            try {
                if (progressMonitor != null) {
                    progressMonitor.beginTask(Messages.engine_searching, 1000);
                }
                indexManager.performConcurrentJob(new PatternSearchJob(searchPattern, BasicSearchEngine.getDefaultSearchParticipant(), scope, queryRequestor), waitingPolicy, (IProgressMonitor)(progressMonitor == null ? null : new SubProgressMonitor(progressMonitor, 1000)));
            }
            catch (Throwable throwable) {
                Object var12_14 = null;
                if (progressMonitor != null) {
                    progressMonitor.done();
                }
                throw throwable;
            }
            {
                Object var12_15 = null;
                if (progressMonitor == null) break block22;
            }
            progressMonitor.done();
        }
        IJavaScriptUnit[] workingCopies = this.getWorkingCopies();
        int workingCopyIndex = 0;
        while (workingCopies != null && workingCopyIndex < workingCopies.length) {
            IJavaScriptUnit workingCopy = workingCopies[workingCopyIndex];
            if (scope.encloses(workingCopy)) {
                try {
                    IType globalType;
                    if (!workingCopy.isConsistent()) {
                        workingCopy.makeConsistent(progressMonitor);
                    }
                    ArrayList<IFunction> allFunctions = new ArrayList<IFunction>();
                    allFunctions.addAll(Arrays.asList(workingCopy.getFunctions()));
                    IType[] types = workingCopy.getTypes();
                    if (types != null & types.length > 0 && (globalType = BasicSearchEngine.findGlobalType(workingCopy)) != null) {
                        allFunctions.addAll(Arrays.asList(globalType.getFunctions()));
                    }
                    int funcIndex = 0;
                    while (funcIndex < allFunctions.size()) {
                        IFunction function = (IFunction)allFunctions.get(funcIndex);
                        char[] wcSelector = null;
                        if (function.getElementName() != null) {
                            wcSelector = function.getElementName().toCharArray();
                        }
                        if (wcSelector != null) {
                            char[] wcDeclaringType = null;
                            if (function.getDeclaringType() != null && function.getDeclaringType().getTypeQualifiedName() != null) {
                                wcDeclaringType = function.getDeclaringType().getTypeQualifiedName().toCharArray();
                            }
                            wcDeclaringType = wcDeclaringType != null ? wcDeclaringType : IIndexConstants.GLOBAL_SYMBOL;
                            MethodPattern wcPattern = new MethodPattern(true, false, wcSelector, declaringTypes, selectorPatternMatchRule);
                            if (searchPattern.matchesDecodedKey(wcPattern)) {
                                char[][] wcParameterTypes = QualificationHelpers.stringArrayToCharArray(function.getParameterTypes());
                                int i = 0;
                                while (true) {
                                    if (i >= wcParameterTypes.length) {
                                        char[] wcReturnQualification = null;
                                        char[] wcReturnSimpleName = null;
                                        String wcReturnTypeSig = function.getReturnType();
                                        if (wcReturnTypeSig != null) {
                                            char[] wcReturnType = Signature.toString(wcReturnTypeSig).toCharArray();
                                            char[][] wcSeperatedReturnType = QualificationHelpers.seperateFullyQualifedName(wcReturnType);
                                            wcReturnQualification = wcSeperatedReturnType[0];
                                            wcReturnSimpleName = wcSeperatedReturnType[1];
                                        }
                                        char[][] wcSeperatedDeclaringType = QualificationHelpers.seperateFullyQualifedName(wcDeclaringType);
                                        functionRequester.acceptFunction(wcSelector, wcParameterTypes, QualificationHelpers.stringArrayToCharArray(function.getParameterNames()), wcReturnQualification, wcReturnSimpleName, wcSeperatedDeclaringType[0], wcSeperatedDeclaringType[1], function.getFlags(), workingCopy.getPath().toString());
                                        break;
                                    }
                                    try {
                                        wcParameterTypes[i] = Signature.toCharArray(wcParameterTypes[i]);
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {}
                                    ++i;
                                }
                            }
                        }
                        ++funcIndex;
                    }
                }
                catch (JavaScriptModelException e) {
                    Logger.logException("Error while processing working copy", (Throwable)((Object)e));
                }
            }
            ++workingCopyIndex;
        }
        return;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void searchAllVariables(final IVariableRequester variableRequester, char[] variablePattern, char[][] declaringTypes, int variablePatternMatchRule, IJavaScriptSearchScope scope, int waitingPolicy, IProgressMonitor progressMonitor) {
        FieldPattern searchPattern;
        char[][] declaringTypePatternChars;
        block20: {
            declaringTypePatternChars = null;
            if (declaringTypes != null && declaringTypes.length > 0) {
                declaringTypePatternChars = new char[declaringTypes.length][];
                int i = 0;
                while (i < declaringTypes.length) {
                    declaringTypePatternChars[i] = declaringTypes[i];
                    ++i;
                }
            }
            searchPattern = new FieldPattern(true, false, false, true, variablePattern, declaringTypePatternChars, null, null, variablePatternMatchRule, null);
            final HashSet workingCopiesPaths = this.getWorkingCopiesPaths();
            IndexQueryRequestor queryRequestor = new IndexQueryRequestor(){

                public boolean acceptIndexMatch(String documentPath, SearchPattern indexRecord, SearchParticipant participant, AccessRuleSet access) {
                    if (!workingCopiesPaths.contains(documentPath)) {
                        FieldPattern record = (FieldPattern)indexRecord;
                        variableRequester.acceptVariable(record.name, record.typeQualification, record.typeSimpleName, record.getDeclaringQualification(), record.getDeclaringSimpleName(), record.modifiers, documentPath);
                    }
                    return true;
                }
            };
            IndexManager indexManager = JavaModelManager.getJavaModelManager().getIndexManager();
            try {
                if (progressMonitor != null) {
                    progressMonitor.beginTask(Messages.engine_searching, 1000);
                }
                indexManager.performConcurrentJob(new PatternSearchJob(searchPattern, BasicSearchEngine.getDefaultSearchParticipant(), scope, queryRequestor), waitingPolicy, (IProgressMonitor)(progressMonitor == null ? null : new SubProgressMonitor(progressMonitor, 1000)));
            }
            catch (Throwable throwable) {
                Object var13_16 = null;
                if (progressMonitor != null) {
                    progressMonitor.done();
                }
                throw throwable;
            }
            {
                Object var13_17 = null;
                if (progressMonitor == null) break block20;
            }
            progressMonitor.done();
        }
        IJavaScriptUnit[] workingCopies = this.getWorkingCopies();
        int workingCopyIndex = 0;
        while (workingCopies != null && workingCopyIndex < workingCopies.length) {
            IJavaScriptUnit workingCopy = workingCopies[workingCopyIndex];
            if (scope.encloses(workingCopy)) {
                try {
                    IType globalType;
                    if (!workingCopy.isConsistent()) {
                        workingCopy.makeConsistent(progressMonitor);
                    }
                    ArrayList<IField> allFields = new ArrayList<IField>();
                    allFields.addAll(Arrays.asList(workingCopy.getFields()));
                    IType[] types = workingCopy.getTypes();
                    if (types != null & types.length > 0 && (globalType = BasicSearchEngine.findGlobalType(workingCopy)) != null) {
                        allFields.addAll(Arrays.asList(globalType.getFields()));
                    }
                    int fieldIndex = 0;
                    while (fieldIndex < allFields.size()) {
                        IField field = (IField)allFields.get(fieldIndex);
                        char[] wcName = null;
                        if (field.getElementName() != null) {
                            wcName = field.getElementName().toCharArray();
                        }
                        if (wcName != null) {
                            char[] wcDeclaringType = null;
                            if (field.getDeclaringType() != null && field.getDeclaringType().getTypeQualifiedName() != null) {
                                wcDeclaringType = field.getDeclaringType().getTypeQualifiedName().toCharArray();
                            }
                            wcDeclaringType = wcDeclaringType != null ? wcDeclaringType : IIndexConstants.GLOBAL_SYMBOL;
                            FieldPattern wcPattern = new FieldPattern(true, false, false, true, wcName, declaringTypePatternChars, null, null, variablePatternMatchRule, null);
                            if (searchPattern.matchesDecodedKey(wcPattern)) {
                                char[] wcTypeQualification = null;
                                char[] wcTypeSimpleName = null;
                                String wcTypeSig = field.getTypeSignature();
                                if (wcTypeSig != null) {
                                    char[] wcType = Signature.toString(wcTypeSig).toCharArray();
                                    char[][] wcSeperatedType = QualificationHelpers.seperateFullyQualifedName(wcType);
                                    wcTypeQualification = wcSeperatedType[0];
                                    wcTypeSimpleName = wcSeperatedType[1];
                                }
                                char[][] wcSeperatedDeclaringType = QualificationHelpers.seperateFullyQualifedName(wcDeclaringType);
                                variableRequester.acceptVariable(wcName, wcTypeQualification, wcTypeSimpleName, wcSeperatedDeclaringType[0], wcSeperatedDeclaringType[1], field.getFlags(), workingCopy.getPath().toString());
                            }
                        }
                        ++fieldIndex;
                    }
                }
                catch (JavaScriptModelException e) {
                    Logger.logException("Error while processing working copy", (Throwable)((Object)e));
                }
            }
            ++workingCopyIndex;
        }
        return;
    }

    private static IType findGlobalType(IJavaScriptUnit unit) throws JavaScriptModelException {
        IType globalType = null;
        IType[] types = unit.getTypes();
        if (types != null & types.length > 0) {
            int i = 0;
            while (i < types.length && globalType == null) {
                if (types[i].getElementName().equals(GLOBAL_TYPE_SYMBOL)) {
                    globalType = types[i];
                }
                ++i;
            }
        }
        return globalType;
    }
}

