/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.debug.ui;

import com.liferay.ide.debug.core.LiferayDebugCore;
import com.liferay.ide.debug.ui.LiferayDebugUI;
import com.liferay.ide.ui.util.SWTUtil;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.service.prefs.BackingStoreException;

public class DebugPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private ScopedPreferenceStore prefStore;
    private MyStringFieldEditor passwordEditor;
    private MyIntegerFieldEditor portEditor;

    public DebugPreferencePage() {
        super(1);
    }

    protected void createFieldEditors() {
        Group group = SWTUtil.createGroup((Composite)this.getFieldEditorParent(), (String)"FreeMarker Debugger", (int)1);
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        Composite composite = SWTUtil.createComposite((Composite)group, (int)2, (int)2, (int)768);
        this.passwordEditor = new MyStringFieldEditor("fm-debug-password", "Password:", composite);
        this.passwordEditor.setEmptyStringAllowed(false);
        this.passwordEditor.setErrorMessage("Password is invalid.");
        this.passwordEditor.setValidateStrategy(0);
        this.passwordEditor.setPreferenceStore(this.getPreferenceStore());
        this.addField((FieldEditor)this.passwordEditor);
        this.portEditor = new MyIntegerFieldEditor("fm-debug-port", "Port:", composite);
        this.portEditor.setValidRange(1025, 65535);
        this.portEditor.setEmptyStringAllowed(false);
        this.portEditor.setErrorMessage("Port value ranges from integer 1025 to 65535.");
        this.portEditor.setValidateStrategy(0);
        this.portEditor.setPreferenceStore(this.getPreferenceStore());
        this.addField((FieldEditor)this.portEditor);
    }

    public IPreferenceStore getPreferenceStore() {
        if (this.prefStore == null) {
            this.prefStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, "com.liferay.ide.debug.core");
        }
        return this.prefStore;
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        IEclipsePreferences prefs = LiferayDebugCore.getPrefs();
        prefs.remove("fm-debug-password");
        prefs.remove("fm-debug-port");
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            LiferayDebugUI.logError((Exception)((Object)e));
        }
        super.performDefaults();
    }

    public void reValidate() {
        this.passwordEditor.refreshValidState();
        if (!this.passwordEditor.isValid()) {
            return;
        }
        this.portEditor.refreshValidState();
    }

    private class MyIntegerFieldEditor
    extends IntegerFieldEditor {
        public MyIntegerFieldEditor(String name, String labelText, Composite parent) {
            super(name, labelText, parent);
        }

        public void refreshValidState() {
            super.refreshValidState();
        }

        protected void valueChanged() {
            super.valueChanged();
            if (this.isValid()) {
                DebugPreferencePage.this.reValidate();
            }
        }
    }

    private class MyStringFieldEditor
    extends StringFieldEditor {
        public MyStringFieldEditor(String name, String string, Composite composite) {
            super(name, string, composite);
        }

        public void refreshValidState() {
            super.refreshValidState();
        }

        protected void valueChanged() {
            super.valueChanged();
            if (this.isValid()) {
                DebugPreferencePage.this.reValidate();
            }
        }
    }
}

