/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.comparator;

import org.eclipse.pde.api.tools.internal.comparator.SignatureDescriptor;
import org.objectweb.asm.signature.SignatureVisitor;

final class SignatureDecoder
implements SignatureVisitor {
    static final int CLASS_BOUND = 1;
    static final int DEFAULT = 0;
    static final int INTERFACE_BOUND = 2;
    static final int SUPER_CLASS = 3;
    static final int NORMAL_TYPE_ARGUMENT = 4;
    static final int EXTENDS_TYPE_ARGUMENT = 5;
    static final int SUPER_TYPE_ARGUMENT = 6;
    int mode = 0;
    SignatureDescriptor signatureDescriptor;

    public SignatureDecoder(SignatureDescriptor signatureDescriptor) {
        this.signatureDescriptor = signatureDescriptor;
    }

    public SignatureVisitor visitArrayType() {
        return this;
    }

    public void visitBaseType(char descriptor) {
    }

    public SignatureVisitor visitClassBound() {
        this.mode = 1;
        return this;
    }

    public void visitClassType(String name) {
        String classTypeName = name.replace('/', '.');
        switch (this.mode) {
            case 1: {
                this.signatureDescriptor.setClassBound(classTypeName);
                break;
            }
            case 2: {
                this.signatureDescriptor.addInterfaceBound(classTypeName);
                break;
            }
            case 3: {
                this.signatureDescriptor.setSuperclass(classTypeName);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                this.signatureDescriptor.addTypeArgument(classTypeName);
            }
        }
        this.mode = 0;
    }

    public void visitEnd() {
    }

    public SignatureVisitor visitExceptionType() {
        return this;
    }

    public void visitFormalTypeParameter(String name) {
        this.signatureDescriptor.addTypeParameterDescriptor(name);
    }

    public void visitInnerClassType(String name) {
    }

    public SignatureVisitor visitInterface() {
        return this;
    }

    public SignatureVisitor visitInterfaceBound() {
        this.mode = 2;
        return this;
    }

    public SignatureVisitor visitParameterType() {
        return this;
    }

    public SignatureVisitor visitReturnType() {
        return this;
    }

    public SignatureVisitor visitSuperclass() {
        this.mode = 3;
        return this;
    }

    public void visitTypeArgument() {
    }

    public SignatureVisitor visitTypeArgument(char wildcard) {
        switch (wildcard) {
            case '+': {
                this.mode = 5;
                break;
            }
            case '-': {
                this.mode = 6;
                break;
            }
            case '=': {
                this.mode = 4;
            }
        }
        return this;
    }

    public void visitTypeVariable(String name) {
    }
}

