/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.web.operations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jst.j2ee.internal.common.operations.Method;
import org.eclipse.jst.j2ee.internal.web.operations.CreateWebClassTemplateModel;
import org.eclipse.jst.j2ee.internal.web.operations.IFilterMappingItem;
import org.eclipse.jst.j2ee.webapplication.DispatcherType;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateFilterTemplateModel
extends CreateWebClassTemplateModel {
    public static final String ATT_FILTER_NAME = "filterName";
    public static final String ATT_SERVLET_NAMES = "servletNames";
    public static final String ATT_DISPATCHER_TYPES = "dispatcherTypes";
    public static final int NAME = 0;
    public static final int VALUE = 1;
    public static final int DESCRIPTION = 2;

    public CreateFilterTemplateModel(IDataModel dataModel) {
        super(dataModel);
    }

    public Collection<String> getImports() {
        Collection collection = super.getImports();
        if (this.shouldGenInit()) {
            collection.add("javax.servlet.FilterConfig");
            collection.add("javax.servlet.ServletException");
        }
        if (this.shouldGenDoFilter()) {
            collection.add("javax.servlet.ServletRequest");
            collection.add("javax.servlet.ServletResponse");
            collection.add("javax.servlet.FilterChain");
            collection.add("java.io.IOException");
            collection.add("javax.servlet.ServletException");
        }
        if ("3.0".equals(this.getJavaEEVersion()) || "3.1".equals(this.getJavaEEVersion())) {
            collection.add("javax.servlet.annotation.WebFilter");
            if (this.getInitParams() != null && this.getInitParams().size() > 0) {
                collection.add("javax.servlet.annotation.WebInitParam");
            }
            if (this.hasDispatchers()) {
                collection.add("javax.servlet.DispatcherType");
            }
        }
        return collection;
    }

    public String getFilterName() {
        return super.getDisplayName();
    }

    public boolean shouldGenInit() {
        return this.implementImplementedMethod("init");
    }

    public boolean shouldGenDoFilter() {
        return this.implementImplementedMethod("doFilter");
    }

    public boolean shouldGenDestroy() {
        return this.implementImplementedMethod("destroy");
    }

    public List<String[]> getInitParams() {
        return (List)this.dataModel.getProperty("NewFilterClassDataModel.INIT_PARAM");
    }

    public String getInitParam(int index, int type) {
        List<String[]> params = this.getInitParams();
        if (index < params.size()) {
            String[] stringArray = params.get(index);
            return stringArray[type];
        }
        return null;
    }

    public List<IFilterMappingItem> getFilterMappings() {
        return (List)this.dataModel.getProperty("NewFilterClassDataModel.FILTER_MAPPINGS");
    }

    public IFilterMappingItem getFilterMapping(int index) {
        List<IFilterMappingItem> mappings = this.getFilterMappings();
        if (index < mappings.size()) {
            return mappings.get(index);
        }
        return null;
    }

    public String getDispatcherList(IFilterMappingItem mapping) {
        ArrayList<String> list = new ArrayList<String>();
        int dispatchers = mapping.getDispatchers();
        if ((dispatchers & 2) > 0) {
            list.add(DispatcherType.REQUEST_LITERAL.getLiteral());
        }
        if ((dispatchers & 4) > 0) {
            list.add(DispatcherType.FORWARD_LITERAL.getLiteral());
        }
        if ((dispatchers & 8) > 0) {
            list.add(DispatcherType.INCLUDE_LITERAL.getLiteral());
        }
        if ((dispatchers & 0x10) > 0) {
            list.add(DispatcherType.ERROR_LITERAL.getLiteral());
        }
        StringBuilder builder = new StringBuilder();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            builder.append((String)iterator.next());
            if (!iterator.hasNext()) continue;
            builder.append(",");
        }
        return builder.toString();
    }

    public List<String> getDispatcherListWeb3(IFilterMappingItem mapping) {
        ArrayList<String> list = new ArrayList<String>();
        int dispatchers = mapping.getDispatchers();
        if ((dispatchers & 2) > 0) {
            list.add("DispatcherType.REQUEST");
        }
        if ((dispatchers & 4) > 0) {
            list.add("DispatcherType.FORWARD");
        }
        if ((dispatchers & 8) > 0) {
            list.add("DispatcherType.INCLUDE");
        }
        if ((dispatchers & 0x10) > 0) {
            list.add("DispatcherType.ERROR");
        }
        return list;
    }

    protected boolean implementImplementedMethod(String methodName) {
        if (this.dataModel.getBooleanProperty("NewJavaClassDataModel.ABSTRACT_METHODS")) {
            if (methodName.equals("init")) {
                return this.dataModel.getBooleanProperty("NewFilterClassDataModel.INIT");
            }
            if (methodName.equals("doFilter")) {
                return this.dataModel.getBooleanProperty("NewFilterClassDataModel.DO_FILTER");
            }
            if (methodName.equals("destroy")) {
                return this.dataModel.getBooleanProperty("NewFilterClassDataModel.DESTROY");
            }
        }
        return false;
    }

    public Collection<Method> getUnimplementedMethods() {
        Collection unimplementedMethods = super.getUnimplementedMethods();
        Iterator iterator = unimplementedMethods.iterator();
        while (iterator.hasNext()) {
            Method method = (Method)iterator.next();
            if (!("init".equals(method.getName()) && "(Ljavax/servlet/FilterConfig;)V".equals(method.getSignature()) || "destroy".equals(method.getName()) && "()V".equals(method.getSignature())) && (!"doFilter".equals(method.getName()) || !"(Ljavax/servlet/ServletRequest;Ljavax/servlet/ServletResponse;Ljavax/servlet/FilterChain;)V".equals(method.getSignature()))) continue;
            iterator.remove();
        }
        return unimplementedMethods;
    }

    public boolean hasDispatchers() {
        List<IFilterMappingItem> filterMappings = this.getFilterMappings();
        for (IFilterMappingItem filterMapping : filterMappings) {
            if (filterMapping.getDispatchersAsString().length() <= 0) continue;
            return true;
        }
        return false;
    }

    public Map<String, Object> getClassAnnotationParams() {
        List<String[]> initParams;
        String description;
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        String dispName = this.getFilterName().trim();
        if (!dispName.equals(this.getClassName()) && dispName.length() > 0) {
            result.put(ATT_FILTER_NAME, dispName);
        }
        if ((description = this.getDescription().trim()).length() > 0) {
            result.put("description", description);
        }
        List<IFilterMappingItem> filterMappings = this.getFilterMappings();
        ArrayList<String> urlMappings = new ArrayList<String>();
        ArrayList<String> servletNames = new ArrayList<String>();
        ArrayList<String> dispatcherTypes = new ArrayList<String>();
        for (IFilterMappingItem filterMapping : filterMappings) {
            List<String> dispatcherList = this.getDispatcherListWeb3(filterMapping);
            if (dispatcherList != null && dispatcherList.size() > 0) {
                for (String disp : dispatcherList) {
                    if (dispatcherTypes.contains(disp)) continue;
                    dispatcherTypes.add(disp);
                }
            }
            if (filterMapping.isUrlPatternType()) {
                urlMappings.add(filterMapping.getName());
                continue;
            }
            if (!filterMapping.isServletNameType()) continue;
            servletNames.add(filterMapping.getName());
        }
        if (urlMappings.size() > 0) {
            result.put("urlPatterns", urlMappings);
        }
        if (dispatcherTypes.size() > 0) {
            result.put(ATT_DISPATCHER_TYPES, dispatcherTypes);
        }
        if (servletNames.size() > 0) {
            result.put(ATT_SERVLET_NAMES, servletNames);
        }
        if ((initParams = this.getInitParams()) != null && initParams.size() > 0) {
            result.put("initParams", initParams);
        }
        return result;
    }
}

