/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.jpt.common.utility.internal.BitTools;
import org.eclipse.jpt.common.utility.internal.ByteArrayTools;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.StringBuilderTools;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.common.utility.internal.predicate.CriterionPredicate;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.common.utility.transformer.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StringTools {
    public static final String CR = System.getProperty("line.separator");
    public static final String EMPTY_STRING = "";
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final Transformer<String, String> CAPITALIZER = new Capitalizer();
    public static final Transformer<String, String> UNCAPITALIZER = new Uncapitalizer();
    public static final Predicate<String> IS_NOT_BLANK = new IsNotBlank();
    public static final String EMPTY_JAVA_STRING_LITERAL = "\"\"";
    public static final Transformer<String, String> JAVA_STRING_LITERAL_TRANSFORMER = new JavaStringLiteralTransformer();
    public static final Transformer<String, String> JAVA_STRING_LITERAL_CONTENT_TRANSFORMER = new JavaStringLiteralContentTransformer();
    public static final String EMPTY_DOUBLE_QUOTED_XML_ATTRIBUTE_VALUE = "\"\"";
    public static final String EMPTY_SINGLE_QUOTED_XML_ATTRIBUTE_VALUE = "''";
    public static final String EMPTY_XML_ATTRIBUTE_VALUE = "\"\"";
    public static final String XML_ELEMENT_CDATA_START = "<![CDATA[";
    public static final String XML_ELEMENT_CDATA_END = "]]>";
    public static final String EMPTY_XML_ELEMENT_CDATA = "<![CDATA[]]>";
    public static final String XML_QUOTE = "&quot;";
    public static final String XML_AMP = "&amp;";
    public static final String XML_APOS = "&apos;";
    public static final String XML_LT = "&lt;";
    public static final String XML_GT = "&gt;";
    public static final Transformer<String, String> XML_ATTRIBUTE_VALUE_TRANSFORMER = new XmlAttributeValueTransformer();
    public static final Transformer<String, String> DOUBLE_QUOTED_XML_ATTRIBUTE_VALUE_TRANSFORMER = new DoubleQuotedXmlAttributeValueTransformer();
    public static final Transformer<String, String> XML_DOUBLE_QUOTED_ATTRIBUTE_VALUE_CONTENT_TRANSFORMER = new XmlDoubleQuotedAttributeValueContentTransformer();
    public static final Transformer<String, String> SINGLE_QUOTED_XML_ATTRIBUTE_VALUE_TRANSFORMER = new SingleQuotedXmlAttributeValueTransformer();
    public static final Transformer<String, String> XML_SINGLE_QUOTED_ATTRIBUTE_VALUE_CONTENT_TRANSFORMER = new XmlSingleQuotedAttributeValueContentTransformer();
    public static final Transformer<String, String> XML_ELEMENT_TEXT_TRANSFORMER = new XmlElementTextTransformer();
    public static final Transformer<String, String> XML_ELEMENT_CDATA_TRANSFORMER = new XmlElementCDATATransformer();
    public static final Transformer<String, String> XML_ELEMENT_CDATA_CONTENT_TRANSFORMER = new XmlElementCDATAContentTransformer();

    public static char last(String string) {
        return string.charAt(string.length() - 1);
    }

    public static String concatenate(String ... strings) {
        return strings.length != 0 ? StringTools.concatenate_(IteratorTools.iterator(strings)) : EMPTY_STRING;
    }

    public static String concatenate(Iterable<String> strings) {
        return StringTools.concatenate(strings.iterator());
    }

    public static String concatenate(Iterator<String> strings) {
        return strings.hasNext() ? StringTools.concatenate_(strings) : EMPTY_STRING;
    }

    private static String concatenate_(Iterator<String> strings) {
        StringBuilder sb = new StringBuilder();
        while (strings.hasNext()) {
            sb.append(strings.next());
        }
        return sb.toString();
    }

    public static String concatenate(String[] strings, String separator) {
        return strings.length != 0 ? StringTools.concatenate_(IteratorTools.iterator(strings), separator) : EMPTY_STRING;
    }

    public static String concatenate(Iterable<String> strings, String separator) {
        return StringTools.concatenate(strings.iterator(), separator);
    }

    public static String concatenate(Iterator<String> strings, String separator) {
        return strings.hasNext() ? StringTools.concatenate_(strings, separator) : EMPTY_STRING;
    }

    private static String concatenate_(Iterator<String> strings, String separator) {
        int separatorLength = separator.length();
        if (separatorLength == 0) {
            return StringTools.concatenate_(strings);
        }
        StringBuilder sb = new StringBuilder();
        while (strings.hasNext()) {
            sb.append(strings.next());
            sb.append(separator);
        }
        sb.setLength(sb.length() - separatorLength);
        return sb.toString();
    }

    public static String center(String string, int length) {
        return StringTools.center(string, length, ' ');
    }

    public static String center(String string, int length, char c) {
        if (length == 0) {
            return EMPTY_STRING;
        }
        int stringLength = string.length();
        if (stringLength == length) {
            return string;
        }
        if (stringLength > length) {
            int begin = stringLength - length >> 1;
            return string.substring(begin, begin + length);
        }
        char[] result = new char[length];
        int begin = length - stringLength >> 1;
        Arrays.fill(result, 0, begin, c);
        string.getChars(0, stringLength, result, begin);
        Arrays.fill(result, begin + stringLength, length, c);
        return new String(result);
    }

    public static String pad(String string, int length) {
        return StringTools.pad(string, length, ' ');
    }

    public static String pad(String string, int length, char c) {
        int stringLength = string.length();
        if (stringLength > length) {
            throw new IllegalArgumentException("String is too long: " + stringLength + " > " + length);
        }
        if (stringLength == length) {
            return string;
        }
        return StringTools.pad(string, length, c, stringLength);
    }

    public static String fit(String string, int length) {
        return StringTools.fit(string, length, ' ');
    }

    public static String fit(String string, int length, char c) {
        if (length == 0) {
            return EMPTY_STRING;
        }
        int stringLength = string.length();
        if (stringLength == length) {
            return string;
        }
        if (stringLength > length) {
            return string.substring(0, length);
        }
        return StringTools.pad(string, length, c, stringLength);
    }

    private static String pad(String string, int length, char c, int stringLength) {
        char[] result = new char[length];
        string.getChars(0, stringLength, result, 0);
        Arrays.fill(result, stringLength, length, c);
        return new String(result);
    }

    public static String zeroPad(String string, int length) {
        return StringTools.frontPad(string, length, '0');
    }

    public static String frontPad(String string, int length, char c) {
        int stringLength = string.length();
        if (stringLength > length) {
            throw new IllegalArgumentException("String is too long: " + stringLength + " > " + length);
        }
        if (stringLength == length) {
            return string;
        }
        return StringTools.frontPad(string, length, c, stringLength);
    }

    public static String zeroFit(String string, int length) {
        return StringTools.frontFit(string, length, '0');
    }

    public static String frontFit(String string, int length, char c) {
        if (length == 0) {
            return EMPTY_STRING;
        }
        int stringLength = string.length();
        if (stringLength == length) {
            return string;
        }
        if (stringLength > length) {
            return string.substring(stringLength - length);
        }
        return StringTools.frontPad(string, length, c, stringLength);
    }

    private static String frontPad(String string, int length, char c, int stringLength) {
        char[] result = new char[length];
        int padLength = length - stringLength;
        string.getChars(0, stringLength, result, padLength);
        Arrays.fill(result, 0, padLength, c);
        return new String(result);
    }

    public static String separate(String string, char separator, int segmentSize) {
        if (segmentSize <= 0) {
            throw new IllegalArgumentException("segment size must be positive: " + segmentSize);
        }
        int stringLength = string.length();
        return stringLength <= segmentSize ? string : StringTools.separate(string, separator, segmentSize, stringLength);
    }

    private static String separate(String string, char separator, int segmentSize, int stringLength) {
        int resultLen = stringLength + stringLength / segmentSize;
        if (stringLength % segmentSize == 0) {
            --resultLen;
        }
        char[] result = new char[resultLen];
        int j = 0;
        int segCount = 0;
        int i = 0;
        while (i < stringLength) {
            char c = string.charAt(i);
            if (segCount == segmentSize) {
                result[j++] = separator;
                segCount = 0;
            }
            ++segCount;
            result[j++] = c;
            ++i;
        }
        return new String(result);
    }

    public static String quote(String string) {
        return StringTools.delimit(string, '\"');
    }

    public static String delimit(String string, char delimiter) {
        int stringLength = string.length();
        StringBuilder sb = new StringBuilder(stringLength + 2);
        StringBuilderTools.delimit(sb, string, delimiter, stringLength);
        return sb.toString();
    }

    public static String delimit(String string, String delimiter) {
        return StringTools.delimit(string, delimiter, delimiter.length());
    }

    static String delimit(String string, String delimiter, int delimiterLength) {
        switch (delimiterLength) {
            case 0: {
                return string;
            }
            case 1: {
                return StringTools.delimit(string, delimiter.charAt(0));
            }
        }
        return StringTools.delimit_(string, delimiter, delimiterLength);
    }

    private static String delimit_(String string, String delimiter, int delimiterLength) {
        int stringLength = string.length();
        char[] result = new char[stringLength + 2 * delimiterLength];
        delimiter.getChars(0, delimiterLength, result, 0);
        string.getChars(0, stringLength, result, delimiterLength);
        delimiter.getChars(0, delimiterLength, result, delimiterLength + stringLength);
        return new String(result);
    }

    public static boolean isQuoted(String string) {
        return StringTools.isDelimited(string, '\"');
    }

    public static boolean isParenthetical(String string) {
        return StringTools.isDelimited(string, '(', ')');
    }

    public static boolean isBracketed(String string) {
        return StringTools.isDelimited(string, '[', ']');
    }

    public static boolean isBraced(String string) {
        return StringTools.isDelimited(string, '{', '}');
    }

    public static boolean isChevroned(String string) {
        return StringTools.isDelimited(string, '<', '>');
    }

    public static boolean isDelimited(String string, char c) {
        return StringTools.isDelimited(string, c, c);
    }

    public static boolean isDelimited(String string, char start, char end) {
        int stringLength = string.length();
        return stringLength < 2 ? false : StringTools.isDelimited(string, start, end, stringLength);
    }

    private static boolean isDelimited(String string, char start, char end, int stringLength) {
        return string.charAt(0) == start && string.charAt(stringLength - 1) == end;
    }

    public static String undelimit(String string) {
        int stringLength = string.length();
        int resultLength = stringLength - 2;
        if (resultLength < 0) {
            throw new IllegalArgumentException("invalid string: \"" + string + '\"');
        }
        if (resultLength == 0) {
            return EMPTY_STRING;
        }
        StringBuilder sb = new StringBuilder(resultLength);
        StringBuilderTools.undelimit_(sb, string, stringLength);
        return sb.toString();
    }

    public static String undelimit(String string, int count) {
        if (count == 0) {
            return string;
        }
        int resultLength = string.length() - 2 * count;
        if (resultLength < 0) {
            throw new IllegalArgumentException("invalid string: \"" + string + '\"');
        }
        if (resultLength == 0) {
            return EMPTY_STRING;
        }
        return StringTools.undelimit(string, count, resultLength);
    }

    private static String undelimit(String string, int count, int resultLength) {
        char[] result = new char[resultLength];
        string.getChars(count, count + resultLength, result, 0);
        return new String(result);
    }

    public static String removeFirstOccurrence(String string, char c) {
        int index = string.indexOf(c);
        if (index == -1) {
            return string;
        }
        if (index == 0) {
            return string.substring(1);
        }
        int stringLength = string.length();
        int last = stringLength - 1;
        if (index == last) {
            return string.substring(0, last);
        }
        StringBuilder sb = new StringBuilder(last);
        sb.append(string, 0, index);
        sb.append(string, index + 1, stringLength);
        return sb.toString();
    }

    public static String removeAllOccurrences(String string, char c) {
        int first = string.indexOf(c);
        return first == -1 ? string : StringTools.removeAllOccurrences(string, c, first);
    }

    private static String removeAllOccurrences(String string, char c, int first) {
        int stringLength = string.length();
        StringBuilder sb = new StringBuilder(stringLength);
        StringBuilderTools.removeAllOccurrences(sb, string, c, first, stringLength);
        return sb.toString();
    }

    public static String removeAllSpaces(String string) {
        return StringTools.removeAllOccurrences(string, ' ');
    }

    public static String removeAllWhitespace(String string) {
        int first = StringTools.indexOfWhitespace(string);
        return first == -1 ? string : StringTools.removeAllWhitespace(string, first);
    }

    public static int indexOfWhitespace(String string) {
        int stringLength = string.length();
        int i = 0;
        while (i < stringLength) {
            if (Character.isWhitespace(string.charAt(i))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static String removeAllWhitespace(String string, int first) {
        int stringLength = string.length();
        StringBuilder sb = new StringBuilder(stringLength);
        StringBuilderTools.removeAllWhitespace(sb, string, first, stringLength);
        return sb.toString();
    }

    public static String compressWhitespace(String string) {
        int first = StringTools.indexOfWhitespace(string);
        return first == -1 ? string : new String(StringTools.compressWhitespace(string, first));
    }

    private static String compressWhitespace(String string, int first) {
        int stringLength = string.length();
        StringBuilder sb = new StringBuilder(stringLength);
        StringBuilderTools.compressWhitespace(sb, string, first, stringLength);
        return sb.toString();
    }

    public static int commonPrefixLength(String s1, String s2) {
        return StringTools.commonPrefixLength(s1, s2, Math.min(s1.length(), s2.length()));
    }

    public static int commonPrefixLength(String s1, String s2, int max) {
        int i = 0;
        while (i < max) {
            if (s1.charAt(i) != s2.charAt(i)) {
                return i;
            }
            ++i;
        }
        return max;
    }

    public static String capitalize(String string) {
        int stringLength = string.length();
        return stringLength == 0 || Character.isUpperCase(string.charAt(0)) ? string : StringTools.capitalize(string, stringLength);
    }

    private static String capitalize(String string, int stringLength) {
        char[] result = new char[stringLength];
        result[0] = Character.toUpperCase(string.charAt(0));
        string.getChars(1, stringLength, result, 1);
        return new String(result);
    }

    public static String uncapitalize(String string) {
        int stringLength = string.length();
        return StringTools.needNotBeUncapitalized(string, stringLength) ? string : StringTools.uncapitalize(string, stringLength);
    }

    public static boolean needNotBeUncapitalized(String string, int stringLength) {
        if (stringLength == 0) {
            return true;
        }
        if (Character.isLowerCase(string.charAt(0))) {
            return true;
        }
        return stringLength > 1 && Character.isUpperCase(string.charAt(1)) && Character.isUpperCase(string.charAt(0));
    }

    private static String uncapitalize(String string, int stringLength) {
        char[] result = new char[stringLength];
        result[0] = Character.toLowerCase(string.charAt(0));
        string.getChars(1, stringLength, result, 1);
        return new String(result);
    }

    public static boolean isBlank(String string) {
        if (string == null) {
            return true;
        }
        int stringLength = string.length();
        if (stringLength == 0) {
            return true;
        }
        return StringTools.isBlank(string, stringLength);
    }

    private static boolean isBlank(String string, int stringLength) {
        int i = stringLength;
        while (i-- > 0) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(String string) {
        return !StringTools.isBlank(string);
    }

    public static boolean equalsIgnoreCase(String s1, String s2) {
        return s1 == null ? s2 == null : s1.equalsIgnoreCase(s2);
    }

    public static boolean startsWithIgnoreCase(String string, String prefix) {
        return string.regionMatches(true, 0, prefix, 0, prefix.length());
    }

    public static boolean isUppercase(String string) {
        return string.length() != 0 && StringTools.isUppercase_(string);
    }

    static boolean isUppercase_(String string) {
        return string.equals(string.toUpperCase());
    }

    public static boolean isLowercase(String string) {
        return string.length() != 0 && StringTools.isLowercase_(string);
    }

    static boolean isLowercase_(String string) {
        return string.equals(string.toLowerCase());
    }

    public static byte[] convertHexStringToByteArray(String hexString) {
        int hexStringLength = hexString.length();
        if (hexStringLength == 0) {
            return ByteArrayTools.EMPTY_BYTE_ARRAY;
        }
        if (BitTools.isOdd(hexStringLength)) {
            throw new IllegalArgumentException("Odd-sized hexadecimal string: " + hexString + " (" + hexStringLength + " characters)");
        }
        return StringTools.convertHexStringToByteArray(hexString, hexStringLength);
    }

    private static byte[] convertHexStringToByteArray(String hexString, int hexStringLength) {
        byte[] bytes = new byte[BitTools.half(hexStringLength)];
        int bi = bytes.length - 1;
        int si = hexStringLength - 2;
        while (bi >= 0) {
            byte digit1 = (byte)Character.digit(hexString.charAt(si), 16);
            if (digit1 == -1) {
                throw new IllegalArgumentException(StringTools.buildIllegalHexCharMessage(hexString, si));
            }
            byte digit2 = (byte)Character.digit(hexString.charAt(si + 1), 16);
            if (digit2 == -1) {
                throw new IllegalArgumentException(StringTools.buildIllegalHexCharMessage(hexString, si + 1));
            }
            bytes[bi] = (byte)((digit1 << 4) + digit2);
            --bi;
            si -= 2;
        }
        return bytes;
    }

    static String buildIllegalHexCharMessage(String hexString, int index) {
        StringBuilder sb = new StringBuilder(hexString.length() + 40);
        sb.append("Illegal hexadecimal character: ");
        sb.append(hexString, 0, index);
        sb.append('[');
        sb.append(hexString.charAt(index));
        sb.append(']');
        sb.append(hexString, index + 1, hexString.length());
        return sb.toString();
    }

    public static String convertCamelCaseToAllCaps(String camelCaseString) {
        int stringLength = camelCaseString.length();
        return stringLength == 0 ? camelCaseString : StringTools.convertCamelCaseToAllCaps_(camelCaseString, stringLength);
    }

    private static String convertCamelCaseToAllCaps_(String camelCaseString, int stringLength) {
        StringBuilder sb = new StringBuilder(stringLength + stringLength / 4);
        StringBuilderTools.convertCamelCaseToAllCaps_(sb, camelCaseString, stringLength);
        return sb.toString();
    }

    public static String convertCamelCaseToAllCaps(String camelCaseString, int maxLength) {
        if (maxLength == 0) {
            return EMPTY_STRING;
        }
        int stringLength = camelCaseString.length();
        return stringLength == 0 ? camelCaseString : StringTools.convertCamelCaseToAllCaps(camelCaseString, maxLength, stringLength);
    }

    private static String convertCamelCaseToAllCaps(String camelCaseString, int maxLength, int stringLength) {
        StringBuilder sb = new StringBuilder(maxLength);
        StringBuilderTools.convertCamelCaseToAllCaps(sb, camelCaseString, maxLength, stringLength);
        return sb.toString();
    }

    public static boolean camelCaseWordBreak(char prev, char c, char next) {
        if (prev == '\u0000') {
            return false;
        }
        if (Character.isLowerCase(c)) {
            return false;
        }
        if (Character.isLowerCase(prev)) {
            return true;
        }
        if (next == '\u0000') {
            return false;
        }
        return Character.isLowerCase(next);
    }

    public static String convertAllCapsToCamelCase(String allCapsString) {
        return StringTools.convertAllCapsToCamelCase(allCapsString, true);
    }

    public static String convertAllCapsToCamelCase(String allCapsString, boolean capitalizeFirstLetter) {
        int stringLength = allCapsString.length();
        return stringLength == 0 ? allCapsString : StringTools.convertAllCapsToCamelCase(allCapsString, capitalizeFirstLetter, stringLength);
    }

    private static String convertAllCapsToCamelCase(String allCapsString, boolean capitalizeFirstLetter, int stringLength) {
        StringBuilder sb = new StringBuilder(stringLength);
        StringBuilderTools.convertAllCapsToCamelCase(sb, allCapsString, capitalizeFirstLetter, stringLength);
        return sb.toString();
    }

    public static String convertToJavaStringLiteral(String string) {
        int stringLength = string.length();
        if (stringLength == 0) {
            return "\"\"";
        }
        StringBuilder sb = new StringBuilder(stringLength + 6);
        StringBuilderTools.convertToJavaStringLiteral(sb, string, stringLength);
        return sb.toString();
    }

    public static String convertToJavaStringLiteralContent(String string) {
        int stringLength = string.length();
        if (stringLength == 0) {
            return EMPTY_STRING;
        }
        StringBuilder sb = new StringBuilder(stringLength + 6);
        StringBuilderTools.convertToJavaStringLiteralContent(sb, string, stringLength);
        return sb.toString();
    }

    public static String convertToXmlAttributeValue(String string) {
        int stringLength = string.length();
        if (stringLength == 0) {
            return "\"\"";
        }
        StringBuilder sb = new StringBuilder(stringLength + 12);
        StringBuilderTools.convertToXmlAttributeValue(sb, string, stringLength);
        return sb.toString();
    }

    public static String convertToDoubleQuotedXmlAttributeValue(String string) {
        int stringLength = string.length();
        if (stringLength == 0) {
            return "\"\"";
        }
        StringBuilder sb = new StringBuilder(stringLength + 12);
        StringBuilderTools.convertToDoubleQuotedXmlAttributeValue(sb, string, stringLength);
        return sb.toString();
    }

    public static String convertToDoubleQuotedXmlAttributeValueContent(String string) {
        int stringLength = string.length();
        if (stringLength == 0) {
            return EMPTY_STRING;
        }
        StringBuilder sb = new StringBuilder(stringLength + 10);
        StringBuilderTools.convertToDoubleQuotedXmlAttributeValueContent(sb, string, stringLength);
        return sb.toString();
    }

    public static String convertToSingleQuotedXmlAttributeValue(String string) {
        int stringLength = string.length();
        if (stringLength == 0) {
            return EMPTY_SINGLE_QUOTED_XML_ATTRIBUTE_VALUE;
        }
        StringBuilder sb = new StringBuilder(stringLength + 12);
        StringBuilderTools.convertToSingleQuotedXmlAttributeValue(sb, string, stringLength);
        return sb.toString();
    }

    public static String convertToSingleQuotedXmlAttributeValueContent(String string) {
        int stringLength = string.length();
        if (stringLength == 0) {
            return EMPTY_STRING;
        }
        StringBuilder sb = new StringBuilder(stringLength + 10);
        StringBuilderTools.convertToSingleQuotedXmlAttributeValueContent(sb, string, stringLength);
        return sb.toString();
    }

    public static String convertToXmlElementText(String string) {
        int stringLength = string.length();
        if (stringLength == 0) {
            return string;
        }
        StringBuilder sb = new StringBuilder(stringLength + 8);
        StringBuilderTools.convertToXmlElementText(sb, string, stringLength);
        return sb.toString();
    }

    public static String convertToXmlElementCDATA(String string) {
        int stringLength = string.length();
        if (stringLength == 0) {
            return EMPTY_XML_ELEMENT_CDATA;
        }
        StringBuilder sb = new StringBuilder(stringLength + EMPTY_XML_ELEMENT_CDATA.length() + 6);
        StringBuilderTools.convertToXmlElementCDATA(sb, string, stringLength);
        return sb.toString();
    }

    public static String convertToXmlElementCDATAContent(String string) {
        int stringLength = string.length();
        if (stringLength == 0) {
            return EMPTY_STRING;
        }
        StringBuilder sb = new StringBuilder(stringLength + 6);
        StringBuilderTools.convertToXmlElementCDATAContent(sb, string, stringLength);
        return sb.toString();
    }

    private StringTools() {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Capitalizer
    implements Transformer<String, String>,
    Serializable {
        private static final long serialVersionUID = 1L;

        Capitalizer() {
        }

        @Override
        public String transform(String string) {
            return StringTools.capitalize(string);
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }

        private Object readResolve() {
            return CAPITALIZER;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CharDelimiter
    implements Transformer<String, String> {
        private final char delimiter;

        public CharDelimiter(char delimiter) {
            this.delimiter = delimiter;
        }

        @Override
        public String transform(String string) {
            return StringTools.delimit(string, this.delimiter);
        }

        public String toString() {
            return ObjectTools.toString((Object)this, this.delimiter);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DoubleQuotedXmlAttributeValueTransformer
    implements Transformer<String, String>,
    Serializable {
        private static final long serialVersionUID = 1L;

        DoubleQuotedXmlAttributeValueTransformer() {
        }

        @Override
        public String transform(String string) {
            return StringTools.convertToDoubleQuotedXmlAttributeValue(string);
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }

        private Object readResolve() {
            return DOUBLE_QUOTED_XML_ATTRIBUTE_VALUE_TRANSFORMER;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class IsNotBlank
    implements Predicate<String>,
    Serializable {
        private static final long serialVersionUID = 1L;

        IsNotBlank() {
        }

        @Override
        public boolean evaluate(String string) {
            return StringTools.isNotBlank(string);
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }

        private Object readResolve() {
            return IS_NOT_BLANK;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class JavaStringLiteralContentTransformer
    implements Transformer<String, String>,
    Serializable {
        private static final long serialVersionUID = 1L;

        JavaStringLiteralContentTransformer() {
        }

        @Override
        public String transform(String string) {
            return StringTools.convertToJavaStringLiteralContent(string);
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }

        private Object readResolve() {
            return JAVA_STRING_LITERAL_CONTENT_TRANSFORMER;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class JavaStringLiteralTransformer
    implements Transformer<String, String>,
    Serializable {
        private static final long serialVersionUID = 1L;

        JavaStringLiteralTransformer() {
        }

        @Override
        public String transform(String string) {
            return StringTools.convertToJavaStringLiteral(string);
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }

        private Object readResolve() {
            return JAVA_STRING_LITERAL_TRANSFORMER;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SingleQuotedXmlAttributeValueTransformer
    implements Transformer<String, String>,
    Serializable {
        private static final long serialVersionUID = 1L;

        SingleQuotedXmlAttributeValueTransformer() {
        }

        @Override
        public String transform(String string) {
            return StringTools.convertToSingleQuotedXmlAttributeValue(string);
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }

        private Object readResolve() {
            return SINGLE_QUOTED_XML_ATTRIBUTE_VALUE_TRANSFORMER;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StartsWithIgnoreCase
    extends CriterionPredicate<String, String> {
        public StartsWithIgnoreCase(String prefix) {
            super(prefix);
        }

        @Override
        public boolean evaluate(String string) {
            return StringTools.startsWithIgnoreCase(string, (String)this.criterion);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StringDelimiter
    implements Transformer<String, String> {
        private final String delimiter;
        private final int delimiterLength;

        public StringDelimiter(String delimiter) {
            this.delimiter = delimiter;
            this.delimiterLength = delimiter.length();
        }

        @Override
        public String transform(String string) {
            return StringTools.delimit(string, this.delimiter, this.delimiterLength);
        }

        public String toString() {
            return ObjectTools.toString((Object)this, this.delimiter);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Uncapitalizer
    implements Transformer<String, String>,
    Serializable {
        private static final long serialVersionUID = 1L;

        Uncapitalizer() {
        }

        @Override
        public String transform(String string) {
            return StringTools.uncapitalize(string);
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }

        private Object readResolve() {
            return UNCAPITALIZER;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class XmlAttributeValueTransformer
    implements Transformer<String, String>,
    Serializable {
        private static final long serialVersionUID = 1L;

        XmlAttributeValueTransformer() {
        }

        @Override
        public String transform(String string) {
            return StringTools.convertToXmlAttributeValue(string);
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }

        private Object readResolve() {
            return XML_ATTRIBUTE_VALUE_TRANSFORMER;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class XmlDoubleQuotedAttributeValueContentTransformer
    implements Transformer<String, String>,
    Serializable {
        private static final long serialVersionUID = 1L;

        XmlDoubleQuotedAttributeValueContentTransformer() {
        }

        @Override
        public String transform(String string) {
            return StringTools.convertToDoubleQuotedXmlAttributeValueContent(string);
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }

        private Object readResolve() {
            return XML_DOUBLE_QUOTED_ATTRIBUTE_VALUE_CONTENT_TRANSFORMER;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class XmlElementCDATAContentTransformer
    implements Transformer<String, String>,
    Serializable {
        private static final long serialVersionUID = 1L;

        XmlElementCDATAContentTransformer() {
        }

        @Override
        public String transform(String string) {
            return StringTools.convertToXmlElementCDATAContent(string);
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }

        private Object readResolve() {
            return XML_ELEMENT_CDATA_CONTENT_TRANSFORMER;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class XmlElementCDATATransformer
    implements Transformer<String, String>,
    Serializable {
        private static final long serialVersionUID = 1L;

        XmlElementCDATATransformer() {
        }

        @Override
        public String transform(String string) {
            return StringTools.convertToXmlElementCDATA(string);
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }

        private Object readResolve() {
            return XML_ELEMENT_CDATA_TRANSFORMER;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class XmlElementTextTransformer
    implements Transformer<String, String>,
    Serializable {
        private static final long serialVersionUID = 1L;

        XmlElementTextTransformer() {
        }

        @Override
        public String transform(String string) {
            return StringTools.convertToXmlElementText(string);
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }

        private Object readResolve() {
            return XML_ELEMENT_TEXT_TRANSFORMER;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class XmlSingleQuotedAttributeValueContentTransformer
    implements Transformer<String, String>,
    Serializable {
        private static final long serialVersionUID = 1L;

        XmlSingleQuotedAttributeValueContentTransformer() {
        }

        @Override
        public String transform(String string) {
            return StringTools.convertToSingleQuotedXmlAttributeValueContent(string);
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }

        private Object readResolve() {
            return XML_SINGLE_QUOTED_ATTRIBUTE_VALUE_CONTENT_TRANSFORMER;
        }
    }
}

