/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.iterator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jpt.common.utility.ExceptionHandler;
import org.eclipse.jpt.common.utility.collection.Queue;
import org.eclipse.jpt.common.utility.collection.Stack;
import org.eclipse.jpt.common.utility.command.InterruptibleParameterizedCommand;
import org.eclipse.jpt.common.utility.command.ParameterizedCommand;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.collection.CollectionTools;
import org.eclipse.jpt.common.utility.internal.collection.HashBag;
import org.eclipse.jpt.common.utility.internal.collection.ListTools;
import org.eclipse.jpt.common.utility.internal.command.DisabledParameterizedCommand;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterator.ArrayIterator;
import org.eclipse.jpt.common.utility.internal.iterator.ArrayListIterator;
import org.eclipse.jpt.common.utility.internal.iterator.ChainIterator;
import org.eclipse.jpt.common.utility.internal.iterator.CloneIterator;
import org.eclipse.jpt.common.utility.internal.iterator.CloneListIterator;
import org.eclipse.jpt.common.utility.internal.iterator.CompositeIterator;
import org.eclipse.jpt.common.utility.internal.iterator.CompositeListIterator;
import org.eclipse.jpt.common.utility.internal.iterator.EmptyIterator;
import org.eclipse.jpt.common.utility.internal.iterator.EmptyListIterator;
import org.eclipse.jpt.common.utility.internal.iterator.EnumerationIterator;
import org.eclipse.jpt.common.utility.internal.iterator.FilteringIterator;
import org.eclipse.jpt.common.utility.internal.iterator.GraphIterator;
import org.eclipse.jpt.common.utility.internal.iterator.LateralIteratorWrapper;
import org.eclipse.jpt.common.utility.internal.iterator.LateralListIteratorWrapper;
import org.eclipse.jpt.common.utility.internal.iterator.NullElementIterator;
import org.eclipse.jpt.common.utility.internal.iterator.NullElementListIterator;
import org.eclipse.jpt.common.utility.internal.iterator.PeekableIterator;
import org.eclipse.jpt.common.utility.internal.iterator.QueueIterator;
import org.eclipse.jpt.common.utility.internal.iterator.ReadOnlyCompositeListIterator;
import org.eclipse.jpt.common.utility.internal.iterator.ReadOnlyIterator;
import org.eclipse.jpt.common.utility.internal.iterator.ReadOnlyListIterator;
import org.eclipse.jpt.common.utility.internal.iterator.RepeatingElementIterator;
import org.eclipse.jpt.common.utility.internal.iterator.RepeatingElementListIterator;
import org.eclipse.jpt.common.utility.internal.iterator.ReverseIterator;
import org.eclipse.jpt.common.utility.internal.iterator.SimultaneousIterator;
import org.eclipse.jpt.common.utility.internal.iterator.SimultaneousListIterator;
import org.eclipse.jpt.common.utility.internal.iterator.SingleElementIterator;
import org.eclipse.jpt.common.utility.internal.iterator.SingleElementListIterator;
import org.eclipse.jpt.common.utility.internal.iterator.StackIterator;
import org.eclipse.jpt.common.utility.internal.iterator.SubIteratorWrapper;
import org.eclipse.jpt.common.utility.internal.iterator.SubListIteratorWrapper;
import org.eclipse.jpt.common.utility.internal.iterator.SuperIteratorWrapper;
import org.eclipse.jpt.common.utility.internal.iterator.SuperListIteratorWrapper;
import org.eclipse.jpt.common.utility.internal.iterator.SynchronizedIterator;
import org.eclipse.jpt.common.utility.internal.iterator.SynchronizedListIterator;
import org.eclipse.jpt.common.utility.internal.iterator.TransformationIterator;
import org.eclipse.jpt.common.utility.internal.iterator.TransformationListIterator;
import org.eclipse.jpt.common.utility.internal.iterator.TreeIterator;
import org.eclipse.jpt.common.utility.internal.predicate.PredicateTools;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.common.utility.transformer.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IteratorTools {
    public static <E> HashBag<E> bag(Iterator<? extends E> iterator) {
        return CollectionTools.bag(iterator);
    }

    public static <E> HashBag<E> bag(Iterator<? extends E> iterator, int iteratorSize) {
        return CollectionTools.bag(iterator, iteratorSize);
    }

    public static <E> HashBag<E> collection(Iterator<? extends E> iterator) {
        return CollectionTools.collection(iterator);
    }

    public static <E> HashBag<E> collection(Iterator<? extends E> iterator, int iteratorSize) {
        return CollectionTools.collection(iterator, iteratorSize);
    }

    /*
     * Unable to fully structure code
     */
    public static boolean contains(Iterator<?> iterator, Object value) {
        block2: {
            if (value != null) ** GOTO lbl8
            while (iterator.hasNext()) {
                if (iterator.next() != null) continue;
                return true;
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                if (!value.equals(iterator.next())) continue;
                return true;
lbl8:
                // 2 sources

                ** while (iterator.hasNext())
            }
        }
        return false;
    }

    public static boolean containsAll(Iterator<?> iterator, Collection<?> collection) {
        return CollectionTools.set(iterator).containsAll(collection);
    }

    public static boolean containsAll(Iterator<?> iterator, int iteratorSize, Collection<?> collection) {
        return CollectionTools.set(iterator, iteratorSize).containsAll(collection);
    }

    public static boolean containsAll(Iterator<?> iterator, Iterable<?> iterable) {
        return CollectionTools.containsAll(CollectionTools.set(iterator), iterable);
    }

    public static boolean containsAll(Iterator<?> iterator, int iteratorSize, Iterable<?> iterable) {
        return CollectionTools.containsAll(CollectionTools.set(iterator, iteratorSize), iterable);
    }

    public static boolean containsAll(Iterator<?> iterator1, Iterator<?> iterator2) {
        return CollectionTools.containsAll(CollectionTools.set(iterator1), iterator2);
    }

    public static boolean containsAll(Iterator<?> iterator1, int iterator1Size, Iterator<?> iterator2) {
        return CollectionTools.containsAll(CollectionTools.set(iterator1, iterator1Size), iterator2);
    }

    public static boolean containsAll(Iterator<?> iterator, Object ... array) {
        return CollectionTools.containsAll(CollectionTools.set(iterator), array);
    }

    public static boolean containsAll(Iterator<?> iterator, int iteratorSize, Object ... array) {
        return CollectionTools.containsAll(CollectionTools.set(iterator, iteratorSize), array);
    }

    public static boolean elementsAreDifferent(Iterator<?> iterator1, Iterator<?> iterator2) {
        return !IteratorTools.elementsAreEqual(iterator1, iterator2);
    }

    public static boolean elementsAreEqual(Iterator<?> iterator1, Iterator<?> iterator2) {
        while (iterator1.hasNext() && iterator2.hasNext()) {
            if (!ObjectTools.notEquals(iterator1.next(), iterator2.next())) continue;
            return false;
        }
        return !iterator1.hasNext() && !iterator2.hasNext();
    }

    public static boolean elementsAreIdentical(Iterator<?> iterator1, Iterator<?> iterator2) {
        while (iterator1.hasNext() && iterator2.hasNext()) {
            if (iterator1.next() == iterator2.next()) continue;
            return false;
        }
        return !iterator1.hasNext() && !iterator2.hasNext();
    }

    public static boolean elementsAreNotIdentical(Iterator<?> iterator1, Iterator<?> iterator2) {
        return !IteratorTools.elementsAreIdentical(iterator1, iterator2);
    }

    public static <E> void execute(Iterator<? extends E> iterator, ParameterizedCommand<E> command) {
        while (iterator.hasNext()) {
            command.execute(iterator.next());
        }
    }

    public static <E> void execute(Iterator<? extends E> iterator, ParameterizedCommand<E> command, ExceptionHandler exceptionHandler) {
        while (iterator.hasNext()) {
            try {
                command.execute(iterator.next());
            }
            catch (Throwable ex) {
                exceptionHandler.handleException(ex);
            }
        }
    }

    public static <E> void execute(Iterator<? extends E> iterator, InterruptibleParameterizedCommand<E> command) throws InterruptedException {
        while (iterator.hasNext()) {
            command.execute(iterator.next());
        }
    }

    public static <E> void execute(Iterator<? extends E> iterator, InterruptibleParameterizedCommand<E> command, ExceptionHandler exceptionHandler) throws InterruptedException {
        while (iterator.hasNext()) {
            try {
                command.execute(iterator.next());
            }
            catch (InterruptedException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                exceptionHandler.handleException(ex);
            }
        }
    }

    public static <E> E get(Iterator<? extends E> iterator, int index) {
        int i = 0;
        while (iterator.hasNext()) {
            E next = iterator.next();
            if (i++ != index) continue;
            return next;
        }
        throw new IndexOutOfBoundsException(String.valueOf(String.valueOf(index)) + ':' + String.valueOf(i));
    }

    public static int hashCode(Iterator<?> iterator) {
        int hash = 1;
        while (iterator.hasNext()) {
            Object next = iterator.next();
            hash = 31 * hash + (next == null ? 0 : next.hashCode());
        }
        return hash;
    }

    public static int indexOf(Iterator<?> iterator, Object value) {
        if (value == null) {
            int i = 0;
            while (iterator.hasNext()) {
                if (iterator.next() == null) {
                    return i;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (iterator.hasNext()) {
                if (value.equals(iterator.next())) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public static int lastIndexOf(Iterator<?> iterator, Object value) {
        int last = -1;
        if (value == null) {
            int i = 0;
            while (iterator.hasNext()) {
                if (iterator.next() == null) {
                    last = i;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (iterator.hasNext()) {
                if (value.equals(iterator.next())) {
                    last = i;
                }
                ++i;
            }
        }
        return last;
    }

    public static <E> E last(Iterator<E> iterator) {
        E last;
        do {
            last = iterator.next();
        } while (iterator.hasNext());
        return last;
    }

    public static <E> ArrayList<E> list(Iterator<? extends E> iterator) {
        return ListTools.list(iterator);
    }

    public static <E> ArrayList<E> list(Iterator<? extends E> iterator, int iteratorSize) {
        return ListTools.list(iterator, iteratorSize);
    }

    public static int size(Iterator<?> iterator) {
        int size = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++size;
        }
        return size;
    }

    public static boolean isEmpty(Iterator<?> iterator) {
        return !iterator.hasNext();
    }

    public static boolean isNotEmpty(Iterator<?> iterator) {
        return iterator.hasNext();
    }

    public static <E extends Comparable<? super E>> ListIterator<E> sort(Iterator<? extends E> iterator) {
        return IteratorTools.sort(iterator, null);
    }

    public static <E extends Comparable<? super E>> ListIterator<E> sort(Iterator<? extends E> iterator, int iteratorSize) {
        return IteratorTools.sort(iterator, null, iteratorSize);
    }

    public static <E> ListIterator<E> sort(Iterator<? extends E> iterator, Comparator<? super E> comparator) {
        return ListTools.sort(ListTools.list(iterator), comparator).listIterator();
    }

    public static <E> ListIterator<E> sort(Iterator<? extends E> iterator, Comparator<? super E> comparator, int iteratorSize) {
        return ListTools.sort(ListTools.list(iterator, iteratorSize), comparator).listIterator();
    }

    public static Object[] toArray(Iterator<?> iterator) {
        return IteratorTools.list(iterator).toArray();
    }

    public static Object[] toArray(Iterator<?> iterator, int iteratorSize) {
        return IteratorTools.list(iterator, iteratorSize).toArray();
    }

    public static <E> E[] toArray(Iterator<? extends E> iterator, E[] array) {
        return IteratorTools.list(iterator).toArray(array);
    }

    public static <E> E[] toArray(Iterator<? extends E> iterator, int iteratorSize, E[] array) {
        return IteratorTools.list(iterator, iteratorSize).toArray(array);
    }

    public static <E, I extends Iterator<? extends E>> SimultaneousIterator<E> align(I ... iterators) {
        return IteratorTools.align(IterableTools.iterable(iterators), iterators.length);
    }

    public static <E, I extends Iterator<? extends E>> SimultaneousIterator<E> align(Iterable<I> iterables) {
        return new SimultaneousIterator(iterables);
    }

    public static <E, I extends Iterator<? extends E>> SimultaneousIterator<E> align(Iterable<I> iterables, int iterablesSize) {
        return new SimultaneousIterator(iterables, iterablesSize);
    }

    public static <E, I extends ListIterator<E>> SimultaneousListIterator<E> alignList(I ... iterators) {
        return IteratorTools.alignList(IterableTools.listIterable(iterators), iterators.length);
    }

    public static <E, I extends ListIterator<E>> SimultaneousListIterator<E> alignList(Iterable<I> iterables) {
        return new SimultaneousListIterator(iterables);
    }

    public static <E, I extends ListIterator<E>> SimultaneousListIterator<E> alignList(Iterable<I> iterators, int iteratorsSize) {
        return new SimultaneousListIterator(iterators, iteratorsSize);
    }

    public static <E1, E2> LateralIteratorWrapper<E1, E2> cast(Iterator<E1> iterator) {
        return new LateralIteratorWrapper(iterator);
    }

    public static <E1, E2> LateralListIteratorWrapper<E1, E2> cast(ListIterator<E1> iterator) {
        return new LateralListIteratorWrapper(iterator);
    }

    public static <E1, E2 extends E1> SubIteratorWrapper<E1, E2> downCast(Iterator<E1> iterator) {
        return new SubIteratorWrapper(iterator);
    }

    public static <E1, E2 extends E1> SubListIteratorWrapper<E1, E2> downCast(ListIterator<E1> iterator) {
        return new SubListIteratorWrapper(iterator);
    }

    public static <E> Iterator<E> upCast(Iterator<? extends E> iterator) {
        return new SuperIteratorWrapper<E>(iterator);
    }

    public static <E> ListIterator<E> upCast(ListIterator<? extends E> iterator) {
        return new SuperListIteratorWrapper<E>(iterator);
    }

    public static <E> ChainIterator<E> chainIterator(E first, Transformer<? super E, ? extends E> transformer) {
        return new ChainIterator<E>(first, transformer);
    }

    public static <E> CloneIterator<E> clone(Collection<? extends E> collection) {
        return IteratorTools.clone(collection, DisabledParameterizedCommand.instance());
    }

    public static <E> CloneIterator<E> clone(Collection<? extends E> collection, ParameterizedCommand<? super E> removeCommand) {
        return new CloneIterator<E>(collection, removeCommand);
    }

    public static <E> CloneListIterator<E> clone(List<? extends E> list) {
        return IteratorTools.clone(list, CloneListIterator.Adapter.ReadOnly.instance());
    }

    public static <E> CloneListIterator<E> clone(List<? extends E> list, CloneListIterator.Adapter<E> adapter) {
        return new CloneListIterator<E>(list, adapter);
    }

    public static <E> CompositeIterator<E> add(Iterator<? extends E> iterator, E object) {
        return IteratorTools.concatenate(iterator, IteratorTools.singletonIterator(object));
    }

    public static <E> CompositeIterator<E> insert(E object, Iterator<? extends E> iterator) {
        return IteratorTools.concatenate(IteratorTools.singletonIterator(object), iterator);
    }

    public static <E> CompositeIterator<E> concatenate(Iterator<? extends E> ... iterators) {
        return IteratorTools.concatenate(IteratorTools.iterator(iterators));
    }

    public static <E> CompositeIterator<E> concatenate(Iterator<? extends Iterator<? extends E>> iterators) {
        return new CompositeIterator(iterators);
    }

    public static <P, E> CompositeIterator<E> children(Iterator<? extends P> parents, Transformer<? super P, ? extends Iterator<? extends E>> childrenTransformer) {
        return IteratorTools.concatenate(IteratorTools.transform(parents, childrenTransformer));
    }

    public static <E> CompositeListIterator<E> add(ListIterator<E> iterator, E object) {
        return IteratorTools.concatenate(new ListIterator[]{iterator, IteratorTools.singletonListIterator(object)});
    }

    public static <E> CompositeListIterator<E> insert(E object, ListIterator<E> iterator) {
        return IteratorTools.concatenate(new ListIterator[]{IteratorTools.singletonListIterator(object), iterator});
    }

    public static <E> CompositeListIterator<E> concatenate(ListIterator<E> ... iterators) {
        return IteratorTools.concatenate(IteratorTools.listIterator(iterators));
    }

    public static <E> CompositeListIterator<E> concatenate(ListIterator<? extends ListIterator<E>> iterators) {
        return new CompositeListIterator(iterators);
    }

    public static <P, E> CompositeListIterator<E> children(ListIterator<? extends P> parents, Transformer<? super P, ? extends ListIterator<E>> childrenTransformer) {
        return IteratorTools.concatenate(IteratorTools.transform(parents, childrenTransformer));
    }

    public static <E> ReadOnlyCompositeListIterator<E> addReadOnly(ListIterator<? extends E> iterator, E object) {
        return IteratorTools.concatenateReadOnly(iterator, IteratorTools.singletonListIterator(object));
    }

    public static <E> ReadOnlyCompositeListIterator<E> insertReadOnly(E object, ListIterator<? extends E> iterator) {
        return IteratorTools.concatenateReadOnly(IteratorTools.singletonListIterator(object), iterator);
    }

    public static <E> ReadOnlyCompositeListIterator<E> concatenateReadOnly(ListIterator<? extends E> ... iterators) {
        return IteratorTools.concatenateReadOnly(IteratorTools.listIterator(iterators));
    }

    public static <E> ReadOnlyCompositeListIterator<E> concatenateReadOnly(ListIterator<? extends ListIterator<? extends E>> iterators) {
        return new ReadOnlyCompositeListIterator(iterators);
    }

    public static <P, E> ReadOnlyCompositeListIterator<E> readOnlyChildren(ListIterator<? extends P> parents, Transformer<? super P, ? extends ListIterator<? extends E>> childrenTransformer) {
        return IteratorTools.concatenateReadOnly(IteratorTools.transform(parents, childrenTransformer));
    }

    public static <E> Iterator<E> emptyIterator() {
        return EmptyIterator.instance();
    }

    public static <E> ListIterator<E> emptyListIterator() {
        return EmptyListIterator.instance();
    }

    public static <E> FilteringIterator<E> filter(Iterator<? extends E> iterator, Predicate<? super E> predicate) {
        return new FilteringIterator<E>(iterator, predicate);
    }

    public static <E> FilteringIterator<E> removeNulls(Iterator<? extends E> iterator) {
        return IteratorTools.filter(iterator, PredicateTools.isNotNull());
    }

    public static <E> GraphIterator<E> graphIterator(E root, Transformer<? super E, ? extends Iterator<? extends E>> transformer) {
        return IteratorTools.graphIterator(IteratorTools.singletonIterator(root), transformer);
    }

    public static <E> GraphIterator<E> graphIterator(E[] roots, Transformer<? super E, ? extends Iterator<? extends E>> transformer) {
        return IteratorTools.graphIterator(IteratorTools.iterator(roots), transformer);
    }

    public static <E> GraphIterator<E> graphIterator(Iterator<? extends E> roots, Transformer<? super E, ? extends Iterator<? extends E>> transformer) {
        return new GraphIterator<E>(roots, transformer);
    }

    public static <E> EnumerationIterator<E> iterator(Enumeration<E> enumeration) {
        return new EnumerationIterator<E>(enumeration);
    }

    public static <E> ArrayIterator<E> iterator(E ... array) {
        return IteratorTools.iterator(array, 0);
    }

    public static <E> ArrayIterator<E> iterator(E[] array, int start) {
        return IteratorTools.iterator(array, start, array.length);
    }

    public static <E> ArrayIterator<E> iterator(E[] array, int start, int end) {
        return new ArrayIterator<E>(array, start, end);
    }

    public static <E> QueueIterator<E> iterator(Queue<? extends E> queue) {
        return new QueueIterator<E>(queue);
    }

    public static <E> StackIterator<E> iterator(Stack<? extends E> stack) {
        return new StackIterator<E>(stack);
    }

    public static <E> ArrayListIterator<E> listIterator(E ... array) {
        return IteratorTools.listIterator(array, 0);
    }

    public static <E> ArrayListIterator<E> listIterator(E[] array, int start) {
        return IteratorTools.listIterator(array, start, array.length);
    }

    public static <E> ArrayListIterator<E> listIterator(E[] array, int start, int end) {
        return new ArrayListIterator<E>(array, start, end);
    }

    public static <E> NullElementIterator<E> nullElementIterator(int size) {
        return new NullElementIterator(size);
    }

    public static <E> NullElementListIterator<E> nullElementListIterator(int size) {
        return new NullElementListIterator(size);
    }

    public static <E> PeekableIterator<E> peekable(Iterator<? extends E> iterator) {
        return new PeekableIterator<E>(iterator);
    }

    public static <E> ReadOnlyIterator<E> readOnly(Iterator<? extends E> iterator) {
        return new ReadOnlyIterator<E>(iterator);
    }

    public static <E> ReadOnlyListIterator<E> readOnly(ListIterator<? extends E> iterator) {
        return new ReadOnlyListIterator<E>(iterator);
    }

    public static <E> RepeatingElementIterator<E> repeatingElementIterator(E element, int size) {
        return new RepeatingElementIterator<E>(element, size);
    }

    public static <E> RepeatingElementListIterator<E> repeatingElementListIterator(E element, int size) {
        return new RepeatingElementListIterator<E>(element, size);
    }

    public static <E> ReverseIterator<E> reverse(Iterator<? extends E> iterator) {
        return new ReverseIterator<E>(iterator);
    }

    public static <E> ReverseIterator<E> reverse(Iterator<? extends E> iterator, int iteratorSize) {
        return new ReverseIterator<E>(iterator, iteratorSize);
    }

    public static <E> SingleElementIterator<E> singletonIterator(E value) {
        return new SingleElementIterator<E>(value);
    }

    public static <E> SingleElementListIterator<E> singletonListIterator(E value) {
        return new SingleElementListIterator<E>(value);
    }

    public static <E> SynchronizedIterator<E> synchronize(Iterator<? extends E> iterator) {
        return new SynchronizedIterator<E>(iterator);
    }

    public static <E> SynchronizedIterator<E> synchronize(Iterator<? extends E> iterator, Object mutex) {
        return new SynchronizedIterator<E>(iterator, mutex);
    }

    public static <E> SynchronizedListIterator<E> synchronize(ListIterator<E> iterator) {
        return new SynchronizedListIterator<E>(iterator);
    }

    public static <E> SynchronizedListIterator<E> synchronize(ListIterator<E> iterator, Object mutex) {
        return new SynchronizedListIterator<E>(iterator, mutex);
    }

    public static <E1, E2> TransformationIterator<E1, E2> transform(Iterator<? extends E1> iterator, Transformer<? super E1, ? extends E2> transformer) {
        return new TransformationIterator<E1, E2>(iterator, transformer);
    }

    public static <E1, E2> TransformationListIterator<E1, E2> transform(ListIterator<? extends E1> iterator, Transformer<? super E1, ? extends E2> transformer) {
        return new TransformationListIterator<E1, E2>(iterator, transformer);
    }

    public static <E> TreeIterator<E> treeIterator(E root, Transformer<? super E, ? extends Iterator<? extends E>> transformer) {
        return IteratorTools.treeIterator(IteratorTools.singletonIterator(root), transformer);
    }

    public static <E> TreeIterator<E> treeIterator(E[] roots, Transformer<? super E, ? extends Iterator<? extends E>> transformer) {
        return IteratorTools.treeIterator(IteratorTools.iterator(roots), transformer);
    }

    public static <E> TreeIterator<E> treeIterator(Iterator<? extends E> roots, Transformer<? super E, ? extends Iterator<? extends E>> transformer) {
        return new TreeIterator<E>(roots, transformer);
    }

    private IteratorTools() {
        throw new UnsupportedOperationException();
    }
}

