/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.spec;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.spec.IValidator;
import org.eclipse.datatools.connectivity.oda.spec.manifest.ExtensionContributor;

public class ValidationContext {
    private static final String NAMESPACE = ValidationContext.class.getName();
    protected static final String DATA_PROPERTY_QUERY_TEXT = String.valueOf(NAMESPACE) + ".QueryTextProp";
    protected static final String DATA_PROPERTY_CONNECTION = String.valueOf(NAMESPACE) + ".ConnProp";
    private ExtensionContributor m_contributor;
    private IValidator m_validator;
    private Map<String, Object> m_customData;

    public ValidationContext(ExtensionContributor contributor) {
        this.m_contributor = contributor;
    }

    public ValidationContext(IValidator validator) {
        this.m_validator = validator;
    }

    public ExtensionContributor getContributor() {
        return this.m_contributor;
    }

    public IValidator getValidator() {
        if (this.m_validator != null) {
            return this.m_validator;
        }
        if (this.m_contributor != null) {
            try {
                this.m_validator = this.m_contributor.getValidator();
                return this.m_validator;
            }
            catch (OdaException odaException) {}
        }
        return null;
    }

    public void setValidator(IValidator validator) {
        this.m_validator = validator;
    }

    public Object getData(String key) {
        if (this.m_customData == null) {
            return null;
        }
        return this.m_customData.get(key);
    }

    public void setData(String key, Object value) {
        if (this.m_customData == null) {
            this.m_customData = new HashMap<String, Object>();
        }
        this.m_customData.put(key, value);
    }

    public String getQueryText() {
        Object value = this.getData(DATA_PROPERTY_QUERY_TEXT);
        return value instanceof String ? (String)value : null;
    }

    public void setQueryText(String queryText) {
        this.setData(DATA_PROPERTY_QUERY_TEXT, queryText);
    }

    public Connection getConnection() {
        Object value = this.getData(DATA_PROPERTY_CONNECTION);
        return value instanceof Connection ? (Connection)value : null;
    }

    public void setConnection(Connection validationConn) {
        this.setData(DATA_PROPERTY_CONNECTION, validationConn);
    }

    public class Connection {
        private Properties m_properties;

        public Connection(Properties props) {
            this.m_properties = props;
        }

        public Properties getProperties() {
            return this.m_properties;
        }

        public void setProperties(Properties props) {
            if (!this.hasProperties(props)) {
                this.close();
                this.m_properties = props;
            }
        }

        public void close() {
            IValidator validator;
            if (this.m_properties != null && !this.m_properties.isEmpty() && (validator = ValidationContext.this.getValidator()) != null) {
                validator.closeConnection(this);
            }
        }

        private boolean hasProperties(Properties props) {
            if (props == null || props.isEmpty() || props == this.m_properties) {
                return true;
            }
            if (this.m_properties == null || this.m_properties.isEmpty()) {
                return false;
            }
            if (props.size() > this.m_properties.size()) {
                return false;
            }
            for (Map.Entry<Object, Object> newPropEntry : props.entrySet()) {
                Object key = newPropEntry.getKey();
                Object value = newPropEntry.getValue();
                if (!(value == null ? !this.m_properties.containsKey(key) || this.m_properties.get(key) != null : !value.equals(this.m_properties.get(key)))) continue;
                return false;
            }
            return true;
        }
    }
}

