/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.hook.core.model.internal;

import com.liferay.ide.hook.core.HookCore;
import com.liferay.ide.hook.core.model.Hook;
import com.liferay.ide.hook.core.model.PortalProperty;
import com.liferay.ide.hook.core.model.internal.HookListBindingImpl;
import com.liferay.ide.hook.core.model.internal.HookMethods;
import com.liferay.ide.hook.core.model.internal.NameValueObject;
import com.liferay.ide.properties.core.PortalPropertiesConfiguration;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.eclipse.core.resources.IFile;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyBinding;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.ValuePropertyBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortalPropertiesBindingImpl
extends HookListBindingImpl {
    private PropertiesConfiguration portalPropertiesConfiguration;
    private List<NameValueObject> properties = new ArrayList<NameValueObject>();

    private int findDuplicates(String oldName) {
        int found = 0;
        for (NameValueObject prop : this.properties) {
            if (prop.getName() == null || !prop.getName().equals(oldName)) continue;
            ++found;
        }
        return found;
    }

    public void flush() {
        if (this.portalPropertiesConfiguration != null) {
            try {
                StringWriter output = new StringWriter();
                this.portalPropertiesConfiguration.save((Writer)output);
                IFile propsFile = HookMethods.getPortalPropertiesFile(this.hook(), false);
                if (propsFile != null) {
                    ByteArrayInputStream contents = new ByteArrayInputStream(output.toString().getBytes());
                    if (propsFile.exists()) {
                        propsFile.setContents((InputStream)contents, 1, null);
                    } else {
                        propsFile.create((InputStream)contents, true, null);
                    }
                    propsFile.refreshLocal(1, null);
                }
            }
            catch (Exception e) {
                HookCore.logError(e);
            }
        }
    }

    public void init(Property property) {
        super.init(property);
        FilteredListener<PropertyContentEvent> listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                PortalPropertiesBindingImpl.this.updateConfigurationForFile();
            }
        };
        this.hook().attach((Listener)listener, String.valueOf(Hook.PROP_PORTAL_PROPERTIES_FILE.name()) + "/*");
        this.updateConfigurationForFile();
    }

    protected Object insertUnderlyingObject(ElementType type, int position) {
        NameValueObject retval = null;
        if (type.equals(PortalProperty.TYPE)) {
            retval = new NameValueObject();
            this.properties.add(retval);
        }
        return retval;
    }

    protected List<?> readUnderlyingList() {
        return this.properties;
    }

    public void remove(Resource resource) {
        if (resource instanceof PortalPropertyResource) {
            PortalPropertyResource ppResource = (PortalPropertyResource)resource;
            this.properties.remove(ppResource.getNameValue());
            int found = this.findDuplicates(ppResource.getName());
            if (found < 1) {
                this.portalPropertiesConfiguration.clearProperty(ppResource.getName());
            }
        }
    }

    protected Resource resource(Object obj) {
        return new PortalPropertyResource(this.property().element().resource(), (NameValueObject)obj);
    }

    public ElementType type(Resource resource) {
        return PortalProperty.TYPE;
    }

    protected void updateConfigurationForFile() {
        IFile portalPropertiesFile = HookMethods.getPortalPropertiesFile(this.hook());
        if (portalPropertiesFile != null && portalPropertiesFile.exists()) {
            try {
                this.portalPropertiesConfiguration = new PortalPropertiesConfiguration();
                InputStream is = portalPropertiesFile.getContents();
                this.portalPropertiesConfiguration.load(is);
                is.close();
            }
            catch (Exception e) {
                HookCore.logError(e);
            }
            Iterator keys = this.portalPropertiesConfiguration.getKeys();
            while (keys.hasNext()) {
                String key = keys.next().toString();
                this.properties.add(new NameValueObject(key, this.portalPropertiesConfiguration.getProperty(key)));
            }
        }
    }

    private class PortalPropertyResource
    extends Resource {
        private NameValueObject nameValue;

        public PortalPropertyResource(Resource parent, NameValueObject nameValue) {
            super(parent);
            this.nameValue = nameValue;
        }

        protected PropertyBinding createBinding(Property property) {
            if (property.definition() == PortalProperty.PROP_NAME) {
                return new ValuePropertyBinding(){

                    public String read() {
                        return PortalPropertyResource.this.getName();
                    }

                    public void write(String value) {
                        PortalPropertyResource.this.setName(value);
                    }
                };
            }
            if (property.definition() == PortalProperty.PROP_VALUE) {
                return new ValuePropertyBinding(){

                    public String read() {
                        return PortalPropertyResource.this.getValue() != null ? PortalPropertyResource.this.getValue().toString() : null;
                    }

                    public void write(String value) {
                        PortalPropertyResource.this.setValue(value);
                    }
                };
            }
            return null;
        }

        public String getName() {
            return this.nameValue.getName();
        }

        public NameValueObject getNameValue() {
            return this.nameValue;
        }

        public Object getValue() {
            return this.nameValue.getValue();
        }

        public void setName(String name) {
            String oldName = this.nameValue.getName();
            int found = PortalPropertiesBindingImpl.this.findDuplicates(oldName);
            if (found <= 1) {
                PortalPropertiesBindingImpl.this.portalPropertiesConfiguration.clearProperty(oldName);
            }
            this.nameValue.setName(name);
            this.setValue(this.nameValue.getValue());
        }

        public void setValue(Object value) {
            this.nameValue.setValue(value);
            int found = PortalPropertiesBindingImpl.this.findDuplicates(this.getName());
            if (found <= 1 && PortalPropertiesBindingImpl.this.portalPropertiesConfiguration != null) {
                PortalPropertiesBindingImpl.this.portalPropertiesConfiguration.setProperty(this.getName(), value);
            }
        }
    }
}

