/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core;

import com.liferay.ide.core.ILiferayProject;
import com.liferay.ide.project.core.IPortletFramework;
import com.liferay.ide.project.core.LiferayProjectCore;
import com.liferay.ide.project.core.LiferayRuntimeProject;
import com.liferay.ide.project.core.NewLiferayProjectProvider;
import com.liferay.ide.project.core.ProjectRecord;
import com.liferay.ide.project.core.model.NewLiferayPluginProjectOp;
import com.liferay.ide.project.core.model.NewLiferayPluginProjectOpMethods;
import com.liferay.ide.project.core.model.PluginType;
import com.liferay.ide.project.core.util.ProjectUtil;
import com.liferay.ide.project.core.util.WizardUtil;
import com.liferay.ide.sdk.core.SDK;
import com.liferay.ide.sdk.core.SDKManager;
import com.liferay.ide.server.core.ILiferayRuntime;
import com.liferay.ide.server.util.ServerUtil;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.wst.server.core.IRuntime;
import org.osgi.framework.Version;
import org.osgi.service.prefs.BackingStoreException;

public class PluginsSDKProjectProvider
extends NewLiferayProjectProvider {
    public PluginsSDKProjectProvider() {
        super(new Class[]{IProject.class, IRuntime.class});
    }

    public IStatus doCreateNewProject(NewLiferayPluginProjectOp op, IProgressMonitor monitor) throws CoreException {
        String sdkName = (String)op.getPluginsSDKName().content(true);
        PluginType pluginType = (PluginType)((Object)op.getPluginType().content(true));
        String originalProjectName = (String)op.getProjectName().content();
        String pluginTypeSuffix = NewLiferayPluginProjectOpMethods.getPluginTypeSuffix(pluginType);
        String fixedProjectName = originalProjectName;
        if (originalProjectName.endsWith(pluginTypeSuffix)) {
            fixedProjectName = originalProjectName.substring(0, originalProjectName.length() - pluginTypeSuffix.length());
        }
        String projectName = fixedProjectName;
        String displayName = (String)op.getDisplayName().content(true);
        SDK sdk = SDKManager.getInstance().getSDK(sdkName);
        IRuntime runtime = NewLiferayPluginProjectOpMethods.getRuntime(op);
        ILiferayRuntime liferayRuntime = ServerUtil.getLiferayRuntime((IRuntime)runtime, (IProgressMonitor)monitor);
        Map appServerProperties = ServerUtil.configureAppServerProperties((ILiferayRuntime)liferayRuntime);
        String workingDir = null;
        String baseDir = null;
        boolean updateBaseDir = false;
        if (!((Boolean)op.getUseDefaultLocation().content()).booleanValue() || ((Boolean)op.getUseDefaultLocation().content()).booleanValue() && !((Boolean)op.getUseSdkLocation().content()).booleanValue()) {
            updateBaseDir = true;
        }
        IPath newSDKProjectPath = null;
        switch (pluginType) {
            case servicebuilder: {
                op.setPortletFramework("mvc");
            }
            case portlet: {
                String frameworkName = this.getFrameworkName(op);
                workingDir = sdk.getLocation().append("portlets").toOSString();
                baseDir = updateBaseDir ? workingDir : null;
                newSDKProjectPath = sdk.createNewPortletProject(projectName, displayName, frameworkName, appServerProperties, true, workingDir, baseDir, monitor);
                break;
            }
            case hook: {
                workingDir = sdk.getLocation().append("hooks").toOSString();
                baseDir = updateBaseDir ? workingDir : null;
                newSDKProjectPath = sdk.createNewHookProject(projectName, displayName, true, workingDir, baseDir, monitor);
                break;
            }
            case ext: {
                workingDir = sdk.getLocation().append("ext").toOSString();
                baseDir = updateBaseDir ? workingDir : null;
                newSDKProjectPath = sdk.createNewExtProject(projectName, displayName, appServerProperties, true, workingDir, baseDir, monitor);
                break;
            }
            case layouttpl: {
                workingDir = sdk.getLocation().append("layouttpl").toOSString();
                baseDir = updateBaseDir ? workingDir : null;
                newSDKProjectPath = sdk.createNewLayoutTplProject(projectName, displayName, appServerProperties, true, workingDir, baseDir, monitor);
                break;
            }
            case theme: {
                workingDir = sdk.getLocation().append("themes").toOSString();
                baseDir = updateBaseDir ? workingDir : null;
                newSDKProjectPath = sdk.createNewThemeProject(projectName, displayName, true, workingDir, baseDir, monitor);
            }
        }
        Path projectLocation = (Path)op.getLocation().content();
        File projectDir = projectLocation.toFile();
        File projectParent = projectDir.getParentFile();
        projectParent.mkdirs();
        File newSDKProjectDir = newSDKProjectPath.toFile();
        try {
            FileUtils.copyDirectory((File)newSDKProjectDir, (File)projectParent);
            FileUtils.deleteDirectory((File)newSDKProjectDir);
        }
        catch (IOException e) {
            throw new CoreException(LiferayProjectCore.createErrorStatus((Exception)e));
        }
        ProjectRecord projectRecord = ProjectUtil.getProjectRecordForDir(projectLocation.toOSString());
        String sdkLocation = sdk.getLocation().toOSString();
        IProject newProject = ProjectUtil.importProject(projectRecord, ServerUtil.getFacetRuntime((IRuntime)runtime), sdkLocation, op, monitor);
        newProject.open(monitor);
        if (baseDir != null) {
            try {
                IEclipsePreferences prefs = new ProjectScope(newProject).getNode("com.liferay.ide.sdk.core");
                prefs.put("sdk-name", sdkName);
                prefs.flush();
            }
            catch (BackingStoreException e) {
                LiferayProjectCore.logError("Unable to persist sdk name to project " + projectName, (Exception)((Object)e));
            }
        }
        op.setFinalProjectName(newProject.getName());
        switch ((PluginType)((Object)op.getPluginType().content())) {
            case portlet: {
                this.portletProjectCreated(op, newProject, monitor);
                break;
            }
            case servicebuilder: {
                this.serviceBuilderProjectCreated(op, liferayRuntime.getPortalVersion(), newProject, monitor);
                break;
            }
            case theme: {
                this.themeProjectCreated(newProject);
                break;
            }
        }
        return Status.OK_STATUS;
    }

    private void portletProjectCreated(NewLiferayPluginProjectOp op, IProject newProject, IProgressMonitor monitor) throws CoreException {
        String frameworkName;
        IPortletFramework portletFramework = (IPortletFramework)op.getPortletFramework().content();
        IStatus status = portletFramework.postProjectCreated(newProject, frameworkName = this.getFrameworkName(op), monitor);
        if (!status.isOK()) {
            throw new CoreException(status);
        }
    }

    public ILiferayProject provide(Object type) {
        LiferayRuntimeProject retval = null;
        IProject project = null;
        ILiferayRuntime liferayRuntime = null;
        if (type instanceof IProject) {
            project = (IProject)type;
            try {
                liferayRuntime = ServerUtil.getLiferayRuntime((IProject)project);
            }
            catch (CoreException coreException) {}
        } else if (type instanceof IRuntime) {
            try {
                IRuntime runtime = (IRuntime)type;
                liferayRuntime = ServerUtil.getLiferayRuntime((IRuntime)runtime);
            }
            catch (Exception exception) {}
        }
        if (liferayRuntime != null) {
            retval = new LiferayRuntimeProject(project, liferayRuntime);
        }
        return retval;
    }

    private void serviceBuilderProjectCreated(NewLiferayPluginProjectOp op, String version, IProject newProject, IProgressMonitor monitor) throws CoreException {
        IFile serviceXmlFile = newProject.getFile("docroot/WEB-INF/service.xml");
        String descriptorVersion = null;
        try {
            Version portalVersion = new Version(version);
            descriptorVersion = String.valueOf(portalVersion.getMajor()) + "." + portalVersion.getMinor() + ".0";
        }
        catch (Exception e) {
            LiferayProjectCore.logError("Could not determine liferay runtime version", e);
            descriptorVersion = "6.0.0";
        }
        WizardUtil.createDefaultServiceBuilderFile(serviceXmlFile, descriptorVersion, true, "com.liferay.sample", "SAMPLE", System.getProperty("user.name"), monitor);
    }

    private void themeProjectCreated(IProject newProject) throws CoreException {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("force", "true");
        newProject.build(6, "com.liferay.ide.eclipse.theme.core.cssBuilder", args, null);
    }

    public IStatus validateProjectLocation(String name, IPath path) {
        IStatus retval = Status.OK_STATUS;
        if (path.append(".project").toFile().exists()) {
            retval = LiferayProjectCore.createErrorStatus((String)("\"" + path + "\" is not valid because a project already exists at that location."));
        } else {
            File pathFile = path.toFile();
            if (pathFile.exists() && pathFile.isDirectory() && pathFile.listFiles().length > 0) {
                retval = LiferayProjectCore.createErrorStatus((String)("\"" + path + "\" is not valid because it already contains files."));
            }
        }
        return retval;
    }
}

