/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core.model.internal;

import com.liferay.ide.core.ILiferayProjectProvider;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.project.core.model.NewLiferayPluginProjectOp;
import com.liferay.ide.project.core.model.NewLiferayPluginProjectOpMethods;
import com.liferay.ide.project.core.model.PluginType;
import com.liferay.ide.sdk.core.SDK;
import com.liferay.ide.sdk.core.SDKManager;
import org.eclipse.core.runtime.IPath;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.platform.PathBridge;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectNameListener
extends FilteredListener<PropertyContentEvent> {
    protected void handleTypedEvent(PropertyContentEvent event) {
        ProjectNameListener.updateLocation(this.op(event));
    }

    protected NewLiferayPluginProjectOp op(PropertyContentEvent event) {
        return (NewLiferayPluginProjectOp)event.property().element().nearest(NewLiferayPluginProjectOp.class);
    }

    public static void updateLocation(NewLiferayPluginProjectOp op) {
        String currentProjectName = (String)op.getProjectName().content();
        boolean useDefaultLocation = (Boolean)op.getUseDefaultLocation().content(true);
        if (currentProjectName != null && useDefaultLocation) {
            Path newLocationBase = null;
            if (((ILiferayProjectProvider)op.getProjectProvider().content(true)).getShortName().equals("ant") && ((Boolean)op.getUseSdkLocation().content(true)).booleanValue()) {
                String pluginsSdk = (String)op.getPluginsSDKName().content(true);
                SDK sdk = SDKManager.getInstance().getSDK(pluginsSdk);
                if (sdk != null) {
                    Path sdkLocation = PathBridge.create((IPath)sdk.getLocation());
                    switch ((PluginType)((Object)op.getPluginType().content(true))) {
                        case portlet: 
                        case servicebuilder: {
                            newLocationBase = sdkLocation.append("portlets");
                            break;
                        }
                        case ext: {
                            newLocationBase = sdkLocation.append("ext");
                            break;
                        }
                        case hook: {
                            newLocationBase = sdkLocation.append("hooks");
                            break;
                        }
                        case layouttpl: {
                            newLocationBase = sdkLocation.append("layouttpl");
                            break;
                        }
                        case theme: {
                            newLocationBase = sdkLocation.append("themes");
                        }
                        default: {
                            break;
                        }
                    }
                }
            } else {
                newLocationBase = PathBridge.create((IPath)CoreUtil.getWorkspaceRoot().getLocation());
            }
            if (newLocationBase != null) {
                NewLiferayPluginProjectOpMethods.updateLocation(op, newLocationBase);
            }
        }
    }
}

